/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.common.core.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.log.TraceCompassLog;
import org.eclipse.tracecompass.common.core.log.TraceCompassLogUtils;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public final class XmlUtils {
    private static final Logger LOGGER = TraceCompassLog.getLogger(XmlUtils.class);
    private static final String EMPTY = "";
    private static final String DISALLOW_DOCTYPE_DECL = "http://apache.org/xml/features/disallow-doctype-decl";
    private static final String NONVALIDATING_LOAD_EXTERNAL_DTD = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    private static final String USE_EXTERNAL_PARAMETER_ENTITIES = "http://xml.org/sax/features/external-parameter-entities";
    private static final String ACCESS_EXTERNAL_GENERAL_ENTITIES = "http://xml.org/sax/features/external-general-entities";

    private XmlUtils() {
    }

    public static Transformer newSecureTransformer() throws TransformerConfigurationException {
        TransformerFactory factory = TransformerFactory.newInstance();
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        return factory.newTransformer();
    }

    public static DocumentBuilderFactory newSafeDocumentBuilderFactory() {
        String feature = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            feature = "http://javax.xml.XMLConstants/feature/secure-processing";
            dbf.setFeature(feature, true);
        }
        catch (ParserConfigurationException e) {
            XmlUtils.logException(feature, e);
        }
        try {
            feature = DISALLOW_DOCTYPE_DECL;
            dbf.setFeature(feature, true);
        }
        catch (ParserConfigurationException e) {
            XmlUtils.logException(feature, e);
        }
        try {
            feature = ACCESS_EXTERNAL_GENERAL_ENTITIES;
            dbf.setFeature(feature, false);
        }
        catch (ParserConfigurationException e) {
            XmlUtils.logException(feature, e);
        }
        try {
            feature = USE_EXTERNAL_PARAMETER_ENTITIES;
            dbf.setFeature(feature, false);
        }
        catch (ParserConfigurationException e) {
            XmlUtils.logException(feature, e);
        }
        try {
            feature = NONVALIDATING_LOAD_EXTERNAL_DTD;
            dbf.setFeature(feature, false);
        }
        catch (ParserConfigurationException e) {
            XmlUtils.logException(feature, e);
        }
        dbf.setXIncludeAware(false);
        dbf.setExpandEntityReferences(false);
        return dbf;
    }

    private static void logException(String feature, ParserConfigurationException e) {
        TraceCompassLogUtils.traceInstant(LOGGER, Level.WARNING, "ParserConfigurationException", "feature", feature, "stack", e.getStackTrace());
    }

    public static @Nullable XMLStreamReader newSafeXmlStreamReader(InputStream inputStream) throws XMLStreamException {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        return factory.createXMLStreamReader(inputStream);
    }

    public static SchemaFactory newSafeSchemaFactory() throws SAXException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        factory.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", EMPTY);
        factory.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", EMPTY);
        return factory;
    }

    public static void safeValidate(Schema schema, Source source) throws SAXException, IOException {
        Validator validator = schema.newValidator();
        validator.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", EMPTY);
        validator.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", EMPTY);
        validator.validate(source);
    }

    public static SAXParserFactory newSafeSaxParserFactory() throws SAXNotRecognizedException, SAXNotSupportedException, ParserConfigurationException {
        SAXParserFactory parserFactory = SAXParserFactory.newInstance();
        parserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        parserFactory.setFeature(ACCESS_EXTERNAL_GENERAL_ENTITIES, false);
        parserFactory.setFeature(USE_EXTERNAL_PARAMETER_ENTITIES, false);
        parserFactory.setFeature(NONVALIDATING_LOAD_EXTERNAL_DTD, false);
        parserFactory.setFeature(DISALLOW_DOCTYPE_DECL, true);
        parserFactory.setNamespaceAware(true);
        return parserFactory;
    }
}

