/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.console;

import org.eclipse.equinox.internal.p2.console.ProvCommandProvider;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class Activator
implements BundleActivator,
ServiceTrackerCustomizer<IProvisioningAgent, IProvisioningAgent> {
    public static final String PLUGIN_ID = "org.eclipse.equinox.p2.console";
    private static final String PROVIDER_NAME = "org.eclipse.osgi.framework.console.CommandProvider";
    private static BundleContext context;
    private ServiceTracker<IProvisioningAgent, IProvisioningAgent> agentTracker;
    private IProvisioningAgent provAgent;
    private ProvCommandProvider provider;
    private ServiceRegistration<?> providerRegistration = null;

    public static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext ctxt) throws Exception {
        context = ctxt;
        boolean registerCommands = true;
        try {
            Class.forName(PROVIDER_NAME);
        }
        catch (ClassNotFoundException classNotFoundException) {
            registerCommands = false;
        }
        if (registerCommands) {
            this.agentTracker = new ServiceTracker(context, IProvisioningAgent.class, (ServiceTrackerCustomizer)this);
            this.agentTracker.open();
        }
    }

    public void stop(BundleContext ctxt) throws Exception {
        this.agentTracker.close();
        if (this.providerRegistration != null) {
            this.providerRegistration.unregister();
        }
        this.providerRegistration = null;
        this.provAgent = null;
        context = null;
    }

    public IProvisioningAgent addingService(ServiceReference<IProvisioningAgent> reference) {
        if (this.providerRegistration != null) {
            return null;
        }
        if (!Boolean.TRUE.toString().equals(reference.getProperty("agent.current"))) {
            return null;
        }
        BundleContext ctxt = Activator.getContext();
        IProvisioningAgent agent = (IProvisioningAgent)ctxt.getService(reference);
        this.provider = new ProvCommandProvider(ctxt.getProperty("eclipse.p2.profile"), agent);
        this.providerRegistration = ctxt.registerService(PROVIDER_NAME, (Object)this.provider, null);
        this.provAgent = agent;
        return agent;
    }

    public void modifiedService(ServiceReference<IProvisioningAgent> reference, IProvisioningAgent service) {
    }

    public void removedService(ServiceReference<IProvisioningAgent> reference, IProvisioningAgent service) {
        if (this.provAgent != service) {
            return;
        }
        if (this.providerRegistration != null) {
            this.providerRegistration.unregister();
        }
        this.providerRegistration = null;
        this.provider = null;
        this.provAgent = null;
    }
}

