/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.data;

import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.webapp.WebappResources;
import org.eclipse.help.internal.webapp.data.UrlUtil;

public class ServletResources {
    protected ServletResources() {
    }

    public static String getConfirmShowAllExplanation(HttpServletRequest request) {
        String message = HelpBasePlugin.getActivitySupport().getShowAllMessage();
        if (message == null) {
            message = ServletResources.getString("confirmShowAllExplanation", request);
        }
        return message;
    }

    public static String getString(String name, HttpServletRequest request) {
        String property = WebappResources.getString(name, UrlUtil.getLocaleObj(request, null));
        if (property == null || property.length() <= 0) {
            return property;
        }
        int amp = property.indexOf(38);
        if (amp < 0 || amp >= property.length() - 1) {
            return property;
        }
        return property.substring(0, amp) + property.substring(amp + 1);
    }

    public static String getString(String name, String replace0, HttpServletRequest request) {
        String property = WebappResources.getString(name, UrlUtil.getLocaleObj(request, null), replace0);
        return property;
    }

    public static String getString(String name, String[] args, HttpServletRequest request) {
        String property = WebappResources.getString(name, UrlUtil.getLocaleObj(request, null), args);
        return property;
    }

    public static String getLabel(String name, HttpServletRequest request) {
        String property = WebappResources.getString(name, UrlUtil.getLocaleObj(request, null));
        if (property == null || property.length() <= 0) {
            return property;
        }
        int amp = property.indexOf(38);
        if (amp < 0 || amp >= property.length() - 1) {
            return property;
        }
        boolean isIE = UrlUtil.isIE(request);
        String acceleratorPrefix = isIE ? "<u STYLE=\"ACCELERATOR:true\">" : "";
        String acceleratorSuffix = isIE ? "</u>" : "";
        return property.substring(0, amp) + acceleratorPrefix + property.charAt(amp + 1) + acceleratorSuffix + property.substring(amp + 2);
    }

    public static String getAccessKey(String name, HttpServletRequest request) {
        String property = WebappResources.getString(name, UrlUtil.getLocaleObj(request, null));
        if (property == null || property.length() <= 0) {
            return null;
        }
        int amp = property.indexOf(38);
        if (amp < 0 || amp >= property.length() - 1) {
            return null;
        }
        return ("" + property.charAt(amp + 1)).toLowerCase(Locale.ENGLISH);
    }
}

