/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.ui.internal.dialog;

import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNatureDescriptor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.internal.ProjectFacet;
import org.eclipse.wst.validation.internal.model.FilterRule;
import org.eclipse.wst.validation.internal.model.ValidatorHelper;
import org.eclipse.wst.validation.ui.internal.ValUIMessages;

public class NewFilterRule
extends Wizard {
    private Page1 _page1;
    private IWizardPage _page2;
    private IProject _project;
    private FilterRule _rule;

    public NewFilterRule(IProject project) {
        this._project = project;
        this.setWindowTitle(ValUIMessages.FrWizard);
        this._page1 = new Page1(project);
        this.addPage((IWizardPage)this._page1);
        this.setForcePreviousAndNextButtons(true);
    }

    public boolean canFinish() {
        if (this._page2 != null) {
            return this._page2.isPageComplete();
        }
        return false;
    }

    public FilterRule getRule() {
        return this._rule;
    }

    public boolean performFinish() {
        if (this._page2 == null) {
            return false;
        }
        FilterWizardPage page = (FilterWizardPage)this._page2;
        this._rule = page.getFilterRule();
        return this._rule != null;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this._page1) {
            this.setForcePreviousAndNextButtons(false);
            this._page2 = this.returnOrBuildPage(this._page1.getSelectedFilter());
            return this._page2;
        }
        return null;
    }

    private IWizardPage returnOrBuildPage(int selectedFilter) {
        WizardPage page = null;
        if (this._project != null) {
            if (selectedFilter == 2) {
                selectedFilter = 4;
            } else if (selectedFilter == 3) {
                selectedFilter = 5;
            }
        }
        switch (selectedFilter) {
            case 0: {
                page = new FileExtPage();
                break;
            }
            case 1: {
                page = new FilePage(this._project);
                break;
            }
            case 2: {
                page = new ProjectPage();
                break;
            }
            case 3: {
                page = new FacetPage();
                break;
            }
            case 4: {
                page = new ContentTypePage();
                break;
            }
            case 5: {
                page = new TargetRuntimePage();
            }
        }
        this.addPage((IWizardPage)page);
        return page;
    }

    public static class ContentTypePage
    extends WizardPage
    implements FilterWizardPage {
        private Combo _pattern;
        private Button _exactMatch;
        private Map<String, IContentType> _map;

        public ContentTypePage() {
            super("contentType", ValUIMessages.FrContentType, null);
        }

        public void createControl(Composite parent) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.wst.validation.ui.jvgp0105");
            Composite control = new Composite(parent, 0);
            this.setControl((Control)control);
            control.setLayout((Layout)new GridLayout(2, false));
            new Label(control, 0).setText(ValUIMessages.FrContentTypeLabel);
            IContentType[] types = Platform.getContentTypeManager().getAllContentTypes();
            this._map = new TreeMap<String, IContentType>();
            IContentType[] iContentTypeArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                IContentType type = iContentTypeArray[n2];
                Object name = type.getName();
                name = name == null ? type.getId() : (String)name + " - " + type.getId();
                this._map.put((String)name, type);
                ++n2;
            }
            String[] items = new String[this._map.size()];
            int i = 0;
            for (String label : this._map.keySet()) {
                items[i++] = label;
            }
            this._pattern = new Combo(control, 12);
            this._pattern.setFocus();
            this._pattern.setLayoutData((Object)new GridData(300, -1));
            this._pattern.setVisibleItemCount(20);
            this._pattern.setItems(items);
            this._pattern.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    this.getContainer().updateButtons();
                }
            });
            this._exactMatch = new Button(control, 32);
            this._exactMatch.setText(ValUIMessages.FrExactMatch);
            this._exactMatch.setSelection(false);
            this._exactMatch.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        }

        @Override
        public FilterRule getFilterRule() {
            if (!this.isPageComplete()) {
                return null;
            }
            IContentType type = this._map.get(this._pattern.getText());
            if (type == null) {
                return null;
            }
            FilterRule rule = FilterRule.createContentType((String)type.getId(), (boolean)this._exactMatch.getSelection());
            return rule;
        }

        public boolean isPageComplete() {
            if (this._pattern == null) {
                return false;
            }
            if (this._pattern.getText() == null) {
                return false;
            }
            return this._pattern.getText().trim().length() > 0;
        }
    }

    public static class FacetPage
    extends WizardPage
    implements FilterWizardPage {
        private Combo facets;
        private String[] ids;

        public FacetPage() {
            super("facet", ValUIMessages.FrFacit, null);
        }

        public void createControl(Composite parent) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.wst.validation.ui.jvgp0104");
            Composite control = new Composite(parent, 0);
            this.setControl((Control)control);
            control.setLayout((Layout)new GridLayout(2, false));
            new Label(control, 0).setText(ValUIMessages.FrNewFacitLabel);
            Set projectFacets = ProjectFacetsManager.getProjectFacets();
            Object[] projectFacetsArray = projectFacets.toArray();
            String[] items = new String[projectFacetsArray.length];
            this.ids = new String[projectFacetsArray.length];
            int i = 0;
            while (i < projectFacetsArray.length) {
                ProjectFacet facet = (ProjectFacet)projectFacetsArray[i];
                this.ids[i] = facet.getId();
                items[i] = facet.getLabel() + " - " + this.ids[i];
                ++i;
            }
            this.facets = new Combo(control, 4);
            this.facets.setItems(items);
            this.facets.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    this.getContainer().updateButtons();
                }
            });
        }

        @Override
        public FilterRule getFilterRule() {
            if (!this.isPageComplete()) {
                return null;
            }
            int i = this.facets.getSelectionIndex();
            if (i == -1) {
                return null;
            }
            FilterRule rule = FilterRule.createFacet((String)this.ids[i]);
            return rule;
        }

        public boolean isPageComplete() {
            if (this.facets == null) {
                return false;
            }
            if (this.facets.getText() == null) {
                return false;
            }
            return this.facets.getText().trim().length() > 0;
        }
    }

    public static class FileExtPage
    extends WizardPage
    implements FilterWizardPage {
        private Text _pattern;
        private Button _case;

        public FileExtPage() {
            super("fileext", ValUIMessages.FrFileExtension, null);
        }

        public void createControl(Composite parent) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.wst.validation.ui.jvgp0101");
            Composite control = new Composite(parent, 0);
            this.setControl((Control)control);
            control.setLayout((Layout)new GridLayout(2, false));
            new Label(control, 0).setText(ValUIMessages.FrFileExtensionLabel);
            this._pattern = new Text(control, 2048);
            this._pattern.setFocus();
            this._pattern.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    this.getContainer().updateButtons();
                }
            });
            this._case = new Button(control, 32);
            this._case.setText(ValUIMessages.FrCaseSensitive);
            this._case.setSelection(false);
            this._case.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        }

        @Override
        public FilterRule getFilterRule() {
            if (!this.isPageComplete()) {
                return null;
            }
            return FilterRule.FileExt.createFileExt((String)this._pattern.getText(), (boolean)this._case.getSelection());
        }

        public boolean isPageComplete() {
            return this._pattern != null && this._pattern.getText().trim().length() > 0;
        }
    }

    public static class FilePage
    extends WizardPage
    implements FilterWizardPage {
        private Text _pattern;
        private Button _browseFile;
        private Button _browseFolder;
        private Button _case;
        private Button _simpleFileName;
        private IProject _project;
        private int _type = 1;
        private IPath _fullFileName;
        private String _root;

        public FilePage(IProject project) {
            super("file", ValUIMessages.FrFolderOrFile, null);
            this._project = project;
        }

        public void createControl(Composite parent) {
            IPath base;
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.wst.validation.ui.jvgp0102");
            final Composite control = new Composite(parent, 0);
            this.setControl((Control)control);
            control.setLayout((Layout)new GridLayout(4, false));
            new Label(control, 0).setText(ValUIMessages.FrFolderOrFileLabel);
            this._pattern = new Text(control, 2048);
            this._pattern.setFocus();
            this._pattern.setLayoutData((Object)new GridData(300, -1));
            this._pattern.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    this.getContainer().updateButtons();
                }
            });
            this._root = null;
            IPath iPath = base = this._project == null ? ResourcesPlugin.getWorkspace().getRoot().getLocation() : this._project.getLocation();
            if (base != null) {
                this._root = base.toOSString();
            }
            this._browseFile = new Button(control, 8);
            this._browseFile.setText(ValUIMessages.FrBrowseFile);
            this._browseFile.setEnabled(this._root != null);
            this._browseFile.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.browse();
                }

                public void widgetSelected(SelectionEvent e) {
                    this.browse();
                }

                private void browse() {
                    FileDialog fd = new FileDialog(control.getShell(), 4096);
                    fd.setText(ValUIMessages.FrFileFilter);
                    fd.setFilterPath(_root);
                    String file = fd.open();
                    if (file != null) {
                        file = file.startsWith(_root) ? file.substring(_root.length() + 1) : null;
                    }
                    if (file != null) {
                        _fullFileName = new Path(file);
                        if (_project == null) {
                            _fullFileName = _fullFileName.removeFirstSegments(1);
                        }
                        if (_simpleFileName.getSelection()) {
                            _type = 1;
                            _pattern.setText(_fullFileName.lastSegment());
                        } else {
                            _type = 3;
                            _pattern.setText(_fullFileName.toPortableString());
                        }
                    } else {
                        _fullFileName = null;
                        _pattern.setText("");
                    }
                }
            });
            this._browseFolder = new Button(control, 8);
            this._browseFolder.setText(ValUIMessages.FrBrowseFolder);
            this._browseFolder.setEnabled(this._root != null);
            this._browseFolder.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.browse();
                }

                public void widgetSelected(SelectionEvent e) {
                    this.browse();
                }

                private void browse() {
                    DirectoryDialog fd = new DirectoryDialog(control.getShell());
                    fd.setMessage(ValUIMessages.FrFolderFilter);
                    fd.setFilterPath(_root);
                    String dir = fd.open();
                    if (dir != null) {
                        _fullFileName = null;
                        _type = 2;
                        if (dir.startsWith(_root) && dir.length() > _root.length()) {
                            dir = dir.substring(_root.length() + 1);
                            Path path = new Path(dir);
                            if (_project == null) {
                                path = path.removeFirstSegments(1);
                            }
                            _pattern.setText(path.toPortableString());
                        } else {
                            _pattern.setText("");
                        }
                    }
                }
            });
            this._case = new Button(control, 32);
            this._case.setText(ValUIMessages.FrCaseSensitive);
            this._case.setSelection(false);
            this._case.setLayoutData((Object)new GridData(1, 1, false, false, 4, 1));
            this.addSimpleFileNameButton(control);
        }

        private void addSimpleFileNameButton(Composite control) {
            this._simpleFileName = new Button(control, 32);
            this._simpleFileName.setText(ValUIMessages.FrSimpleFileName);
            this._simpleFileName.setSelection(this._type == 1);
            this._simpleFileName.setLayoutData((Object)new GridData(1, 1, false, false, 4, 1));
            this._simpleFileName.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    if (_type == 2) {
                        return;
                    }
                    if (_simpleFileName.getSelection()) {
                        if (_fullFileName != null) {
                            _pattern.setText(_fullFileName.lastSegment());
                        }
                        _type = 1;
                    } else {
                        if (_fullFileName != null) {
                            _pattern.setText(_fullFileName.toPortableString());
                        }
                        _type = 3;
                    }
                }
            });
        }

        @Override
        public FilterRule getFilterRule() {
            if (!this.isPageComplete()) {
                return null;
            }
            return FilterRule.createFile((String)this._pattern.getText(), (boolean)this._case.getSelection(), (int)this._type);
        }

        public boolean isPageComplete() {
            if (this._pattern == null) {
                return false;
            }
            if (this._pattern.getText() == null) {
                return false;
            }
            return this._pattern.getText().trim().length() > 0;
        }
    }

    static interface FilterWizardPage {
        public FilterRule getFilterRule();
    }

    public static class Page1
    extends WizardPage {
        private int _selectedFilter;
        private IProject _project;

        public Page1(IProject project) {
            super("page1", ValUIMessages.FrSelectFilterType, null);
            this.setPageComplete(true);
            this._project = project;
        }

        public void createControl(Composite parent) {
            String helpId = this._project == null ? "org.eclipse.wst.validation.ui.jvgp0100" : "org.eclipse.wst.validation.ui.jvpp0100";
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, helpId);
            String[] labels = null;
            String[] desc = null;
            if (this._project != null) {
                labels = new String[]{ValUIMessages.LabelExtension, ValUIMessages.LabelFile, ValUIMessages.LabelContentType, ValUIMessages.LabelTargetRuntime};
                desc = new String[]{ValUIMessages.DescExtension, ValUIMessages.DescFile, ValUIMessages.DescContentType, ValUIMessages.DescTargetRuntime};
            } else {
                labels = new String[]{ValUIMessages.LabelExtension, ValUIMessages.LabelFile, ValUIMessages.LabelProjects, ValUIMessages.LabelFacets, ValUIMessages.LabelContentType, ValUIMessages.LabelTargetRuntime};
                desc = new String[]{ValUIMessages.DescExtension, ValUIMessages.DescFile, ValUIMessages.DescProjects, ValUIMessages.DescFacets, ValUIMessages.DescContentType, ValUIMessages.DescTargetRuntime};
            }
            Composite control = new Composite(parent, 0);
            control.setLayout((Layout)new GridLayout(2, false));
            SelectionListener listener = new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.doIt(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    this.doIt(e);
                }

                private void doIt(SelectionEvent e) {
                    Button b;
                    if (e.getSource() instanceof Button && (b = (Button)e.getSource()).getData() instanceof Integer) {
                        Integer index = (Integer)b.getData();
                        this.setSelectedFilter(index);
                    }
                }
            };
            int i = 0;
            while (i < labels.length) {
                Button button = new Button(control, 16);
                button.setText(labels[i]);
                button.setData((Object)new Integer(i));
                button.addSelectionListener(listener);
                new Text(control, 72).setText(desc[i]);
                if (i == 0) {
                    button.setSelection(true);
                }
                ++i;
            }
            this.setControl((Control)control);
        }

        public int getSelectedFilter() {
            return this._selectedFilter;
        }

        public void setSelectedFilter(int selectedFilter) {
            this._selectedFilter = selectedFilter;
            this.getContainer().updateButtons();
        }
    }

    public static class ProjectPage
    extends WizardPage
    implements FilterWizardPage {
        private Combo _natures;
        private String[] _ids;

        public ProjectPage() {
            super("project", ValUIMessages.FrProjectNature, null);
        }

        public void createControl(Composite parent) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.wst.validation.ui.jvgp0103");
            Composite control = new Composite(parent, 0);
            this.setControl((Control)control);
            control.setLayout((Layout)new GridLayout(2, false));
            new Label(control, 0).setText(ValUIMessages.FrProjectNatureLabel);
            IProjectNatureDescriptor[] pn = ResourcesPlugin.getWorkspace().getNatureDescriptors();
            String[] items = new String[pn.length];
            this._ids = new String[pn.length];
            String natureLabel = null;
            int i = 0;
            while (i < pn.length) {
                natureLabel = pn[i].getLabel();
                this._ids[i] = pn[i].getNatureId();
                items[i] = natureLabel.length() == 0 ? this._ids[i] : natureLabel + " - " + this._ids[i];
                ++i;
            }
            this._natures = new Combo(control, 4);
            this._natures.setItems(items);
            this._natures.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    this.getContainer().updateButtons();
                }
            });
        }

        @Override
        public FilterRule getFilterRule() {
            if (!this.isPageComplete()) {
                return null;
            }
            int i = this._natures.getSelectionIndex();
            if (i == -1) {
                return null;
            }
            return FilterRule.createProject((String)this._ids[i]);
        }

        public boolean isPageComplete() {
            if (this._natures == null) {
                return false;
            }
            if (this._natures.getText() == null) {
                return false;
            }
            return this._natures.getText().trim().length() > 0;
        }
    }

    public static class TargetRuntimePage
    extends WizardPage
    implements FilterWizardPage {
        private Combo _pattern;
        private String[] ids;

        public TargetRuntimePage() {
            super("targetRuntime", ValUIMessages.FrTargetRuntimeLabel, null);
        }

        public void createControl(Composite parent) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.wst.validation.ui.jvgp0105");
            Composite control = new Composite(parent, 0);
            this.setControl((Control)control);
            control.setLayout((Layout)new GridLayout(2, false));
            new Label(control, 0).setText("Target Runtime");
            Object[] targetRuntimes = ValidatorHelper.getRuntimes();
            String[] items = new String[targetRuntimes.length];
            this.ids = new String[targetRuntimes.length];
            int i = 0;
            while (i < targetRuntimes.length) {
                this.ids[i] = ValidatorHelper.getRuntimeID((Object)targetRuntimes[i]);
                items[i] = ValidatorHelper.getRuntimeName((Object)targetRuntimes[i]);
                ++i;
            }
            this._pattern = new Combo(control, 12);
            this._pattern.setFocus();
            this._pattern.setLayoutData((Object)new GridData(300, -1));
            this._pattern.setVisibleItemCount(20);
            this._pattern.setItems(items);
            this._pattern.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    this.getContainer().updateButtons();
                }
            });
        }

        @Override
        public FilterRule getFilterRule() {
            if (!this.isPageComplete()) {
                return null;
            }
            int i = this._pattern.getSelectionIndex();
            if (i == -1) {
                return null;
            }
            FilterRule rule = FilterRule.createTargetRuntime((String)this.ids[i]);
            return rule;
        }

        public boolean isPageComplete() {
            if (this._pattern == null) {
                return false;
            }
            if (this._pattern.getText() == null) {
                return false;
            }
            return this._pattern.getText().trim().length() > 0;
        }
    }
}

