/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.RecordPattern;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;

public class EnhancedForWithRecordPattern
extends Statement {
    public static final ChildPropertyDescriptor PATTERN_PROPERTY = new ChildPropertyDescriptor(EnhancedForWithRecordPattern.class, "pattern", RecordPattern.class, true, true);
    public static final ChildPropertyDescriptor EXPRESSION_PROPERTY = new ChildPropertyDescriptor(EnhancedForWithRecordPattern.class, "expression", Expression.class, true, true);
    public static final ChildPropertyDescriptor BODY_PROPERTY = new ChildPropertyDescriptor(EnhancedForWithRecordPattern.class, "body", Statement.class, true, true);
    private static final List PROPERTY_DESCRIPTORS;
    private RecordPattern pattern = null;
    private Expression expression = null;
    private Statement body = null;

    static {
        ArrayList properyList = new ArrayList(4);
        EnhancedForWithRecordPattern.createPropertyList(EnhancedForWithRecordPattern.class, properyList);
        EnhancedForWithRecordPattern.addProperty(PATTERN_PROPERTY, properyList);
        EnhancedForWithRecordPattern.addProperty(EXPRESSION_PROPERTY, properyList);
        EnhancedForWithRecordPattern.addProperty(BODY_PROPERTY, properyList);
        PROPERTY_DESCRIPTORS = EnhancedForWithRecordPattern.reapPropertyList(properyList);
    }

    public static List propertyDescriptors(int apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    EnhancedForWithRecordPattern(AST ast) {
        super(ast);
        this.supportedOnlyIn20();
    }

    @Override
    final List internalStructuralPropertiesForType(int apiLevel) {
        return EnhancedForWithRecordPattern.propertyDescriptors(apiLevel);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == PATTERN_PROPERTY) {
            if (get) {
                return this.getPattern();
            }
            this.setPattern((RecordPattern)child);
            return null;
        }
        if (property == EXPRESSION_PROPERTY) {
            if (get) {
                return this.getExpression();
            }
            this.setExpression((Expression)child);
            return null;
        }
        if (property == BODY_PROPERTY) {
            if (get) {
                return this.getBody();
            }
            this.setBody((Statement)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    final int getNodeType0() {
        return 114;
    }

    @Override
    ASTNode clone0(AST target) {
        EnhancedForWithRecordPattern result = new EnhancedForWithRecordPattern(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.copyLeadingComment(this);
        result.setPattern((RecordPattern)this.getPattern().clone(target));
        result.setExpression((Expression)this.getExpression().clone(target));
        result.setBody((Statement)ASTNode.copySubtree(target, this.getBody()));
        return result;
    }

    @Override
    final boolean subtreeMatch0(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.acceptChild(visitor, this.getPattern());
            this.acceptChild(visitor, this.getExpression());
            this.acceptChild(visitor, this.getBody());
        }
        visitor.endVisit(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordPattern getPattern() {
        if (this.pattern == null) {
            EnhancedForWithRecordPattern enhancedForWithRecordPattern = this;
            synchronized (enhancedForWithRecordPattern) {
                if (this.pattern == null) {
                    this.preLazyInit();
                    this.pattern = this.ast.newRecordPattern();
                    this.postLazyInit(this.pattern, PATTERN_PROPERTY);
                }
            }
        }
        return this.pattern;
    }

    public void setPattern(RecordPattern pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException();
        }
        RecordPattern oldChild = this.pattern;
        this.preReplaceChild(oldChild, pattern, PATTERN_PROPERTY);
        this.pattern = pattern;
        this.postReplaceChild(oldChild, pattern, PATTERN_PROPERTY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Expression getExpression() {
        if (this.expression == null) {
            EnhancedForWithRecordPattern enhancedForWithRecordPattern = this;
            synchronized (enhancedForWithRecordPattern) {
                if (this.expression == null) {
                    this.preLazyInit();
                    this.expression = new SimpleName(this.ast);
                    this.postLazyInit(this.expression, EXPRESSION_PROPERTY);
                }
            }
        }
        return this.expression;
    }

    public void setExpression(Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException();
        }
        Expression oldChild = this.expression;
        this.preReplaceChild(oldChild, expression, EXPRESSION_PROPERTY);
        this.expression = expression;
        this.postReplaceChild(oldChild, expression, EXPRESSION_PROPERTY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Statement getBody() {
        if (this.body == null) {
            EnhancedForWithRecordPattern enhancedForWithRecordPattern = this;
            synchronized (enhancedForWithRecordPattern) {
                if (this.body == null) {
                    this.preLazyInit();
                    this.body = new Block(this.ast);
                    this.postLazyInit(this.body, BODY_PROPERTY);
                }
            }
        }
        return this.body;
    }

    public void setBody(Statement statement) {
        if (statement == null) {
            throw new IllegalArgumentException();
        }
        Statement oldChild = this.body;
        this.preReplaceChild(oldChild, statement, BODY_PROPERTY);
        this.body = statement;
        this.postReplaceChild(oldChild, statement, BODY_PROPERTY);
    }

    @Override
    int memSize() {
        return super.memSize() + 12;
    }

    @Override
    int treeSize() {
        return this.memSize() + (this.pattern == null ? 0 : this.getPattern().treeSize()) + (this.expression == null ? 0 : this.getExpression().treeSize()) + (this.body == null ? 0 : this.getBody().treeSize());
    }
}

