/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.core.refactoring.resource.undostates;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCoreMessages;
import org.eclipse.ltk.internal.core.refactoring.resource.undostates.ContainerUndoState;

public class ProjectUndoState
extends ContainerUndoState {
    private IProjectDescription projectDescription;
    private boolean openOnCreate = true;

    public ProjectUndoState(IProject project) {
        super((IContainer)project);
        Assert.isLegal((boolean)project.exists());
        if (project.isOpen()) {
            try {
                this.projectDescription = project.getDescription();
            }
            catch (CoreException coreException) {}
        } else {
            this.openOnCreate = false;
        }
    }

    public ProjectUndoState(IProjectDescription projectDescription) {
        this.projectDescription = projectDescription;
    }

    @Override
    public IResource createResourceHandle() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.getName());
    }

    @Override
    public void createExistentResourceFromHandle(IResource resource, IProgressMonitor monitor) throws CoreException {
        Assert.isLegal((boolean)(resource instanceof IProject));
        if (resource.exists()) {
            return;
        }
        IProject projectHandle = (IProject)resource;
        monitor.beginTask("", 200);
        monitor.setTaskName(RefactoringCoreMessages.FolderDescription_NewFolderProgress);
        if (this.projectDescription == null) {
            projectHandle.create((IProgressMonitor)new SubProgressMonitor(monitor, 100));
        } else {
            projectHandle.create(this.projectDescription, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (this.openOnCreate) {
            projectHandle.open(0, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
        }
        monitor.done();
    }

    @Override
    public String getName() {
        if (this.projectDescription != null) {
            return this.projectDescription.getName();
        }
        return super.getName();
    }

    @Override
    public boolean verifyExistence(boolean checkMembers) {
        IProject projectHandle = (IProject)this.createResourceHandle();
        if (projectHandle.isAccessible()) {
            return super.verifyExistence(checkMembers);
        }
        return super.verifyExistence(false);
    }
}

