/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.ISegmentStoreProvider;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.statistics.AbstractSegmentStatisticsAnalysis;
import org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore.Messages;
import org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore.SegmentStoreStatisticsDataProvider;
import org.eclipse.tracecompass.internal.tmf.core.model.DataProviderDescriptor;
import org.eclipse.tracecompass.internal.tmf.core.model.tree.TmfTreeCompositeDataProvider;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.segment.interfaces.INamedSegment;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.dataprovider.IDataProviderDescriptor;
import org.eclipse.tracecompass.tmf.core.dataprovider.IDataProviderFactory;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;

public class SegmentStoreStatisticsDataProviderFactory
implements IDataProviderFactory {
    public @Nullable ITmfTreeDataProvider<? extends ITmfTreeDataModel> createProvider(ITmfTrace trace) {
        return null;
    }

    public @Nullable ITmfTreeDataProvider<? extends ITmfTreeDataModel> createProvider(ITmfTrace trace, String secondaryId) {
        IAnalysisModule m = trace.getAnalysisModule(secondaryId);
        String composedId = "org.eclipse.tracecompass.analysis.timing.core.segmentstore.SegmentStoreStatisticsDataProvider:" + secondaryId;
        if (!(m instanceof ISegmentStoreProvider)) {
            if (!(trace instanceof TmfExperiment)) {
                return null;
            }
            return TmfTreeCompositeDataProvider.create((Collection)TmfTraceManager.getTraceSet((ITmfTrace)trace), (String)composedId);
        }
        m.schedule();
        GenericSegmentStatisticsAnalysis module = new GenericSegmentStatisticsAnalysis(secondaryId);
        try {
            module.setName(Objects.requireNonNull(NLS.bind((String)Messages.SegmentStoreStatisticsDataProviderFactory_AnalysisName, (Object)m.getName())));
            module.setTrace(trace);
        }
        catch (TmfAnalysisException e) {
            module.dispose();
            return null;
        }
        module.schedule();
        return new SegmentStoreStatisticsDataProvider(trace, module, composedId);
    }

    public Collection<IDataProviderDescriptor> getDescriptors(ITmfTrace trace) {
        Iterable modules = TmfTraceUtils.getAnalysisModulesOfClass((ITmfTrace)trace, ISegmentStoreProvider.class);
        ArrayList<IDataProviderDescriptor> descriptors = new ArrayList<IDataProviderDescriptor>();
        HashSet<String> existingModules = new HashSet<String>();
        for (ISegmentStoreProvider module : modules) {
            IAnalysisModule analysis = (IAnalysisModule)module;
            if (existingModules.contains(analysis.getId())) continue;
            DataProviderDescriptor.Builder builder = new DataProviderDescriptor.Builder();
            builder.setId("org.eclipse.tracecompass.analysis.timing.core.segmentstore.SegmentStoreStatisticsDataProvider:" + analysis.getId()).setName(Objects.requireNonNull(NLS.bind((String)Messages.SegmentStoreStatisticsDataProvider_title, (Object)analysis.getName()))).setDescription(Objects.requireNonNull(NLS.bind((String)Messages.SegmentStoreStatisticsDataProvider_description, (Object)analysis.getHelpText()))).setProviderType(IDataProviderDescriptor.ProviderType.DATA_TREE);
            descriptors.add(builder.build());
            existingModules.add(analysis.getId());
        }
        return descriptors;
    }

    private static final class GenericSegmentStatisticsAnalysis
    extends AbstractSegmentStatisticsAnalysis {
        private final String fSecondaryId;

        private GenericSegmentStatisticsAnalysis(String secondaryId) {
            this.fSecondaryId = secondaryId;
        }

        @Override
        protected @Nullable String getSegmentType(@NonNull ISegment segment) {
            if (segment instanceof INamedSegment) {
                return ((INamedSegment)segment).getName();
            }
            return null;
        }

        @Override
        protected @Nullable ISegmentStoreProvider getSegmentProviderAnalysis(@NonNull ITmfTrace trace) {
            IAnalysisModule segmentStoreModule = trace.getAnalysisModule(this.fSecondaryId);
            if (segmentStoreModule instanceof ISegmentStoreProvider) {
                return (ISegmentStoreProvider)segmentStoreModule;
            }
            return null;
        }
    }
}

