/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.core.annotations;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.annotations.AnnotationCategoriesModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.annotations.AnnotationModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.annotations.IOutputAnnotationProvider;
import org.eclipse.tracecompass.internal.tmf.core.annotations.CustomAnnotationProvider;
import org.eclipse.tracecompass.internal.tmf.core.markers.MarkerConfigXmlParser;
import org.eclipse.tracecompass.internal.tmf.core.markers.MarkerSet;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;

public class CustomOutputAnnotationProvider
implements IOutputAnnotationProvider {
    private static final String INVALID_MARKER_ID = "Invalid marker ID %s";
    private static final String NO_MARKER_ID = "no markerID";
    private final Map<String, CustomAnnotationProvider> fProviders = Collections.synchronizedMap(new HashMap());
    private final ITmfTrace fTrace;

    static {
        MarkerConfigXmlParser.initMarkerSets();
    }

    public CustomOutputAnnotationProvider(ITmfTrace trace) {
        this.fTrace = trace;
    }

    @Override
    public TmfModelResponse<AnnotationCategoriesModel> fetchAnnotationCategories(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        Object markerID = fetchParameters.get("requested_marker_set");
        if (!this.isFirstTrace()) {
            return new TmfModelResponse<Object>(null, ITmfResponse.Status.COMPLETED, "");
        }
        if (markerID == null) {
            return new TmfModelResponse<Object>(null, ITmfResponse.Status.FAILED, NO_MARKER_ID);
        }
        MarkerSet ms = CustomOutputAnnotationProvider.getMarkerSet(markerID);
        if (ms == null) {
            return new TmfModelResponse<Object>(null, ITmfResponse.Status.FAILED, CustomOutputAnnotationProvider.formatError(markerID));
        }
        return this.getAnnotationProvider(null, ms).fetchAnnotationCategories(fetchParameters, monitor);
    }

    @Override
    public TmfModelResponse<AnnotationModel> fetchAnnotations(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        Object markerID = fetchParameters.get("requested_marker_set");
        Object hostID = fetchParameters.get("requested_trace");
        Optional<ITmfTrace> requestedTrace = CustomOutputAnnotationProvider.getTrace(hostID);
        if (requestedTrace.isPresent() && !requestedTrace.get().equals(this.fTrace) || !requestedTrace.isPresent() && !this.isFirstTrace()) {
            return new TmfModelResponse<Object>(null, ITmfResponse.Status.COMPLETED, "");
        }
        if (markerID == null) {
            return new TmfModelResponse<Object>(null, ITmfResponse.Status.FAILED, NO_MARKER_ID);
        }
        MarkerSet ms = CustomOutputAnnotationProvider.getMarkerSet(markerID);
        if (ms == null) {
            return new TmfModelResponse<Object>(null, ITmfResponse.Status.FAILED, CustomOutputAnnotationProvider.formatError(markerID));
        }
        return this.getAnnotationProvider(requestedTrace.isPresent() ? requestedTrace.get() : null, ms).fetchAnnotations(fetchParameters, monitor);
    }

    private CustomAnnotationProvider getAnnotationProvider(@Nullable ITmfTrace trace, MarkerSet ms) {
        return this.fProviders.computeIfAbsent(ms.getId(), msId -> new CustomAnnotationProvider(trace, ms));
    }

    private static @Nullable MarkerSet getMarkerSet(Object markerID) {
        Optional<@Nullable MarkerSet> markerOptional = MarkerConfigXmlParser.getMarkerSets().stream().filter(markerSet -> Objects.equals(markerID, markerSet.getId())).findAny();
        if (markerOptional.isPresent()) {
            return markerOptional.get();
        }
        return null;
    }

    private static Optional<ITmfTrace> getTrace(Object hostID) {
        return TmfTraceManager.getInstance().getOpenedTraces().stream().flatMap(trace -> TmfTraceManager.getTraceSetWithExperiment(trace).stream()).filter(t -> Objects.equals(t.getHostId(), hostID)).findAny();
    }

    private boolean isFirstTrace() {
        return TmfTraceManager.getInstance().getOpenedTraces().stream().anyMatch(t -> TmfTraceManager.getTraceSet(t).stream().findFirst().get().equals(this.fTrace));
    }

    private static String formatError(Object markerID) {
        return String.format(INVALID_MARKER_ID, markerID);
    }
}

