/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.core;

public class RangeRestriction {
    public static final int NONE = 1;
    public static final int ZERO_X = 2;
    public static final int ZERO_Y = 4;
    public static final int RESTRICT_ZOOM = 8;
    public static final int X_ZOOM_ONLY = 16;
    public static final int Y_ZOOM_ONLY = 32;
    public static final int FORCE_ZERO_MIN_Y = 64;
    private ExtendType extendTypeX;
    private double extendMinX;
    private double extendMaxX;
    private ExtendType extendTypeY;
    private double extendMinY;
    private double extendMaxY;
    private int selection;

    public RangeRestriction() {
        this(1);
    }

    public RangeRestriction(int selection) {
        this.selection = selection;
        this.extendTypeX = ExtendType.RELATIVE;
        this.extendMinX = 0.0;
        this.extendMaxX = 0.0;
        this.extendTypeY = ExtendType.RELATIVE;
        this.extendMinY = 0.0;
        this.extendMaxY = 0.0;
    }

    public boolean isZeroX() {
        return this.isFlagSet(2);
    }

    public void setZeroX(boolean zeroX) {
        this.flagSelection(zeroX, 2);
    }

    public boolean isZeroY() {
        return this.isFlagSet(4);
    }

    public void setZeroY(boolean zeroY) {
        this.flagSelection(zeroY, 4);
    }

    public boolean isRestrictZoom() {
        return this.isFlagSet(8);
    }

    public void setRestrictZoom(boolean restrictZoom) {
        this.flagSelection(restrictZoom, 8);
    }

    public boolean isXZoomOnly() {
        return this.isFlagSet(16);
    }

    public void setXZoomOnly(boolean xZoomOnly) {
        this.flagSelection(xZoomOnly, 16);
    }

    public boolean isYZoomOnly() {
        return this.isFlagSet(32);
    }

    public void setYZoomOnly(boolean yZoomOnly) {
        this.flagSelection(yZoomOnly, 32);
    }

    public boolean isForceZeroMinY() {
        return this.isFlagSet(64);
    }

    public void setForceZeroMinY(boolean forceZeroMinY) {
        this.flagSelection(forceZeroMinY, 64);
    }

    public ExtendType getExtendTypeX() {
        return this.extendTypeX;
    }

    public void setExtendTypeX(ExtendType extendTypeX) {
        this.extendTypeX = extendTypeX;
    }

    public double getExtendMinX() {
        return this.extendMinX;
    }

    public void setExtendMinX(double extendMinX) {
        this.extendMinX = extendMinX;
    }

    public double getExtendMaxX() {
        return this.extendMaxX;
    }

    public void setExtendMaxX(double extendMaxX) {
        this.extendMaxX = extendMaxX;
    }

    public ExtendType getExtendTypeY() {
        return this.extendTypeY;
    }

    public void setExtendTypeY(ExtendType extendTypeY) {
        this.extendTypeY = extendTypeY;
    }

    public double getExtendMinY() {
        return this.extendMinY;
    }

    public void setExtendMinY(double extendMinY) {
        this.extendMinY = extendMinY;
    }

    public double getExtendMaxY() {
        return this.extendMaxY;
    }

    public void setExtendMaxY(double extendMaxY) {
        this.extendMaxY = extendMaxY;
    }

    public void setExtend(double extend) {
        this.extendMinX = extend;
        this.extendMaxX = extend;
        this.extendMinY = extend;
        this.extendMaxY = extend;
    }

    private boolean isFlagSet(int constant) {
        return (this.selection & constant) == constant;
    }

    private void flagSelection(boolean flag, int constant) {
        this.selection = flag ? (this.selection |= constant) : (this.selection &= Integer.MAX_VALUE - constant);
    }

    public static enum ExtendType {
        RELATIVE,
        ABSOLUTE;

    }
}

