/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.timing.ui.views.segmentstore.table;

import com.google.common.collect.Iterables;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.ui.viewers.table.ISortingLazyContentProvider;

public class SegmentStoreContentProvider
implements ISortingLazyContentProvider {
    private @Nullable TableViewer fTableViewer = null;
    private @Nullable Comparator<ISegment> fComparator = null;
    private @Nullable SegmentStoreWithRange<?> fStore;

    public void updateElement(int index) {
        TableViewer tableViewer = this.fTableViewer;
        SegmentStoreWithRange<?> store = this.fStore;
        if (tableViewer == null || store == null) {
            return;
        }
        tableViewer.replace((Object)store.getElement(index), index);
    }

    public void dispose() {
        this.fStore = null;
        this.fTableViewer = null;
        this.fComparator = null;
    }

    public void inputChanged(@Nullable Viewer viewer, @Nullable Object oldInput, @Nullable Object newInput) {
        this.fTableViewer = (TableViewer)viewer;
        if (newInput instanceof SegmentStoreWithRange) {
            SegmentStoreWithRange sswr = (SegmentStoreWithRange)newInput;
            Comparator<ISegment> comparator = this.fComparator;
            if (comparator != null) {
                sswr.setComparator(comparator);
            }
            this.fStore = sswr;
        } else if (newInput instanceof ISegmentStore) {
            ISegmentStore segmentStore = (ISegmentStore)newInput;
            SegmentStoreWithRange sswr = new SegmentStoreWithRange(segmentStore, TmfTimeRange.ETERNITY);
            Comparator<ISegment> comparator = this.fComparator;
            if (comparator != null) {
                sswr.setComparator(comparator);
            }
            this.fStore = sswr;
        } else {
            this.fStore = null;
        }
    }

    public void setSortOrder(@Nullable Comparator<?> comparator) {
        SegmentStoreWithRange<?> store = this.fStore;
        TableViewer tableViewer = this.fTableViewer;
        if (comparator == null || store == null || tableViewer == null) {
            return;
        }
        Comparator<ISegment> comp = comparator;
        this.fComparator = comp;
        store.setComparator(comp);
        tableViewer.refresh();
    }

    public long getSegmentCount() {
        SegmentStoreWithRange<?> store = this.fStore;
        return store == null ? 0L : store.getSegmentCount();
    }

    public static class SegmentStoreWithRange<E extends ISegment>
    implements Iterable<E> {
        public static final long LAST = Long.MIN_VALUE;
        private final ISegmentStore<E> fSegmentStore;
        private final TmfTimeRange fRange;
        private @Nullable Comparator<ISegment> fComparator = null;
        private @Nullable Iterable<E> fIterable = null;
        private @Nullable Predicate<E> fPredicate = null;
        private long fLastReadPos = -1L;
        private @Nullable Iterator<E> fIterator = null;

        public SegmentStoreWithRange(ISegmentStore<E> segStore, TmfTimeRange range) {
            this.fSegmentStore = segStore;
            this.fRange = range;
        }

        public SegmentStoreWithRange(ISegmentStore<E> segStore, TmfTimeRange range, Predicate<E> predicate) {
            this.fSegmentStore = segStore;
            this.fRange = range;
            this.fPredicate = predicate;
        }

        @Override
        public Iterator<E> iterator() {
            return (Iterator)NonNullUtils.checkNotNull(this.getIterable().iterator());
        }

        public void setComparator(Comparator<ISegment> comparator) {
            this.fComparator = comparator;
            this.fIterable = null;
            this.resetIterator();
        }

        private Iterable<E> getIterable() {
            Iterable iterable = this.fIterable;
            if (iterable == null) {
                Comparator<ISegment> comparator = this.fComparator;
                Predicate predicate = this.fPredicate;
                iterable = comparator != null ? this.fSegmentStore.getIntersectingElements(this.fRange.getStartTime().toNanos(), this.fRange.getEndTime().toNanos(), comparator) : this.fSegmentStore.getIntersectingElements(this.fRange.getStartTime().toNanos(), this.fRange.getEndTime().toNanos());
                if (predicate != null) {
                    iterable = Iterables.filter((Iterable)iterable, input -> predicate.test(input));
                }
                this.fIterable = iterable;
            }
            return iterable;
        }

        private Iterator<? extends @NonNull ISegment> resetIterator() {
            Iterator iterator;
            this.fIterator = iterator = (Iterator)NonNullUtils.checkNotNull(this.getIterable().iterator());
            this.fLastReadPos = -1L;
            return iterator;
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public @Nullable ISegment getElement(long index) {
            Iterable<E> iterable;
            long idx = index;
            if (index == Long.MIN_VALUE) {
                Comparator<@NonNull ISegment> comparator = this.fComparator;
                if (comparator != null) {
                    return this.getLastElement(comparator);
                }
                idx = 0L;
            }
            if ((iterable = this.fIterable) instanceof List && idx <= Integer.MAX_VALUE) {
                return (ISegment)Iterables.get(iterable, (int)((int)idx), null);
            }
            Iterator<@NonNull Object> iterator = this.fIterator;
            if (iterator == null || idx <= this.fLastReadPos) {
                iterator = this.resetIterator();
            }
            ISegment segment = null;
            while (this.fLastReadPos < idx && iterator.hasNext()) {
                ++this.fLastReadPos;
                segment = (ISegment)NonNullUtils.checkNotNull((Object)((ISegment)iterator.next()));
            }
            if (this.fLastReadPos == idx) {
                return segment;
            }
            return null;
        }

        private @Nullable ISegment getLastElement(Comparator<@NonNull ISegment> comparator) {
            Iterable<E> baseIterable = this.fIterable;
            if (baseIterable instanceof List) {
                return (ISegment)Iterables.getLast(baseIterable, null);
            }
            Predicate predicate = this.fPredicate;
            Iterable iterable = this.fSegmentStore.getIntersectingElements(this.fRange.getStartTime().toNanos(), this.fRange.getEndTime().toNanos(), comparator.reversed());
            if (predicate != null) {
                iterable = Iterables.filter((Iterable)iterable, input -> predicate.test(input));
            }
            return (ISegment)Iterables.getFirst((Iterable)iterable, null);
        }

        public long getSegmentCount() {
            return Iterables.size(this.getIterable());
        }
    }
}

