/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.graph.core.tests.stubs.module;

import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.graph.core.base.IGraphWorker;
import org.eclipse.tracecompass.analysis.graph.core.base.TmfEdge;
import org.eclipse.tracecompass.analysis.graph.core.base.TmfGraph;
import org.eclipse.tracecompass.analysis.graph.core.base.TmfVertex;
import org.eclipse.tracecompass.analysis.graph.core.building.AbstractTmfGraphProvider;
import org.eclipse.tracecompass.analysis.graph.core.building.AbstractTraceEventHandler;
import org.eclipse.tracecompass.analysis.graph.core.building.ITraceEventHandler;
import org.eclipse.tracecompass.analysis.graph.core.tests.stubs.TestGraphWorker;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class GraphProviderStub
extends AbstractTmfGraphProvider {
    public GraphProviderStub(@NonNull ITmfTrace trace) {
        super(trace, "Graph Provider Stub");
        this.registerHandler((ITraceEventHandler)new StubEventHandler());
    }

    public @NonNull List<@NonNull ITraceEventHandler> getHandlers() {
        return super.getHandlers();
    }

    private class StubEventHandler
    extends AbstractTraceEventHandler {
        public StubEventHandler() {
            super(5);
        }

        public void handleEvent(ITmfEvent event) {
            String evname = event.getType().getName();
            TmfGraph graph = GraphProviderStub.this.getAssignedGraph();
            if (graph == null) {
                throw new IllegalStateException();
            }
            switch (evname) {
                case "take": {
                    TestGraphWorker player = new TestGraphWorker((Integer)NonNullUtils.checkNotNull((Object)((Integer)event.getContent().getField(new String[]{"player"}).getValue())));
                    TmfVertex v = new TmfVertex(event.getTimestamp().getValue());
                    graph.add((IGraphWorker)player, v);
                    break;
                }
                case "pass": {
                    TestGraphWorker playerFrom = new TestGraphWorker((Integer)NonNullUtils.checkNotNull((Object)((Integer)event.getContent().getField(new String[]{"from"}).getValue())));
                    TestGraphWorker playerTo = new TestGraphWorker((Integer)NonNullUtils.checkNotNull((Object)((Integer)event.getContent().getField(new String[]{"to"}).getValue())));
                    TmfVertex vFrom = new TmfVertex(event.getTimestamp().getValue());
                    graph.append((IGraphWorker)playerFrom, vFrom);
                    TmfVertex vTo = new TmfVertex(event.getTimestamp().getValue());
                    graph.add((IGraphWorker)playerTo, vTo);
                    graph.link(vFrom, vTo, TmfEdge.EdgeType.NETWORK);
                    break;
                }
                case "kick": {
                    TestGraphWorker player = new TestGraphWorker((Integer)NonNullUtils.checkNotNull((Object)((Integer)event.getContent().getField(new String[]{"player"}).getValue())));
                    TmfVertex v = new TmfVertex(event.getTimestamp().getValue());
                    graph.append((IGraphWorker)player, v);
                    break;
                }
            }
        }
    }
}

