/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.filter.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.filter.model.ITmfFilterTreeNode;
import org.eclipse.tracecompass.tmf.core.filter.model.ITmfFilterWithValue;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterAspectNode;

public class TmfFilterContainsNode
extends TmfFilterAspectNode
implements ITmfFilterWithValue {
    public static final String NODE_NAME = "CONTAINS";
    public static final String IGNORECASE_ATTR = "ignorecase";
    private String fValue;
    private transient String fValueUpperCase;
    private boolean fIgnoreCase = false;

    public TmfFilterContainsNode(ITmfFilterTreeNode parent) {
        super(parent);
    }

    @Override
    public String getValue() {
        return this.fValue;
    }

    @Override
    public void setValue(String value) {
        this.fValue = value;
        this.fValueUpperCase = null;
        if (value != null) {
            this.fValueUpperCase = value.toUpperCase();
        }
    }

    public boolean isIgnoreCase() {
        return this.fIgnoreCase;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.fIgnoreCase = ignoreCase;
    }

    @Override
    public String getNodeName() {
        return NODE_NAME;
    }

    @Override
    public boolean matches(ITmfEvent event) {
        if (event == null || this.fEventAspect == null) {
            return this.isNot();
        }
        Object value = this.fEventAspect.resolve(event);
        if (value == null) {
            return this.isNot();
        }
        String valueString = value.toString();
        if (this.fIgnoreCase) {
            return valueString.toUpperCase().contains(this.fValueUpperCase) ^ this.isNot();
        }
        return valueString.contains(this.fValue) ^ this.isNot();
    }

    @Override
    public List<String> getValidChildren() {
        return new ArrayList<String>(0);
    }

    @Override
    public String toString(boolean explicit) {
        return String.valueOf(this.getAspectLabel(explicit)) + (this.isNot() ? " not contains " : " contains ") + (this.fIgnoreCase ? "ignorecase \"" : "\"") + this.fValue + '\"';
    }

    @Override
    public ITmfFilterTreeNode clone() {
        TmfFilterContainsNode clone = (TmfFilterContainsNode)super.clone();
        clone.setValue(this.fValue);
        return clone;
    }
}

