/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectBase;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.internal.ProblemLog;
import org.eclipse.wst.common.project.facet.core.internal.RuntimeComponentTypeRef;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;
import org.eclipse.wst.common.project.facet.core.util.internal.PluginUtil;

public final class DefaultFacetsExtensionPoint {
    public static final String EXTENSION_POINT_ID = "defaultFacets";
    private static final String ATTR_ID = "id";
    private static final String ATTR_VERSION = "version";
    private static final String EL_CONTEXT = "context";
    private static final String EL_DEFAULT_FACETS = "default-facets";
    private static final String EL_FACET = "facet";
    private static final String EL_FIXED_FACET = "fixed-facet";
    private static final String EL_RUNTIME_COMPONENT = "runtime-component";
    private static List<DefaultFacetsExtension> extensions = null;

    /*
     * WARNING - void declaration
     */
    public static Set<IProjectFacetVersion> getDefaultFacets(IFacetedProjectBase fproj) throws CoreException {
        void var5_9;
        Set<IProjectFacet> fixed = fproj.getFixedProjectFacets();
        for (IProjectFacet f : fixed) {
            if (f.getPluginId() != null) continue;
            return null;
        }
        DefaultFacetsExtensionPoint.readExtensions();
        HashMap<IProjectFacet, IProjectFacetVersion> facets = new HashMap<IProjectFacet, IProjectFacetVersion>();
        for (DefaultFacetsExtension extension : extensions) {
            if (!extension.match(fproj)) continue;
            for (IProjectFacetVersion iProjectFacetVersion : extension.getProjectFacets()) {
                facets.put(iProjectFacetVersion.getProjectFacet(), iProjectFacetVersion);
            }
        }
        HashSet<IProjectFacet> toRemove = new HashSet<IProjectFacet>();
        for (IProjectFacetVersion fv : facets.values()) {
            if (fv.isValidFor(fixed)) continue;
            toRemove.add(fv.getProjectFacet());
        }
        for (IProjectFacet f : toRemove) {
            facets.remove(f);
        }
        IRuntime runtime = fproj.getPrimaryRuntime();
        Object var5_8 = null;
        for (IProjectFacet f : fixed) {
            if (facets.containsKey(f)) continue;
            if (var5_9 == null) {
                HashMap hashMap = new HashMap();
            }
            IProjectFacetVersion fv = runtime != null ? f.getLatestSupportedVersion(runtime) : f.getDefaultVersion();
            var5_9.put(f, fv);
        }
        if (var5_9 != null) {
            facets.putAll((Map<IProjectFacet, IProjectFacetVersion>)var5_9);
        }
        return Collections.unmodifiableSet(new HashSet(facets.values()));
    }

    private static synchronized void readExtensions() {
        if (extensions != null) {
            return;
        }
        extensions = new ArrayList<DefaultFacetsExtension>();
        for (IConfigurationElement element : PluginUtil.getTopLevelElements(PluginUtil.findExtensions("org.eclipse.wst.common.project.facet.core", EXTENSION_POINT_ID))) {
            if (!element.getName().equals(EL_DEFAULT_FACETS)) continue;
            try {
                DefaultFacetsExtensionPoint.readExtension(element);
            }
            catch (PluginUtil.InvalidExtensionException invalidExtensionException) {}
        }
    }

    private static void readExtension(IConfigurationElement config) throws PluginUtil.InvalidExtensionException {
        String pluginId = config.getContributor().getName();
        ProblemLog.Policy problemLoggingPolicy = ProblemLog.Policy.createBasedOnIgnoreProblemsAttr(config);
        DefaultFacetsExtension extension = new DefaultFacetsExtension();
        IConfigurationElement[] iConfigurationElementArray = config.getChildren();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement child = iConfigurationElementArray[n2];
            String childName = child.getName();
            if (childName.equals(EL_RUNTIME_COMPONENT)) {
                RuntimeComponentTypeRef rctRef = RuntimeComponentTypeRef.read(child, problemLoggingPolicy);
                if (rctRef == null) {
                    throw new PluginUtil.InvalidExtensionException();
                }
                extension.addContext(rctRef);
            } else if (childName.equals(EL_CONTEXT)) {
                IConfigurationElement[] iConfigurationElementArray2 = child.getChildren();
                int n3 = iConfigurationElementArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement contextChild = iConfigurationElementArray2[n4];
                    String contextChildName = contextChild.getName();
                    if (contextChildName.equals(EL_RUNTIME_COMPONENT)) {
                        RuntimeComponentTypeRef rctRef = RuntimeComponentTypeRef.read(contextChild, problemLoggingPolicy);
                        if (rctRef == null) {
                            throw new PluginUtil.InvalidExtensionException();
                        }
                        extension.addContext(rctRef);
                    } else if (contextChildName.equals(EL_FIXED_FACET)) {
                        String fid = PluginUtil.findRequiredAttribute(contextChild, ATTR_ID);
                        if (!ProjectFacetsManager.isProjectFacetDefined(fid)) {
                            ProblemLog.reportMissingFacet(fid, pluginId, problemLoggingPolicy);
                            throw new PluginUtil.InvalidExtensionException();
                        }
                        IProjectFacet f = ProjectFacetsManager.getProjectFacet(fid);
                        extension.addContext(f);
                    }
                    ++n4;
                }
            } else if (childName.equals(EL_FACET)) {
                String ver;
                String fid = PluginUtil.findRequiredAttribute(child, ATTR_ID);
                if (!ProjectFacetsManager.isProjectFacetDefined(fid)) {
                    ProblemLog.reportMissingFacet(fid, pluginId, problemLoggingPolicy);
                    throw new PluginUtil.InvalidExtensionException();
                }
                IProjectFacet f = ProjectFacetsManager.getProjectFacet(fid);
                if (!f.hasVersion(ver = PluginUtil.findRequiredAttribute(child, ATTR_VERSION))) {
                    ProblemLog.reportMissingFacetVersion(f, ver, pluginId, problemLoggingPolicy);
                    throw new PluginUtil.InvalidExtensionException();
                }
                extension.addProjectFacet(f.getVersion(ver));
            }
            ++n2;
        }
        extensions.add(extension);
    }

    private static final class DefaultFacetsExtension {
        private Set<IProjectFacet> contextFixedFacets = new HashSet<IProjectFacet>();
        private Set<RuntimeComponentTypeRef> contextRuntimeComponentTypes = new HashSet<RuntimeComponentTypeRef>();
        private final Set<IProjectFacetVersion> facets = new HashSet<IProjectFacetVersion>();

        private DefaultFacetsExtension() {
        }

        public void addContext(IProjectFacet facet) {
            this.contextFixedFacets.add(facet);
        }

        public void addContext(RuntimeComponentTypeRef runtimeComponentTypeRef) {
            this.contextRuntimeComponentTypes.add(runtimeComponentTypeRef);
        }

        public Set<IProjectFacetVersion> getProjectFacets() {
            return this.facets;
        }

        public void addProjectFacet(IProjectFacetVersion fv) {
            this.facets.add(fv);
        }

        public boolean match(IFacetedProjectBase fproj) {
            Set<IProjectFacet> fixedFacets;
            if (!this.contextFixedFacets.isEmpty() && !(fixedFacets = fproj.getFixedProjectFacets()).containsAll(this.contextFixedFacets)) {
                return false;
            }
            if (!this.contextRuntimeComponentTypes.isEmpty()) {
                IRuntime runtime = fproj.getPrimaryRuntime();
                if (runtime == null) {
                    return false;
                }
                for (RuntimeComponentTypeRef rctRef : this.contextRuntimeComponentTypes) {
                    boolean found = false;
                    for (IRuntimeComponent rc : runtime.getRuntimeComponents()) {
                        if (!rctRef.check(Collections.singleton(rc.getRuntimeComponentVersion()))) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    return false;
                }
            }
            return true;
        }
    }
}

