/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.trace.indexer.checkpoint;

import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.tests.shared.TmfTestTrace;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.indexer.checkpoint.ITmfCheckpoint;
import org.eclipse.tracecompass.tmf.core.trace.indexer.checkpoint.ITmfCheckpointIndex;
import org.eclipse.tracecompass.tmf.core.trace.location.ITmfLocation;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.TmfExperimentStub;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.TmfTraceStub;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TmfExperimentCheckpointIndexTest {
    private static final String EXPERIMENT = "MyExperiment";
    private static final TmfTestTrace TEST_TRACE1 = TmfTestTrace.O_TEST_10K;
    private static final TmfTestTrace TEST_TRACE2 = TmfTestTrace.E_TEST_10K;
    private static int NB_EVENTS = 20000;
    private static int BLOCK_SIZE = 2000;
    private static int LAST_EVENT_RANK = NB_EVENTS - 1;
    private static int LAST_CHECKPOINT_RANK = LAST_EVENT_RANK / BLOCK_SIZE;
    private static int NB_CHECKPOINTS = LAST_CHECKPOINT_RANK + 1;
    private static ITmfTrace[] fTestTraces;
    private static TmfExperimentStub fExperiment;

    @Before
    public void setUp() {
        TmfExperimentCheckpointIndexTest.setupTraces();
        fExperiment = new TmfExperimentStub(EXPERIMENT, fTestTraces, BLOCK_SIZE);
        fExperiment.getIndexer().buildIndex(0L, TmfTimeRange.ETERNITY, true);
    }

    @After
    public void tearDown() {
        fExperiment.dispose();
        fExperiment = null;
        ITmfTrace[] iTmfTraceArray = fTestTraces;
        int n = fTestTraces.length;
        int n2 = 0;
        while (n2 < n) {
            ITmfTrace trace = iTmfTraceArray[n2];
            trace.dispose();
            ++n2;
        }
        fTestTraces = null;
    }

    private static void setupTraces() {
        fTestTraces = new ITmfTrace[2];
        try {
            TmfTraceStub trace1 = new TmfTraceStub(TEST_TRACE1.getFullPath(), 0, true, null);
            TmfExperimentCheckpointIndexTest.fTestTraces[0] = trace1;
            TmfTraceStub trace2 = new TmfTraceStub(TEST_TRACE2.getFullPath(), 0, true, null);
            TmfExperimentCheckpointIndexTest.fTestTraces[1] = trace2;
        }
        catch (TmfTraceException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testTmfTraceIndexing() {
        Assert.assertEquals((String)"getCacheSize", (long)BLOCK_SIZE, (long)fExperiment.getCacheSize());
        Assert.assertEquals((String)"getTraceSize", (long)NB_EVENTS, (long)fExperiment.getNbEvents());
        Assert.assertEquals((String)"getRange-start", (long)1L, (long)fExperiment.getTimeRange().getStartTime().getValue());
        Assert.assertEquals((String)"getRange-end", (long)NB_EVENTS, (long)fExperiment.getTimeRange().getEndTime().getValue());
        Assert.assertEquals((String)"getStartTime", (long)1L, (long)fExperiment.getStartTime().getValue());
        Assert.assertEquals((String)"getEndTime", (long)NB_EVENTS, (long)fExperiment.getEndTime().getValue());
        ITmfCheckpointIndex checkpoints = fExperiment.getIndexer().getCheckpoints();
        int pageSize = fExperiment.getCacheSize();
        Assert.assertTrue((String)"Checkpoints exist", (checkpoints != null ? 1 : 0) != 0);
        Assert.assertEquals((String)"Checkpoints size", (long)NB_CHECKPOINTS, (long)checkpoints.size());
        int i = 0;
        while (i < checkpoints.size()) {
            ITmfCheckpoint checkpoint = checkpoints.get((long)i);
            ITmfLocation location = checkpoint.getLocation();
            ITmfContext context = fExperiment.seekEvent(location);
            ITmfEvent event = fExperiment.parseEvent(context);
            Assert.assertTrue((context.getRank() == (long)(i * pageSize) ? 1 : 0) != 0);
            Assert.assertTrue((checkpoint.getTimestamp().compareTo(event.getTimestamp()) == 0 ? 1 : 0) != 0);
            ++i;
        }
    }

    @Test
    public void testGrowingIndex() {
        TmfTraceStub[] testTraces = new TmfTraceStub[2];
        try {
            TmfTraceStub trace2;
            TmfTraceStub trace1;
            testTraces[0] = trace1 = new TmfTraceStub(TEST_TRACE1.getFullPath(), 0, false, null);
            testTraces[1] = trace2 = new TmfTraceStub(TEST_TRACE2.getFullPath(), 0, false, null);
        }
        catch (TmfTraceException e) {
            e.printStackTrace();
        }
        TmfExperimentStub experiment = new TmfExperimentStub(EXPERIMENT, (ITmfTrace[])testTraces, BLOCK_SIZE);
        int pageSize = experiment.getCacheSize();
        TmfTimeRange range = new TmfTimeRange(TmfTimestamp.create((long)1L, (int)-3), TmfTimestamp.create((long)(NB_EVENTS / 2 - 1), (int)-3));
        experiment.getIndexer().buildIndex(0L, range, true);
        ITmfCheckpointIndex checkpoints = experiment.getIndexer().getCheckpoints();
        Assert.assertTrue((String)"Checkpoints exist", (checkpoints != null ? 1 : 0) != 0);
        Assert.assertEquals((String)"Checkpoints size", (long)(NB_CHECKPOINTS / 2), (long)checkpoints.size());
        experiment.getIndexer().buildIndex(NB_EVENTS / 2, TmfTimeRange.ETERNITY, true);
        Assert.assertEquals((String)"Checkpoints size", (long)NB_CHECKPOINTS, (long)checkpoints.size());
        int i = 0;
        while (i < checkpoints.size()) {
            ITmfCheckpoint checkpoint = checkpoints.get((long)i);
            ITmfLocation location = checkpoint.getLocation();
            ITmfContext context = experiment.seekEvent(location);
            ITmfEvent event = experiment.parseEvent(context);
            Assert.assertTrue((context.getRank() == (long)(i * pageSize) ? 1 : 0) != 0);
            Assert.assertTrue((checkpoint.getTimestamp().compareTo(event.getTimestamp()) == 0 ? 1 : 0) != 0);
            Assert.assertEquals((String)"Checkpoint value", (long)(i * pageSize + 1), (long)checkpoint.getTimestamp().getValue());
            ++i;
        }
        experiment.dispose();
        TmfTraceStub[] tmfTraceStubArray = testTraces;
        int n = testTraces.length;
        int n2 = 0;
        while (n2 < n) {
            TmfTraceStub trace = tmfTraceStubArray[n2];
            trace.dispose();
            ++n2;
        }
    }
}

