/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.core.analysis;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.tracecompass.internal.tmf.core.Activator;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModuleSource;

public final class TmfAnalysisModuleSources {
    public static final String TMF_ANALYSIS_TYPE_ID = "org.eclipse.linuxtools.tmf.core.analysis";
    public static final String SOURCE_ELEM = "source";
    public static final String CLASS_ATTR = "class";

    private TmfAnalysisModuleSources() {
    }

    public static Iterable<IAnalysisModuleSource> getSources() {
        IConfigurationElement[] config;
        ArrayList<IAnalysisModuleSource> sources = new ArrayList<IAnalysisModuleSource>();
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(TMF_ANALYSIS_TYPE_ID);
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            String elementName = ce.getName();
            if (elementName.equals(SOURCE_ELEM)) {
                try {
                    IAnalysisModuleSource source = (IAnalysisModuleSource)ce.createExecutableExtension(CLASS_ATTR);
                    if (source != null) {
                        sources.add(source);
                    }
                }
                catch (InvalidRegistryObjectException e) {
                    Activator.logError("Error creating module source", e);
                }
                catch (CoreException e) {
                    Activator.logError("Error creating module source", e);
                }
            }
            ++n2;
        }
        return sources;
    }
}

