/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.text.quicksearch.internal.core.priority;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.text.quicksearch.internal.core.priority.DefaultPriorityFunction;

public class PrioriTree
extends DefaultPriorityFunction {
    private static final boolean DEBUG = false;
    private int level;
    private double priority = Double.NEGATIVE_INFINITY;
    private double childPriority = Double.NEGATIVE_INFINITY;
    private Map<String, PrioriTree> children = null;

    public static PrioriTree create() {
        return new PrioriTree(0, 0.0);
    }

    private PrioriTree(int level, double defaultPriority) {
        this.level = level;
        this.priority = defaultPriority;
        this.childPriority = defaultPriority;
    }

    private static void debug(String string) {
    }

    public void setPriority(IPath path, double priority) {
        this.priority = Math.max(this.priority, priority);
        if (path.segmentCount() > 0) {
            PrioriTree child = this.ensureChild(path.segment(0));
            child.setPriority(path.removeFirstSegments(1), priority);
        } else {
            this.setChildPriority(priority);
        }
    }

    private void setChildPriority(double priority) {
        double newChildPriority = Math.max(priority, this.childPriority);
        if (newChildPriority != this.childPriority) {
            this.childPriority = newChildPriority;
            if (this.children != null) {
                for (PrioriTree child : this.children.values()) {
                    child.priority = Math.max(child.priority, newChildPriority);
                    child.setChildPriority(newChildPriority);
                }
            }
        }
    }

    private PrioriTree ensureChild(String segment) {
        PrioriTree child;
        if (this.children == null) {
            this.children = new HashMap<String, PrioriTree>();
        }
        if ((child = this.children.get(segment)) == null) {
            child = new PrioriTree(this.level + 1, this.childPriority);
            this.children.put(segment, child);
        }
        return child;
    }

    @Override
    public double priority(IResource r) {
        double result = super.priority(r);
        if (result == Double.NEGATIVE_INFINITY) {
            return Double.NEGATIVE_INFINITY;
        }
        IPath path = r.getFullPath();
        PrioriTree node = this.lookup(path);
        result = node.level == path.segmentCount() ? node.priority : node.childPriority;
        PrioriTree.debug("Priority for " + String.valueOf(r.getFullPath()) + " = " + result);
        return result;
    }

    private PrioriTree lookup(IPath path) {
        PrioriTree child;
        PrioriTree found = null;
        if (path.segmentCount() > 0 && (child = this.getChild(path.segment(0))) != null) {
            found = child.lookup(path.removeFirstSegments(1));
        }
        return found == null ? this : found;
    }

    private PrioriTree getChild(String segment) {
        if (this.children != null) {
            return this.children.get(segment);
        }
        return null;
    }

    public void dump() {
        this.dump("/", 0);
    }

    private void dump(String name, int indent) {
        this.indent(indent);
        System.out.println(name + " : " + this.priority);
        if (this.children != null) {
            for (Map.Entry<String, PrioriTree> c : this.children.entrySet()) {
                c.getValue().dump(c.getKey(), indent + 1);
            }
        }
    }

    private void indent(int i) {
        int j = 0;
        while (j < i) {
            System.out.print("  ");
            ++j;
        }
    }
}

