/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.apt.model;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.apt.dispatch.BaseProcessingEnvImpl;
import org.eclipse.jdt.internal.compiler.apt.model.ElementsImpl;
import org.eclipse.jdt.internal.compiler.apt.model.ExecutableElementImpl;
import org.eclipse.jdt.internal.compiler.apt.model.ModuleElementImpl;
import org.eclipse.jdt.internal.compiler.apt.model.PackageElementImpl;
import org.eclipse.jdt.internal.compiler.apt.model.TypeElementImpl;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.BinaryModuleBinding;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ModuleBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceModuleBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.parser.ScannerHelper;
import org.eclipse.jdt.internal.compiler.tool.EclipseFileManager;
import org.eclipse.jdt.internal.compiler.tool.PathFileObject;
import org.eclipse.jdt.internal.compiler.util.HashtableOfModule;
import org.eclipse.jdt.internal.compiler.util.TextBlockUtil;

public class ElementsImpl9
extends ElementsImpl {
    public ElementsImpl9(BaseProcessingEnvImpl env) {
        super(env);
    }

    @Override
    public TypeElement getTypeElement(CharSequence name) {
        char[][] compoundName = CharOperation.splitOn('.', name.toString().toCharArray());
        Set<? extends ModuleElement> allModuleElements = this.getAllModuleElements();
        for (ModuleElement moduleElement : allModuleElements) {
            TypeElement t = this.getTypeElement(compoundName, ((ModuleElementImpl)moduleElement).binding);
            if (t == null) continue;
            return t;
        }
        return null;
    }

    @Override
    public TypeElement getTypeElement(ModuleElement module, CharSequence name) {
        ModuleBinding mBinding = ((ModuleElementImpl)module).binding;
        char[][] compoundName = CharOperation.splitOn('.', name.toString().toCharArray());
        return this.getTypeElement(compoundName, mBinding);
    }

    private TypeElement getTypeElement(char[][] compoundName, ModuleBinding mBinding) {
        ReferenceBinding binding;
        LookupEnvironment le = mBinding == null ? this._env.getLookupEnvironment() : mBinding.environment;
        ReferenceBinding referenceBinding = binding = mBinding == null ? le.getType(compoundName) : le.getType(compoundName, mBinding);
        if (binding == null) {
            ReferenceBinding topLevelBinding = null;
            int topLevelSegments = compoundName.length;
            while (--topLevelSegments > 0) {
                char[][] topLevelName = new char[topLevelSegments][];
                int i = 0;
                while (i < topLevelSegments) {
                    topLevelName[i] = compoundName[i];
                    ++i;
                }
                topLevelBinding = le.getType(topLevelName, mBinding);
                if (topLevelBinding != null) break;
            }
            if (topLevelBinding == null) {
                return null;
            }
            binding = topLevelBinding;
            int i = topLevelSegments;
            while (binding != null && i < compoundName.length) {
                binding = binding.getMemberType(compoundName[i]);
                ++i;
            }
        }
        if (binding == null) {
            return null;
        }
        if ((binding.tagBits & 0x80L) != 0L) {
            return null;
        }
        return new TypeElementImpl(this._env, binding, null);
    }

    @Override
    public Elements.Origin getOrigin(Element e) {
        return Elements.Origin.EXPLICIT;
    }

    @Override
    public Elements.Origin getOrigin(AnnotatedConstruct c, AnnotationMirror a) {
        return Elements.Origin.EXPLICIT;
    }

    @Override
    public Elements.Origin getOrigin(ModuleElement m, ModuleElement.Directive directive) {
        return Elements.Origin.EXPLICIT;
    }

    @Override
    public boolean isBridge(ExecutableElement e) {
        MethodBinding methodBinding = (MethodBinding)((ExecutableElementImpl)e)._binding;
        return methodBinding.isBridge();
    }

    @Override
    public ModuleElement getModuleOf(Element elem) {
        if (elem instanceof ModuleElement) {
            return (ModuleElement)elem;
        }
        Element parent = elem.getEnclosingElement();
        while (parent != null) {
            if (parent instanceof ModuleElement) {
                return (ModuleElement)parent;
            }
            parent = parent.getEnclosingElement();
        }
        return null;
    }

    @Override
    public ModuleElement getModuleElement(CharSequence name) {
        LookupEnvironment lookup = this._env.getLookupEnvironment();
        ModuleBinding binding = lookup.getModule(name.length() == 0 ? ModuleBinding.UNNAMED : name.toString().toCharArray());
        if (binding == null) {
            return null;
        }
        return new ModuleElementImpl(this._env, binding);
    }

    @Override
    public Set<? extends ModuleElement> getAllModuleElements() {
        LookupEnvironment lookup = this._env.getLookupEnvironment();
        HashtableOfModule knownModules = lookup.knownModules;
        ModuleBinding[] modules = knownModules.valueTable;
        if (modules == null || modules.length == 0) {
            return Collections.emptySet();
        }
        HashSet<ModuleElement> mods = new HashSet<ModuleElement>(modules.length);
        ModuleBinding[] moduleBindingArray = modules;
        int n = modules.length;
        int n2 = 0;
        while (n2 < n) {
            ModuleBinding moduleBinding = moduleBindingArray[n2];
            if (moduleBinding != null) {
                ModuleElement element = (ModuleElement)this._env.getFactory().newElement(moduleBinding);
                mods.add(element);
            }
            ++n2;
        }
        mods.add((ModuleElement)this._env.getFactory().newElement(lookup.UnNamedModule));
        return mods;
    }

    @Override
    public PackageElement getPackageElement(ModuleElement module, CharSequence name) {
        ModuleBinding mBinding = ((ModuleElementImpl)module).binding;
        char[][] compoundName = CharOperation.splitOn('.', name.toString().toCharArray());
        PackageBinding p = null;
        p = mBinding != null ? mBinding.getVisiblePackage(compoundName) : this._env.getLookupEnvironment().createPackage(compoundName);
        if (p == null || !p.isValidBinding()) {
            return null;
        }
        return (PackageElement)this._env.getFactory().newElement(p);
    }

    @Override
    public boolean isAutomaticModule(ModuleElement module) {
        ModuleBinding mBinding = ((ModuleElementImpl)module).binding;
        return mBinding.isAutomatic();
    }

    @Override
    public JavaFileObject getFileObjectOf(Element element) {
        switch (element.getKind()) {
            case ENUM: 
            case CLASS: 
            case ANNOTATION_TYPE: 
            case INTERFACE: 
            case RECORD: {
                TypeElementImpl elementImpl = (TypeElementImpl)element;
                ReferenceBinding refBinding = (ReferenceBinding)elementImpl._binding;
                if (!refBinding.isBinaryBinding()) {
                    TypeElementImpl outer = (TypeElementImpl)this.getOutermostTypeElement(element);
                    refBinding = (ReferenceBinding)outer._binding;
                }
                return this.getFileObjectForType(refBinding);
            }
            case MODULE: {
                ModuleElementImpl moduleEl = (ModuleElementImpl)element;
                ModuleBinding mBinding = (ModuleBinding)moduleEl._binding;
                if (mBinding instanceof SourceModuleBinding) {
                    SourceModuleBinding sourceModule = (SourceModuleBinding)mBinding;
                    return this.getSourceJavaFileObject(sourceModule.scope.referenceContext());
                }
                if (!(mBinding instanceof BinaryModuleBinding)) break;
                BinaryModuleBinding binaryBinding = (BinaryModuleBinding)mBinding;
                if (binaryBinding.path == null) break;
                return new PathFileObject(Path.of(binaryBinding.path), JavaFileObject.Kind.CLASS, Charset.defaultCharset());
            }
            case PACKAGE: {
                PackageElementImpl packEl = (PackageElementImpl)element;
                PackageBinding pBinding = (PackageBinding)packEl._binding;
                Binding typeOrPackage = pBinding.getTypeOrPackage(TypeConstants.PACKAGE_INFO_NAME, pBinding.enclosingModule, true);
                if (typeOrPackage == null) break;
                return this.getFileObjectForType((TypeBinding)typeOrPackage);
            }
            case ENUM_CONSTANT: 
            case FIELD: 
            case PARAMETER: 
            case LOCAL_VARIABLE: 
            case METHOD: 
            case CONSTRUCTOR: 
            case RECORD_COMPONENT: {
                if (element.getEnclosingElement() == null) break;
                return this.getFileObjectOf(element.getEnclosingElement());
            }
        }
        return null;
    }

    private JavaFileObject getFileObjectForType(TypeBinding binding) {
        if (binding instanceof SourceTypeBinding) {
            SourceTypeBinding sourceTypeBinding = (SourceTypeBinding)binding;
            ReferenceContext referenceContext = sourceTypeBinding.scope.referenceContext();
            return this.getSourceJavaFileObject(referenceContext);
        }
        if (binding instanceof BinaryTypeBinding) {
            Path of;
            BinaryTypeBinding binaryBinding = (BinaryTypeBinding)binding;
            if (binaryBinding.path != null && Files.exists(of = Path.of(binaryBinding.path), new LinkOption[0])) {
                return new PathFileObject(of, JavaFileObject.Kind.CLASS, Charset.defaultCharset());
            }
        }
        return null;
    }

    private JavaFileObject getSourceJavaFileObject(ReferenceContext referenceContext) {
        JavaFileManager fileManager = this._env.getFileManager();
        if (fileManager instanceof EclipseFileManager) {
            Iterator<? extends JavaFileObject> objects;
            EclipseFileManager eFileManager = (EclipseFileManager)fileManager;
            CompilationResult compilationResult = referenceContext.compilationResult();
            String fileName = new String(compilationResult.fileName);
            File f = new File(fileName);
            if (f.exists() && (objects = eFileManager.getJavaFileObjects(f).iterator()).hasNext()) {
                return objects.next();
            }
        } else {
            throw new UnsupportedOperationException();
        }
        return null;
    }

    @Override
    public boolean isCanonicalConstructor(ExecutableElement e) {
        MethodBinding methodBinding = (MethodBinding)((ExecutableElementImpl)e)._binding;
        return methodBinding.isCanonicalConstructor();
    }

    @Override
    public boolean isCompactConstructor(ExecutableElement e) {
        MethodBinding methodBinding = (MethodBinding)((ExecutableElementImpl)e)._binding;
        return methodBinding.isCompactConstructor();
    }

    private boolean isTraditionalJavadoc(char[] unparsed) {
        String[] allLines = new String(unparsed).split("\n");
        Matcher delimiterMatcher = INITIAL_DELIMITER.matcher(allLines[0]);
        return delimiterMatcher.find();
    }

    @Override
    public String getDocComment(Element e) {
        char[] unparsed = this.getUnparsedDocComment(e);
        if (unparsed == null) {
            return null;
        }
        if (this.isTraditionalJavadoc(unparsed)) {
            return ElementsImpl.formatJavadoc(unparsed);
        }
        char[][] lines = TextBlockUtil.convertTextBlockToLines(unparsed);
        char[][] contentLines = new char[lines.length][];
        int i = 0;
        while (i < lines.length) {
            char[] cs = lines[i];
            int slashes = 0;
            int startIdx = 0;
            char[] cArray = cs;
            int n = cs.length;
            int n2 = 0;
            block4: while (n2 < n) {
                char c = cArray[n2];
                ++startIdx;
                switch (c) {
                    case '/': {
                        if (++slashes <= 2) break;
                        break block4;
                    }
                    default: {
                        if (!ScannerHelper.isWhitespace(c) || slashes == 3) break block4;
                    }
                }
                ++n2;
            }
            char[] cs2 = new char[cs.length - startIdx];
            contentLines[i] = cs2;
            System.arraycopy(cs, startIdx, cs2, 0, cs2.length);
            ++i;
        }
        int textBlockIndent = TextBlockUtil.getWhitespacePrefix(contentLines);
        char[] formatTextBlock = TextBlockUtil.formatTextBlock(contentLines, textBlockIndent);
        return new String(formatTextBlock);
    }

    public Elements.DocCommentKind getDocCommentKind(Element e) {
        char[] unparsed = this.getUnparsedDocComment(e);
        if (unparsed == null) {
            return null;
        }
        return this.isTraditionalJavadoc(unparsed) ? Elements.DocCommentKind.TRADITIONAL : Elements.DocCommentKind.END_OF_LINE;
    }
}

