/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.tests.types;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.io.BitBuffer;
import org.eclipse.tracecompass.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.tracecompass.ctf.core.event.types.AbstractArrayDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.Definition;
import org.eclipse.tracecompass.ctf.core.event.types.Encoding;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.StringDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.StructDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.StructDefinition;
import org.eclipse.tracecompass.internal.ctf.core.event.types.SequenceDeclaration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SequenceDeclaration2Test {
    private static final @NonNull String FIELD_NAME = "LengthName";
    private SequenceDeclaration fixture;
    private @NonNull BitBuffer input = new BitBuffer();

    @Before
    public void setUp() {
        this.fixture = new SequenceDeclaration(FIELD_NAME, (IDeclaration)StringDeclaration.getStringDeclaration((Encoding)Encoding.UTF8));
        byte[] byArray = new byte[10];
        byArray[0] = 116;
        byArray[1] = 101;
        byArray[2] = 115;
        byArray[3] = 116;
        byArray[5] = 116;
        byArray[6] = 104;
        byArray[7] = 105;
        byArray[8] = 115;
        byte[] array = byArray;
        ByteBuffer byb = ByteBuffer.wrap(array);
        this.input = new BitBuffer(byb);
    }

    @Test
    public void testSequenceDeclaration() {
        String lengthName = "";
        StringDeclaration elemType = StringDeclaration.getStringDeclaration((Encoding)Encoding.UTF8);
        SequenceDeclaration result = new SequenceDeclaration(lengthName, (IDeclaration)elemType);
        Assert.assertNotNull((Object)result);
        String string = "[declaration] sequence[";
        Assert.assertEquals((Object)string, (Object)result.toString().substring(0, string.length()));
    }

    @Test
    public void testCreateDefinition() throws CTFException {
        long seqLen = 2L;
        IntegerDeclaration id = IntegerDeclaration.createDeclaration((int)8, (boolean)false, (int)8, (ByteOrder)ByteOrder.LITTLE_ENDIAN, (Encoding)Encoding.UTF8, (String)"", (long)32L, null);
        StructDeclaration structDec = new StructDeclaration(0L);
        structDec.addField(FIELD_NAME, (IDeclaration)id);
        StructDefinition structDef = new StructDefinition(structDec, null, "x", new Definition[]{new IntegerDefinition(id, null, FIELD_NAME, seqLen)});
        AbstractArrayDefinition result = this.fixture.createDefinition((IDefinitionScope)structDef, FIELD_NAME, this.input);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testGetElementType() {
        IDeclaration result = this.fixture.getElementType();
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testToString() {
        String result = this.fixture.toString();
        String left = "[declaration] sequence[";
        Assert.assertEquals((Object)left, (Object)result.substring(0, left.length()));
    }

    @Test
    public void hashcodeTest() {
        Assert.assertEquals((long)-1140774256L, (long)this.fixture.hashCode());
        SequenceDeclaration a = new SequenceDeclaration("Hi", (IDeclaration)IntegerDeclaration.INT_32B_DECL);
        SequenceDeclaration b = new SequenceDeclaration("Hello", (IDeclaration)IntegerDeclaration.INT_32B_DECL);
        SequenceDeclaration c = new SequenceDeclaration("Hi", (IDeclaration)StringDeclaration.getStringDeclaration((Encoding)Encoding.UTF8));
        SequenceDeclaration d = new SequenceDeclaration("Hi", (IDeclaration)IntegerDeclaration.INT_32B_DECL);
        Assert.assertNotEquals((long)a.hashCode(), (long)b.hashCode());
        Assert.assertNotEquals((long)a.hashCode(), (long)c.hashCode());
        Assert.assertEquals((long)a.hashCode(), (long)d.hashCode());
    }

    @Test
    public void equalsTest() {
        SequenceDeclaration a = new SequenceDeclaration("Hi", (IDeclaration)IntegerDeclaration.INT_32B_DECL);
        SequenceDeclaration b = new SequenceDeclaration("Hello", (IDeclaration)IntegerDeclaration.INT_32B_DECL);
        SequenceDeclaration c = new SequenceDeclaration("Hi", (IDeclaration)StringDeclaration.getStringDeclaration((Encoding)Encoding.UTF8));
        SequenceDeclaration d = new SequenceDeclaration("Hi", (IDeclaration)IntegerDeclaration.INT_32B_DECL);
        Assert.assertNotEquals((Object)a, null);
        Assert.assertNotEquals((Object)a, (Object)new Object());
        Assert.assertNotEquals((Object)a, (Object)b);
        Assert.assertNotEquals((Object)a, (Object)c);
        Assert.assertEquals((Object)a, (Object)d);
        Assert.assertNotEquals((Object)b, (Object)a);
        Assert.assertNotEquals((Object)c, (Object)a);
        Assert.assertEquals((Object)d, (Object)a);
        Assert.assertEquals((Object)a, (Object)a);
        Assert.assertFalse((boolean)a.isBinaryEquivalent((IDeclaration)b));
        Assert.assertFalse((boolean)a.isBinaryEquivalent((IDeclaration)c));
        Assert.assertTrue((boolean)a.isBinaryEquivalent((IDeclaration)d));
        Assert.assertFalse((boolean)b.isBinaryEquivalent((IDeclaration)a));
        Assert.assertFalse((boolean)c.isBinaryEquivalent((IDeclaration)a));
        Assert.assertTrue((boolean)d.isBinaryEquivalent((IDeclaration)a));
        Assert.assertTrue((boolean)a.isBinaryEquivalent((IDeclaration)a));
    }
}

