/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.tests.trace;

import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.IEventDefinition;
import org.eclipse.tracecompass.ctf.core.tests.shared.CtfTestTraceUtils;
import org.eclipse.tracecompass.ctf.core.trace.CTFTrace;
import org.eclipse.tracecompass.ctf.core.trace.CTFTraceReader;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CTFTraceReaderTest {
    private static final CtfTestTrace testTrace = CtfTestTrace.KERNEL;
    private CTFTraceReader fixture;

    @Before
    public void setUp() throws CTFException {
        this.fixture = new CTFTraceReader(CtfTestTraceUtils.getTrace(testTrace));
    }

    @Test
    public void testOpen_existing() throws CTFException {
        CTFTrace trace = CtfTestTraceUtils.getTrace(testTrace);
        Throwable throwable = null;
        Object var3_4 = null;
        try (CTFTraceReader result = new CTFTraceReader(trace);){
            Assert.assertNotNull((Object)result);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test(expected=CTFException.class)
    public void testOpen_nonexisting() throws CTFException {
        CTFTrace trace = new CTFTrace("badfile.bad");
        Throwable throwable = null;
        Object var3_4 = null;
        try (CTFTraceReader result = new CTFTraceReader(trace);){
            Assert.assertNotNull((Object)result);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test(expected=CTFException.class)
    public void testOpen_invalid() throws CTFException {
        CTFTrace trace = new CTFTrace("");
        Throwable throwable = null;
        Object var3_4 = null;
        try (CTFTraceReader result = new CTFTraceReader(trace);){
            Assert.assertNotNull((Object)result);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testAdvance_normal() throws CTFException {
        boolean result = this.fixture.advance();
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testAdvance_end() throws CTFException {
        int i = 0;
        boolean result = this.fixture.advance();
        while (result) {
            result = this.fixture.advance();
            ++i;
        }
        this.fixture.seek(0L);
        this.fixture.advance();
        this.fixture.goToLastEvent();
        i = 1;
        result = this.fixture.advance();
        while (result) {
            result = this.fixture.advance();
            ++i;
        }
        Assert.assertFalse((boolean)result);
        Assert.assertEquals((long)i, (long)1L);
    }

    @Test
    public void testCopyFrom() throws CTFException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (CTFTraceReader result = this.fixture.copyFrom();){
            Assert.assertNotNull((Object)result);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testGetCurrentEventDef_first() {
        IEventDefinition result = this.fixture.getCurrentEventDef();
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testGetCurrentEventDef_last() throws CTFException {
        this.fixture.goToLastEvent();
        IEventDefinition result = this.fixture.getCurrentEventDef();
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testGetEndTime() {
        long result = this.fixture.getEndTime();
        Assert.assertTrue((0L < result ? 1 : 0) != 0);
    }

    @Test
    public void testGetStartTime() {
        long result = this.fixture.getStartTime();
        Assert.assertTrue((0L < result ? 1 : 0) != 0);
    }

    @Test
    public void testGoToLastEvent() throws CTFException {
        this.fixture.goToLastEvent();
        long ts1 = this.getTimestamp();
        long ts2 = this.fixture.getEndTime();
        Assert.assertEquals((long)ts1, (long)ts2);
    }

    @Test
    public void testHasMoreEvents() {
        boolean result = this.fixture.hasMoreEvents();
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testPrintStats_noparam() throws CTFException {
        this.fixture.advance();
        this.fixture.printStats();
    }

    @Test
    public void testPrintStats_width0() throws CTFException {
        this.fixture.advance();
        this.fixture.printStats(0);
    }

    @Test
    public void testPrintStats_width1() throws CTFException {
        this.fixture.advance();
        this.fixture.printStats(1);
    }

    @Test
    public void testPrintStats_width2() throws CTFException {
        this.fixture.advance();
        this.fixture.printStats(2);
    }

    @Test
    public void testPrintStats_width10() throws CTFException {
        this.fixture.advance();
        this.fixture.printStats(10);
    }

    @Test
    public void testPrintStats_100() throws CTFException {
        int i = 0;
        while (i < 1000) {
            this.fixture.advance();
            ++i;
        }
        this.fixture.printStats(100);
    }

    @Test
    public void testSeek() throws CTFException {
        long timestamp = 1L;
        boolean result = this.fixture.seek(timestamp);
        Assert.assertTrue((boolean)result);
    }

    private long getTimestamp() {
        if (this.fixture.getCurrentEventDef() != null) {
            return this.fixture.getTrace().timestampCyclesToNanos(this.fixture.getCurrentEventDef().getTimestamp());
        }
        return -1L;
    }
}

