/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.ust.core.tests.analysis.debuginfo;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.lttng2.ust.core.analysis.debuginfo.BinaryCallsite;
import org.eclipse.tracecompass.lttng2.ust.core.analysis.debuginfo.UstDebugInfoAnalysisModule;
import org.eclipse.tracecompass.lttng2.ust.core.analysis.debuginfo.UstDebugInfoBinaryAspect;
import org.eclipse.tracecompass.lttng2.ust.core.analysis.debuginfo.UstDebugInfoBinaryFile;
import org.eclipse.tracecompass.lttng2.ust.core.analysis.debuginfo.UstDebugInfoLoadedBinaryFile;
import org.eclipse.tracecompass.lttng2.ust.core.tests.shared.LttngUstTestTraceUtils;
import org.eclipse.tracecompass.lttng2.ust.core.trace.LttngUstEvent;
import org.eclipse.tracecompass.lttng2.ust.core.trace.LttngUstTrace;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.request.ITmfEventRequest;
import org.eclipse.tracecompass.tmf.core.request.TmfEventRequest;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class UstDebugInfoAnalysisModuleTest {
    private static final @NonNull CtfTestTrace REAL_TEST_TRACE = CtfTestTrace.DEBUG_INFO4;
    private static final @NonNull CtfTestTrace SYNTH_EXEC_TRACE = CtfTestTrace.DEBUG_INFO_SYNTH_EXEC;
    private static final @NonNull CtfTestTrace SYNTH_TWO_PROCESSES_TRACE = CtfTestTrace.DEBUG_INFO_SYNTH_TWO_PROCESSES;
    private static final @NonNull CtfTestTrace SYNTH_BUILDID_DEBUGLINK_TRACE = CtfTestTrace.DEBUG_INFO_SYNTH_BUILDID_DEBUGLINK;
    private static final @NonNull CtfTestTrace INVALID_TRACE = CtfTestTrace.CYG_PROFILE;
    private UstDebugInfoAnalysisModule fModule;

    @Before
    public void setup() {
        this.fModule = new UstDebugInfoAnalysisModule();
    }

    @After
    public void tearDown() {
        this.fModule.dispose();
        this.fModule = null;
    }

    @Test
    public void testGetAnalysisRequirements() {
        Iterable requirements = this.fModule.getAnalysisRequirements();
        Assert.assertNotNull((Object)requirements);
        Assert.assertTrue((boolean)Iterables.isEmpty((Iterable)requirements));
    }

    @Test
    public void testCanExecute() {
        LttngUstTrace trace = LttngUstTestTraceUtils.getTrace(REAL_TEST_TRACE);
        Assert.assertTrue((boolean)this.fModule.canExecute((ITmfTrace)trace));
        LttngUstTestTraceUtils.dispose(REAL_TEST_TRACE);
    }

    @Test
    public void testCannotExcecute() {
        LttngUstTrace invalidTrace = LttngUstTestTraceUtils.getTrace(INVALID_TRACE);
        Assert.assertFalse((boolean)this.fModule.canExecute((ITmfTrace)invalidTrace));
        LttngUstTestTraceUtils.dispose(INVALID_TRACE);
    }

    private void executeModule(ITmfTrace trace) {
        Assert.assertNotNull((Object)trace);
        try {
            this.fModule.setTrace(trace);
        }
        catch (TmfAnalysisException tmfAnalysisException) {
            Assert.fail();
        }
        this.fModule.schedule();
        this.fModule.waitForCompletion();
    }

    @Test
    public void testExecution() {
        LttngUstTrace trace = LttngUstTestTraceUtils.getTrace(REAL_TEST_TRACE);
        this.executeModule((ITmfTrace)trace);
        ITmfStateSystem ss = this.fModule.getStateSystem();
        Assert.assertNotNull((Object)ss);
        LttngUstTestTraceUtils.dispose(REAL_TEST_TRACE);
    }

    @Test
    public void testBinaryCallsites() {
        LttngUstTrace trace = LttngUstTestTraceUtils.getTrace(REAL_TEST_TRACE);
        TmfTraceOpenedSignal signal = new TmfTraceOpenedSignal((Object)this, (ITmfTrace)trace, null);
        TmfSignalManager.dispatchSignal((TmfSignal)signal);
        UstDebugInfoAnalysisModule module = (UstDebugInfoAnalysisModule)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, UstDebugInfoAnalysisModule.class, (String)"org.eclipse.linuxtools.lttng2.ust.analysis.debuginfo");
        Assert.assertNotNull((Object)module);
        module.waitForCompletion();
        final ArrayList<@NonNull E> events = new ArrayList();
        TmfEventRequest request = new TmfEventRequest(LttngUstEvent.class, 31L, 1, ITmfEventRequest.ExecutionType.FOREGROUND){

            public void handleData(ITmfEvent event) {
                super.handleData(event);
                events.add((LttngUstEvent)event);
            }
        };
        trace.sendRequest((ITmfEventRequest)request);
        try {
            request.waitForCompletion();
        }
        catch (InterruptedException e) {
            Assert.fail((String)e.getMessage());
        }
        UstDebugInfoBinaryAspect aspect = UstDebugInfoBinaryAspect.INSTANCE;
        String actual = ((BinaryCallsite)NonNullUtils.checkNotNull((Object)aspect.resolve((ITmfEvent)events.get(0)))).toString();
        String expected = "/home/simark/src/babeltrace/tests/debug-info-data/libhello_so+0x14d4";
        Assert.assertEquals((Object)expected, (Object)actual);
        LttngUstTestTraceUtils.dispose(REAL_TEST_TRACE);
    }

    @Test
    public void testExec() {
        int vpid = 1337;
        LttngUstTrace trace = LttngUstTestTraceUtils.getTrace(SYNTH_EXEC_TRACE);
        this.executeModule((ITmfTrace)trace);
        UstDebugInfoLoadedBinaryFile expected = new UstDebugInfoLoadedBinaryFile(0x400000L, "/tmp/foo", null, null, false);
        UstDebugInfoLoadedBinaryFile matchingFile = this.fModule.getMatchingFile(4000000L, (long)vpid, 0x400100L);
        Assert.assertEquals((Object)expected, (Object)matchingFile);
        expected = null;
        matchingFile = this.fModule.getMatchingFile(8000000L, (long)vpid, 0x400100L);
        Assert.assertEquals((Object)expected, (Object)matchingFile);
        expected = new UstDebugInfoLoadedBinaryFile(0x500000L, "/tmp/bar", null, null, false);
        matchingFile = this.fModule.getMatchingFile(9000000L, (long)vpid, 0x500100L);
        Assert.assertEquals((Object)expected, (Object)matchingFile);
        LttngUstTestTraceUtils.dispose(SYNTH_EXEC_TRACE);
    }

    @Test
    public void testTwoProcesses() {
        int vpid1 = 1337;
        int vpid2 = 2001;
        LttngUstTrace trace = LttngUstTestTraceUtils.getTrace(SYNTH_TWO_PROCESSES_TRACE);
        this.executeModule((ITmfTrace)trace);
        UstDebugInfoLoadedBinaryFile expected = new UstDebugInfoLoadedBinaryFile(0x400000L, "/tmp/foo", "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa", "/tmp/debuglink1", false);
        UstDebugInfoLoadedBinaryFile matchingFile = this.fModule.getMatchingFile(11000000L, (long)vpid1, 0x400100L);
        Assert.assertEquals((Object)expected, (Object)matchingFile);
        expected = new UstDebugInfoLoadedBinaryFile(0x400000L, "/tmp/bar", "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb", "/tmp/debuglink2", false);
        matchingFile = this.fModule.getMatchingFile(12000000L, (long)vpid2, 0x400100L);
        Assert.assertEquals((Object)expected, (Object)matchingFile);
        LttngUstTestTraceUtils.dispose(SYNTH_TWO_PROCESSES_TRACE);
    }

    @Test
    public void testBuildIDDebugLink() {
        LttngUstTrace trace = LttngUstTestTraceUtils.getTrace(SYNTH_BUILDID_DEBUGLINK_TRACE);
        this.executeModule((ITmfTrace)trace);
        UstDebugInfoLoadedBinaryFile expected = new UstDebugInfoLoadedBinaryFile(0x400000L, "/tmp/foo_nn", null, null, false);
        UstDebugInfoLoadedBinaryFile matchingFile = this.fModule.getMatchingFile(17000000L, 1337L, 0x400100L);
        Assert.assertEquals((Object)expected, (Object)matchingFile);
        expected = new UstDebugInfoLoadedBinaryFile(0x400000L, "/tmp/foo_yn", "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa", null, false);
        matchingFile = this.fModule.getMatchingFile(18000000L, 1338L, 0x400100L);
        Assert.assertEquals((Object)expected, (Object)matchingFile);
        expected = new UstDebugInfoLoadedBinaryFile(0x400000L, "/tmp/foo_ny", null, "/tmp/debug_link1", false);
        matchingFile = this.fModule.getMatchingFile(19000000L, 1339L, 0x400100L);
        Assert.assertEquals((Object)expected, (Object)matchingFile);
        expected = new UstDebugInfoLoadedBinaryFile(0x400000L, "/tmp/foo_yy", "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb", "/tmp/debug_link2", false);
        matchingFile = this.fModule.getMatchingFile(20000000L, 1340L, 0x400100L);
        Assert.assertEquals((Object)expected, (Object)matchingFile);
        LttngUstTestTraceUtils.dispose(SYNTH_BUILDID_DEBUGLINK_TRACE);
    }

    @Test
    public void testGetAllBinaries() {
        LttngUstTrace trace = LttngUstTestTraceUtils.getTrace(REAL_TEST_TRACE);
        this.executeModule((ITmfTrace)trace);
        ArrayList actualBinaries = Lists.newArrayList((Iterable)this.fModule.getAllBinaries());
        ArrayList expectedBinaries = Lists.newArrayList((Object[])new UstDebugInfoBinaryFile[]{new UstDebugInfoBinaryFile("/home/simark/src/babeltrace/tests/debug-info-data/libhello_so", "cdd98cdd87f7fe64c13b6daad553987eafd40cbb", null, true), new UstDebugInfoBinaryFile("/home/simark/src/babeltrace/tests/debug-info-data/test", "0683255d2cf219c33cc0efd6039db09ccc4416d7", null, false), new UstDebugInfoBinaryFile("[linux-vdso.so.1]", null, null, false), new UstDebugInfoBinaryFile("/usr/local/lib/liblttng-ust-dl.so.0.0.0", "39c035014cc02008d6884fcb1be4e020cc820366", null, true), new UstDebugInfoBinaryFile("/usr/lib/libdl-2.23.so", "db3f9be9f4ebe9e2a21e4ae0b4ef7165d40fdfef", null, true), new UstDebugInfoBinaryFile("/usr/lib/libc-2.23.so", "946025a5cad7b5f2dfbaebc6ebd1fcc004349b48", null, true), new UstDebugInfoBinaryFile("/usr/local/lib/liblttng-ust.so.0.0.0", "405b0b15daa73eccb88076247ba30356c00d3b92", null, true), new UstDebugInfoBinaryFile("/usr/local/lib/liblttng-ust-tracepoint.so.0.0.0", "62c028aad38adb5e0910c527d522e8c86a0a3344", null, true), new UstDebugInfoBinaryFile("/usr/lib/librt-2.23.so", "aba676bda7fb6adb71e100159915504e1a0c17e6", null, true), new UstDebugInfoBinaryFile("/usr/lib/liburcu-bp.so.4.0.0", "b9dfadea234107f8453bc636fc160047e0c01b7a", null, true), new UstDebugInfoBinaryFile("/usr/lib/liburcu-cds.so.4.0.0", "420527f6dacc762378d9fa7def54d91c80a6c87e", null, true), new UstDebugInfoBinaryFile("/usr/lib/libpthread-2.23.so", "d91ed99c8425b7ce5da5bb750662a91038e02a78", null, true), new UstDebugInfoBinaryFile("/usr/lib/ld-2.23.so", "524eff0527e923e4adc4be9db1ef7475607b92e8", null, true), new UstDebugInfoBinaryFile("/usr/lib/liburcu-common.so.4.0.0", "f279a6d46a2b846e15e7abd99cfe9fbe8d7f8295", null, true)});
        Comparator<UstDebugInfoBinaryFile> comparator = Comparator.comparing(UstDebugInfoBinaryFile::getFilePath);
        actualBinaries.sort(comparator);
        expectedBinaries.sort(comparator);
        int i = 0;
        while (i < expectedBinaries.size()) {
            Assert.assertEquals(expectedBinaries.get(i), actualBinaries.get(i));
            ++i;
        }
        Assert.assertEquals((Object)actualBinaries, (Object)expectedBinaries);
        LttngUstTestTraceUtils.dispose(REAL_TEST_TRACE);
    }
}

