/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.core.execution.graph;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.graph.core.base.IGraphWorker;
import org.eclipse.tracecompass.analysis.graph.core.building.AbstractTmfGraphBuilderModule;
import org.eclipse.tracecompass.analysis.graph.core.building.ITmfGraphProvider;
import org.eclipse.tracecompass.analysis.graph.core.criticalpath.AbstractCriticalPathModule;
import org.eclipse.tracecompass.analysis.graph.core.criticalpath.OSCriticalPathModule;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfGraph;
import org.eclipse.tracecompass.analysis.graph.core.graph.WorkerSerializer;
import org.eclipse.tracecompass.analysis.os.linux.core.execution.graph.OsExecutionGraphProvider;
import org.eclipse.tracecompass.analysis.os.linux.core.execution.graph.OsWorker;
import org.eclipse.tracecompass.analysis.os.linux.core.model.HostThread;
import org.eclipse.tracecompass.internal.analysis.graph.core.graph.historytree.OsHistoryTreeGraph;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class OsExecutionGraph
extends AbstractTmfGraphBuilderModule {
    public static final String ANALYSIS_ID = "org.eclipse.tracecompass.analysis.os.linux.execgraph";
    private @Nullable OSCriticalPathModule fCriticalPathModule;
    private static WorkerSerializer WORKER_SERIALIZER = new OsWorkerSerializer();

    public boolean canExecute(ITmfTrace trace) {
        return true;
    }

    protected ITmfGraphProvider getGraphProvider() {
        ITmfTrace trace = this.getTrace();
        if (trace == null) {
            throw new NullPointerException();
        }
        return new OsExecutionGraphProvider(trace);
    }

    protected @Nullable ITmfGraph createGraphInstance(Path htFile, WorkerSerializer workerSerializer, long startTime, int version) {
        OsHistoryTreeGraph graph;
        try {
            graph = new OsHistoryTreeGraph(htFile, version, workerSerializer, startTime);
        }
        catch (IOException iOException) {
            return null;
        }
        return graph;
    }

    protected AbstractCriticalPathModule getCriticalPathModule() {
        if (this.fCriticalPathModule == null) {
            this.fCriticalPathModule = new OSCriticalPathModule((AbstractTmfGraphBuilderModule)this);
        }
        return (AbstractCriticalPathModule)Objects.requireNonNull(this.fCriticalPathModule);
    }

    protected String getFullHelpText() {
        return super.getFullHelpText();
    }

    protected String getShortHelpText(ITmfTrace trace) {
        return super.getShortHelpText(trace);
    }

    protected String getTraceCannotExecuteHelpText(ITmfTrace trace) {
        return "The trace must have events 'sched_switch' and 'sched_wakeup' enabled";
    }

    public WorkerSerializer getWorkerSerializer() {
        return WORKER_SERIALIZER;
    }

    private static class OsWorkerSerializer
    implements WorkerSerializer {
        private static final String SERIALIZER_SEPARATOR = "///";

        private OsWorkerSerializer() {
        }

        public String serialize(IGraphWorker worker) {
            if (!(worker instanceof OsWorker)) {
                throw new IllegalArgumentException("Unexpected type of worker: " + worker);
            }
            OsWorker osWorker = (OsWorker)worker;
            return osWorker.getHostThread().getTid() + SERIALIZER_SEPARATOR + osWorker.getStart() + SERIALIZER_SEPARATOR + osWorker.getHostId() + SERIALIZER_SEPARATOR + osWorker.getName();
        }

        public IGraphWorker deserialize(String serializedWorker) {
            @NonNull String[] workerParts = serializedWorker.split(SERIALIZER_SEPARATOR, 4);
            return new OsWorker(new HostThread(workerParts[2], Integer.decode(workerParts[0])), workerParts[3], Long.decode(workerParts[1]));
        }
    }
}

