/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.pcap.core.analysis;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.pcap.core.event.PcapEvent;
import org.eclipse.tracecompass.internal.tmf.pcap.core.event.TmfPacketStreamBuilder;
import org.eclipse.tracecompass.internal.tmf.pcap.core.protocol.TmfPcapProtocol;
import org.eclipse.tracecompass.internal.tmf.pcap.core.trace.PcapTrace;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAbstractAnalysisModule;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.request.ITmfEventRequest;
import org.eclipse.tracecompass.tmf.core.request.TmfEventRequest;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;

public class StreamListAnalysis
extends TmfAbstractAnalysisModule {
    public static final String ID = "org.eclipse.linuxtools.tmf.pcap.core.analysis.stream";
    private @Nullable ITmfEventRequest fRequest;
    private final Map<TmfPcapProtocol, TmfPacketStreamBuilder> fBuilders = new HashMap<TmfPcapProtocol, TmfPacketStreamBuilder>();

    public StreamListAnalysis() {
        TmfPcapProtocol[] tmfPcapProtocolArray = TmfPcapProtocol.values();
        int n = tmfPcapProtocolArray.length;
        int n2 = 0;
        while (n2 < n) {
            TmfPcapProtocol protocol = tmfPcapProtocolArray[n2];
            if (protocol.supportsStream()) {
                this.fBuilders.put(protocol, new TmfPacketStreamBuilder(protocol));
            }
            ++n2;
        }
    }

    public boolean canExecute(ITmfTrace trace) {
        if (trace instanceof PcapTrace) {
            return true;
        }
        if (!(trace instanceof TmfExperiment)) {
            return false;
        }
        TmfExperiment experiment = (TmfExperiment)trace;
        List traces = experiment.getTraces();
        for (ITmfTrace expTrace : traces) {
            if (!(expTrace instanceof PcapTrace)) continue;
            return true;
        }
        return false;
    }

    protected boolean executeAnalysis(@Nullable IProgressMonitor monitor) throws TmfAnalysisException {
        IProgressMonitor mon = monitor == null ? new NullProgressMonitor() : monitor;
        ITmfTrace trace = this.getTrace();
        if (trace == null) {
            return false;
        }
        Object request = this.fRequest;
        if (request != null && !request.isCompleted()) {
            request.cancel();
        }
        request = new TmfEventRequest(PcapEvent.class, TmfTimeRange.ETERNITY, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.BACKGROUND){

            public void handleData(ITmfEvent data) {
                super.handleData(data);
                if (!(data instanceof PcapEvent)) {
                    return;
                }
                PcapEvent event = (PcapEvent)data;
                for (Map.Entry entry : StreamListAnalysis.this.fBuilders.entrySet()) {
                    ((TmfPacketStreamBuilder)entry.getValue()).addEventToStream(event);
                }
            }
        };
        trace.sendRequest(request);
        this.fRequest = request;
        try {
            request.waitForCompletion();
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return !mon.isCanceled() && !request.isCancelled() && !request.isFailed();
    }

    protected void canceling() {
        ITmfEventRequest req = this.fRequest;
        if (req != null && !req.isCompleted()) {
            req.cancel();
        }
    }

    public @Nullable TmfPacketStreamBuilder getBuilder(TmfPcapProtocol protocol) {
        return this.fBuilders.get((Object)protocol);
    }

    public boolean isFinished() {
        ITmfEventRequest req = this.fRequest;
        if (req == null) {
            return false;
        }
        return req.isCompleted();
    }
}

