/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.filters.ui.views.global;

import com.google.gson.Gson;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tracecompass.incubator.internal.filters.ui.lspFilterTextbox.FilterValidityListener;
import org.eclipse.tracecompass.incubator.internal.filters.ui.lspFilterTextbox.LspFilterTextbox;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.TmfFilterAppliedSignal;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.TraceCompassFilter;
import org.eclipse.tracecompass.tmf.core.component.ITmfComponent;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;

public class GlobalFilterViewer
extends Composite {
    private static final Gson GSON = new Gson();
    private final ExpandBar fExpandBar;
    private final LinkedHashSet<String> fEnabledFilters = new LinkedHashSet();
    private final LinkedHashSet<String> fDisabledFilters = new LinkedHashSet();
    private final ITmfComponent fComponent;
    private final org.eclipse.swt.widgets.List fActiveArea;
    private final ExpandItem fActive;
    private final org.eclipse.swt.widgets.List fSavedArea;
    private final ExpandItem fSaved;
    private final LspFilterTextbox fLspFilterTextbox;

    public void deleteSelected() {
        String string;
        String[] strings;
        String[] stringArray = strings = this.fActiveArea.getSelection();
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            string = stringArray[n2];
            this.fEnabledFilters.remove(string);
            ++n2;
        }
        stringArray = strings = this.fSavedArea.getSelection();
        n = strings.length;
        n2 = 0;
        while (n2 < n) {
            string = stringArray[n2];
            this.fDisabledFilters.remove(string);
            ++n2;
        }
        this.filtersUpdated();
    }

    public void redraw() {
        String[] enabled = this.fEnabledFilters.toArray(new String[this.fEnabledFilters.size()]);
        this.fActiveArea.setItems(enabled);
        Point size = this.fActiveArea.computeSize(-1, -1);
        this.fActive.setHeight(size.y);
        String[] disabled = this.fDisabledFilters.toArray(new String[this.fDisabledFilters.size()]);
        this.fSavedArea.setItems(disabled);
        size = this.fSavedArea.computeSize(-1, -1);
        this.fSaved.setHeight(size.y);
        super.redraw();
    }

    public GlobalFilterViewer(ITmfComponent component, Composite parent, int style) {
        super(parent, style);
        this.fComponent = component;
        this.fLspFilterTextbox = new LspFilterTextbox(parent, component.getName());
        this.fLspFilterTextbox.addValidListener(new FilterValidityListener(){

            @Override
            public void validFilter() {
                String text = Objects.requireNonNull(GlobalFilterViewer.this.fLspFilterTextbox.getText());
                text = Objects.requireNonNull(text.trim());
                GlobalFilterViewer.this.fLspFilterTextbox.setText("");
                if (text.isEmpty() || GlobalFilterViewer.this.fEnabledFilters.contains(text)) {
                    return;
                }
                if (GlobalFilterViewer.this.fDisabledFilters.contains(text)) {
                    GlobalFilterViewer.this.fDisabledFilters.remove(text);
                }
                GlobalFilterViewer.this.fEnabledFilters.add(text);
                GlobalFilterViewer.this.fSavedArea.removeAll();
                GlobalFilterViewer.this.fDisabledFilters.forEach(string -> GlobalFilterViewer.this.fSavedArea.add(string));
                GlobalFilterViewer.this.filtersUpdated();
            }

            @Override
            public void invalidFilter() {
            }
        });
        this.fExpandBar = new ExpandBar(parent, 512);
        parent.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        this.fExpandBar.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        this.fExpandBar.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.fActive = new ExpandItem(this.fExpandBar, 0, 0);
        this.fActive.setText("Active");
        this.fActive.setHeight(16);
        this.fActiveArea = new org.eclipse.swt.widgets.List((Composite)this.fExpandBar, 2);
        this.fActiveArea.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.fActive.setControl((Control)this.fActiveArea);
        this.fSaved = new ExpandItem(this.fExpandBar, 0, 1);
        this.fSaved.setText("Saved");
        this.fSaved.setHeight(16);
        this.fSavedArea = new org.eclipse.swt.widgets.List((Composite)this.fExpandBar, 2);
        this.fSavedArea.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.fSaved.setControl((Control)this.fSavedArea);
        this.fActive.setExpanded(true);
        this.fSaved.setExpanded(true);
        this.fActiveArea.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(@Nullable MouseEvent e) {
                String[] selection = GlobalFilterViewer.this.fActiveArea.getSelection();
                if (selection.length <= 0) {
                    return;
                }
                String toEdit = selection[0];
                if (toEdit == null) {
                    return;
                }
                GlobalFilterViewer.this.fLspFilterTextbox.setText(toEdit);
                GlobalFilterViewer.this.fEnabledFilters.remove(toEdit);
                GlobalFilterViewer.this.fDisabledFilters.add(toEdit);
                GlobalFilterViewer.this.filtersUpdated();
            }

            public void mouseDown(@Nullable MouseEvent e) {
            }

            public void mouseUp(@Nullable MouseEvent e) {
            }
        });
        this.fSavedArea.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(@Nullable MouseEvent e) {
                String[] selection = GlobalFilterViewer.this.fSavedArea.getSelection();
                if (selection.length <= 0) {
                    return;
                }
                String toEdit = selection[0];
                GlobalFilterViewer.this.fLspFilterTextbox.setText(toEdit);
                GlobalFilterViewer.this.filtersUpdated();
            }

            public void mouseDown(@Nullable MouseEvent e) {
            }

            public void mouseUp(@Nullable MouseEvent e) {
            }
        });
        DragSource activeSource = new DragSource((Control)this.fActiveArea, 2);
        activeSource.setTransfer(new Transfer[]{TextTransfer.getInstance()});
        activeSource.addDragListener(new DragSourceListener(){

            public void dragStart(@Nullable DragSourceEvent event) {
                if (event == null) {
                    return;
                }
                if (GlobalFilterViewer.this.fActiveArea.getSelection().length == 0) {
                    event.doit = false;
                }
            }

            public void dragSetData(@Nullable DragSourceEvent event) {
                if (event == null) {
                    return;
                }
                if (TextTransfer.getInstance().isSupportedType(event.dataType)) {
                    event.data = GSON.toJson((Object)GlobalFilterViewer.this.fActiveArea.getSelection());
                }
            }

            public void dragFinished(@Nullable DragSourceEvent event) {
            }
        });
        DragSource savedSource = new DragSource((Control)this.fSavedArea, 2);
        savedSource.setTransfer(new Transfer[]{TextTransfer.getInstance()});
        savedSource.addDragListener(new DragSourceListener(){

            public void dragStart(@Nullable DragSourceEvent event) {
                if (event == null) {
                    return;
                }
                if (GlobalFilterViewer.this.fSavedArea.getSelection().length == 0) {
                    event.doit = false;
                }
            }

            public void dragSetData(@Nullable DragSourceEvent event) {
                if (event == null) {
                    return;
                }
                if (TextTransfer.getInstance().isSupportedType(event.dataType)) {
                    event.data = GSON.toJson((Object)GlobalFilterViewer.this.fSavedArea.getSelection());
                }
            }

            public void dragFinished(@Nullable DragSourceEvent event) {
            }
        });
        DropTarget activeTarget = new DropTarget((Control)this.fActiveArea, 18);
        activeTarget.setTransfer(new Transfer[]{TextTransfer.getInstance()});
        activeTarget.addDropListener(new DropTargetListener(){

            public void dropAccept(@Nullable DropTargetEvent event) {
            }

            public void drop(@Nullable DropTargetEvent event) {
                if (event == null) {
                    return;
                }
                String[] strings = (String[])GSON.fromJson(String.valueOf(event.data), String[].class);
                boolean updated = false;
                String[] stringArray = strings;
                int n = strings.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    if (string != null && !GlobalFilterViewer.this.fEnabledFilters.contains(string) && GlobalFilterViewer.this.fDisabledFilters.contains(string)) {
                        updated = true;
                        GlobalFilterViewer.this.fEnabledFilters.add(string);
                        GlobalFilterViewer.this.fDisabledFilters.remove(string);
                    }
                    ++n2;
                }
                if (updated) {
                    GlobalFilterViewer.this.filtersUpdated();
                }
            }

            public void dragOver(@Nullable DropTargetEvent event) {
            }

            public void dragOperationChanged(@Nullable DropTargetEvent event) {
            }

            public void dragLeave(@Nullable DropTargetEvent event) {
            }

            public void dragEnter(@Nullable DropTargetEvent event) {
                if (event == null) {
                    return;
                }
                if (event.detail == 16) {
                    event.detail = 2;
                }
            }
        });
        DropTarget savedTarget = new DropTarget((Control)this.fSavedArea, 18);
        savedTarget.setTransfer(new Transfer[]{TextTransfer.getInstance()});
        savedTarget.addDropListener(new DropTargetListener(){

            public void dropAccept(@Nullable DropTargetEvent event) {
            }

            public void drop(@Nullable DropTargetEvent event) {
                if (event == null) {
                    return;
                }
                String[] strings = (String[])GSON.fromJson(String.valueOf(event.data), String[].class);
                boolean updated = false;
                String[] stringArray = strings;
                int n = strings.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    if (string != null && GlobalFilterViewer.this.fEnabledFilters.contains(string) && !GlobalFilterViewer.this.fDisabledFilters.contains(string)) {
                        updated = true;
                        GlobalFilterViewer.this.fDisabledFilters.add(string);
                        GlobalFilterViewer.this.fEnabledFilters.remove(string);
                    }
                    ++n2;
                }
                if (updated) {
                    GlobalFilterViewer.this.filtersUpdated();
                }
            }

            public void dragOver(@Nullable DropTargetEvent event) {
            }

            public void dragOperationChanged(@Nullable DropTargetEvent event) {
            }

            public void dragLeave(@Nullable DropTargetEvent event) {
            }

            public void dragEnter(@Nullable DropTargetEvent event) {
                if (event == null) {
                    return;
                }
                if (event.detail == 16) {
                    event.detail = 2;
                }
            }
        });
        this.layout(true);
    }

    public boolean setFocus() {
        return this.fLspFilterTextbox.setFocus();
    }

    private void filtersUpdated() {
        List filter = this.fEnabledFilters.stream().map(f -> String.valueOf('(') + f + ')').collect(Collectors.toList());
        ITmfTrace trace = TmfTraceManager.getInstance().getActiveTrace();
        if (trace == null) {
            return;
        }
        this.fComponent.broadcast((TmfSignal)new TmfFilterAppliedSignal((Object)this.fComponent, trace, TraceCompassFilter.fromRegex(filter, (ITmfTrace)trace)));
        this.redraw();
    }

    void eventFilterApplied(Collection<String> regexes) {
        if (!regexes.isEmpty() && this.fEnabledFilters.containsAll(regexes)) {
            return;
        }
        this.fEnabledFilters.forEach(f -> {
            boolean bl = this.fDisabledFilters.add((String)f);
        });
        this.fEnabledFilters.clear();
        if (!regexes.isEmpty()) {
            this.fEnabledFilters.addAll(regexes);
        }
        this.fDisabledFilters.removeAll(regexes);
        Display.getDefault().asyncExec(() -> this.redraw());
    }
}

