/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.vis.jfree.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.trace4cps.core.IClaim;
import org.eclipse.trace4cps.core.IResource;
import org.eclipse.trace4cps.vis.jfree.ClaimScaling;
import org.eclipse.trace4cps.vis.jfree.impl.Cell;
import org.eclipse.trace4cps.vis.jfree.impl.ClaimFragment;

public class ClaimCell
extends Cell<IClaim> {
    ClaimCell(String description) {
        super(description);
    }

    public void scaleClaims(ClaimScaling scaling) {
        if (scaling == ClaimScaling.NONE) {
            return;
        }
        IResource r = null;
        if (scaling == ClaimScaling.RESOURCE_AMOUNT && (r = this.getResource()).useOffset()) {
            int i = 0;
            while (i < this.items.size()) {
                IClaim claim = (IClaim)this.items.get(i);
                double offset = claim.getOffset().doubleValue() / r.getCapacity().doubleValue() * 0.8;
                double fraction = claim.getAmount().doubleValue() / r.getCapacity().doubleValue() * 0.8;
                ClaimFragment frag = new ClaimFragment(claim, claim.getStartTime().doubleValue(), claim.getEndTime().doubleValue(), offset, fraction);
                this.items.set(i, frag);
                ++i;
            }
            return;
        }
        List<Event> events = this.getEvents();
        this.items.clear();
        ArrayList<IClaim> active = new ArrayList<IClaim>();
        double prevEventTime = Double.NaN;
        int i = 0;
        while (i < events.size()) {
            Event e = events.get(i);
            double now = e.t.doubleValue();
            int endIdx = this.getNextIndex(events, i);
            this.createFragmentsForActiveClaims(active, scaling, r, prevEventTime, now);
            this.updateActiveClaims(events, active, i, endIdx);
            this.processClaimsWithZeroDuration(events, now, i, endIdx);
            prevEventTime = now;
            i = endIdx;
        }
    }

    private void processClaimsWithZeroDuration(List<Event> events, double now, int i, int endIdx) {
        int j = i;
        while (j < endIdx) {
            Event ej = events.get(j);
            if (ej.isStart && ej.parent.getEndTime().doubleValue() == now) {
                ClaimFragment frag = new ClaimFragment(ej.parent, now, now, 0.1, 0.8);
                this.items.add(frag);
            }
            ++j;
        }
    }

    private void updateActiveClaims(List<Event> events, List<IClaim> active, int i, int endIdx) {
        int j = i;
        while (j < endIdx) {
            Event ej = events.get(j);
            if (!ej.isStart) {
                active.remove(ej.parent);
            } else {
                active.add(ej.parent);
            }
            ++j;
        }
    }

    private int getNextIndex(List<Event> events, int i) {
        double tsi = events.get((int)i).t.doubleValue();
        int j = i + 1;
        while (j < events.size()) {
            double tsj = events.get((int)j).t.doubleValue();
            if (tsj > tsi) {
                return j;
            }
            ++j;
        }
        return events.size();
    }

    private void createFragmentsForActiveClaims(List<IClaim> active, ClaimScaling scaling, IResource r, double prevEventTime, double now) {
        if (!Double.isNaN(prevEventTime)) {
            switch (scaling) {
                case FULL: {
                    this.createAndAddFragments(active, prevEventTime, now);
                    break;
                }
                case RESOURCE_AMOUNT: {
                    this.createAndAddFragments(active, prevEventTime, now, r);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    private void createAndAddFragments(List<IClaim> active, double prevEventTime, double now) {
        double offset = 0.0;
        double fraction = 0.8 / (double)active.size();
        for (IClaim a : active) {
            ClaimFragment frag = new ClaimFragment(a, prevEventTime, now, offset, fraction);
            this.items.add(frag);
            offset += fraction;
        }
    }

    private void createAndAddFragments(List<IClaim> active, double prevEventTime, double now, IResource r) {
        if (r.useOffset()) {
            for (IClaim a : active) {
                double offset = a.getOffset().doubleValue() / r.getCapacity().doubleValue() * 0.8;
                double fraction = a.getAmount().doubleValue() / r.getCapacity().doubleValue() * 0.8;
                ClaimFragment frag = new ClaimFragment(a, prevEventTime, now, offset, fraction);
                this.items.add(frag);
            }
        } else {
            double offset = 0.0;
            for (IClaim a : active) {
                double fraction = a.getAmount().doubleValue() / r.getCapacity().doubleValue() * 0.8;
                ClaimFragment frag = new ClaimFragment(a, prevEventTime, now, offset, fraction);
                this.items.add(frag);
                offset += fraction;
            }
        }
    }

    private IResource getResource() {
        IResource r = null;
        for (IClaim c : this.items) {
            if (r != null && !r.equals(c.getResource())) {
                throw new IllegalStateException("cannot apply RESOURCE_AMOUNT scaling to a swim lane with multiple resources");
            }
            r = c.getResource();
        }
        return r;
    }

    private List<Event> getEvents() {
        ArrayList<Event> events = new ArrayList<Event>();
        for (IClaim claim : this.items) {
            events.add(new Event(claim, true));
            events.add(new Event(claim, false));
        }
        Collections.sort(events);
        return events;
    }

    private static class Event
    implements Comparable<Event> {
        private final boolean isStart;
        private final Number t;
        private final IClaim parent;

        public Event(IClaim parent, boolean isStart) {
            this.parent = parent;
            this.isStart = isStart;
            this.t = isStart ? (Number)parent.getStartTime() : (Number)parent.getEndTime();
        }

        @Override
        public int compareTo(Event e) {
            int c = Double.compare(this.t.doubleValue(), e.t.doubleValue());
            if (c != 0) {
                return c;
            }
            return Boolean.compare(e.isStart, this.isStart);
        }
    }
}

