/**
 * Copyright (c) 2021, 2024 Contributors to the Eclipse Foundation
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * generated by Xtext 2.36.0
 */
package org.eclipse.trace4cps.tl.etl.impl;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

import org.eclipse.emf.ecore.impl.EPackageImpl;

import org.eclipse.trace4cps.tl.etl.AndOr;
import org.eclipse.trace4cps.tl.etl.AndOrFormula;
import org.eclipse.trace4cps.tl.etl.ApFormula;
import org.eclipse.trace4cps.tl.etl.AttributeFilter;
import org.eclipse.trace4cps.tl.etl.Check;
import org.eclipse.trace4cps.tl.etl.CompOp;
import org.eclipse.trace4cps.tl.etl.ConvSpec;
import org.eclipse.trace4cps.tl.etl.Def;
import org.eclipse.trace4cps.tl.etl.EtlFactory;
import org.eclipse.trace4cps.tl.etl.EtlModel;
import org.eclipse.trace4cps.tl.etl.EtlPackage;
import org.eclipse.trace4cps.tl.etl.FinallyFormula;
import org.eclipse.trace4cps.tl.etl.FinallyUntimedFormula;
import org.eclipse.trace4cps.tl.etl.Formula;
import org.eclipse.trace4cps.tl.etl.GloballyFormula;
import org.eclipse.trace4cps.tl.etl.GloballyUntimedFormula;
import org.eclipse.trace4cps.tl.etl.IdString;
import org.eclipse.trace4cps.tl.etl.IfThenFormula;
import org.eclipse.trace4cps.tl.etl.Interval;
import org.eclipse.trace4cps.tl.etl.IntervalNN;
import org.eclipse.trace4cps.tl.etl.IntervalNS;
import org.eclipse.trace4cps.tl.etl.IntervalSN;
import org.eclipse.trace4cps.tl.etl.IntervalSS;
import org.eclipse.trace4cps.tl.etl.KeyVal;
import org.eclipse.trace4cps.tl.etl.LatencySignal;
import org.eclipse.trace4cps.tl.etl.MtlAp;
import org.eclipse.trace4cps.tl.etl.MtlApEnd;
import org.eclipse.trace4cps.tl.etl.MtlApStart;
import org.eclipse.trace4cps.tl.etl.NotFormula;
import org.eclipse.trace4cps.tl.etl.ReferenceFormula;
import org.eclipse.trace4cps.tl.etl.ResourceAmountSignal;
import org.eclipse.trace4cps.tl.etl.ResourceClientSignal;
import org.eclipse.trace4cps.tl.etl.Signal;
import org.eclipse.trace4cps.tl.etl.SignalDef;
import org.eclipse.trace4cps.tl.etl.StlAp;
import org.eclipse.trace4cps.tl.etl.StlApDeriv;
import org.eclipse.trace4cps.tl.etl.ThroughputSignal;
import org.eclipse.trace4cps.tl.etl.TimeUnitEnum;
import org.eclipse.trace4cps.tl.etl.TopLevelModelElement;
import org.eclipse.trace4cps.tl.etl.TraceSignal;
import org.eclipse.trace4cps.tl.etl.UntilFormula;
import org.eclipse.trace4cps.tl.etl.UntilUntimedFormula;
import org.eclipse.trace4cps.tl.etl.WipSignal;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Package</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class EtlPackageImpl extends EPackageImpl implements EtlPackage
{
  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass etlModelEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass topLevelModelElementEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass signalEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass convSpecEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass formulaEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass stlApEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass mtlApEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass attributeFilterEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass keyValEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass idStringEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass intervalEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass intervalSSEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass intervalSNEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass intervalNSEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass intervalNNEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass signalDefEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass defEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass checkEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass traceSignalEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass throughputSignalEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass latencySignalEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass wipSignalEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass resourceAmountSignalEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass resourceClientSignalEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass referenceFormulaEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass apFormulaEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass notFormulaEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass andOrFormulaEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass ifThenFormulaEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass globallyUntimedFormulaEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass globallyFormulaEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass finallyUntimedFormulaEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass finallyFormulaEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass untilUntimedFormulaEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass untilFormulaEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass stlApDerivEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass mtlApStartEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass mtlApEndEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EEnum timeUnitEnumEEnum = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EEnum andOrEEnum = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EEnum compOpEEnum = null;

  /**
   * Creates an instance of the model <b>Package</b>, registered with
   * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package
   * package URI value.
   * <p>Note: the correct way to create the package is via the static
   * factory method {@link #init init()}, which also performs
   * initialization of the package, or returns the registered package,
   * if one already exists.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.eclipse.emf.ecore.EPackage.Registry
   * @see org.eclipse.trace4cps.tl.etl.EtlPackage#eNS_URI
   * @see #init()
   * @generated
   */
  private EtlPackageImpl()
  {
    super(eNS_URI, EtlFactory.eINSTANCE);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private static boolean isInited = false;

  /**
   * Creates, registers, and initializes the <b>Package</b> for this model, and for any others upon which it depends.
   *
   * <p>This method is used to initialize {@link EtlPackage#eINSTANCE} when that field is accessed.
   * Clients should not invoke it directly. Instead, they should simply access that field to obtain the package.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #eNS_URI
   * @see #createPackageContents()
   * @see #initializePackageContents()
   * @generated
   */
  public static EtlPackage init()
  {
    if (isInited) return (EtlPackage)EPackage.Registry.INSTANCE.getEPackage(EtlPackage.eNS_URI);

    // Obtain or create and register package
    Object registeredEtlPackage = EPackage.Registry.INSTANCE.get(eNS_URI);
    EtlPackageImpl theEtlPackage = registeredEtlPackage instanceof EtlPackageImpl ? (EtlPackageImpl)registeredEtlPackage : new EtlPackageImpl();

    isInited = true;

    // Create package meta-data objects
    theEtlPackage.createPackageContents();

    // Initialize created meta-data
    theEtlPackage.initializePackageContents();

    // Mark meta-data to indicate it can't be changed
    theEtlPackage.freeze();

    // Update the registry and return the package
    EPackage.Registry.INSTANCE.put(EtlPackage.eNS_URI, theEtlPackage);
    return theEtlPackage;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EClass getEtlModel()
  {
    return etlModelEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EReference getEtlModel_Elements()
  {
    return (EReference)etlModelEClass.getEStructuralFeatures().get(0);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EClass getTopLevelModelElement()
  {
    return topLevelModelElementEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EAttribute getTopLevelModelElement_Name()
  {
    return (EAttribute)topLevelModelElementEClass.getEStructuralFeatures().get(0);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EClass getSignal()
  {
    return signalEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EClass getConvSpec()
  {
    return convSpecEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EAttribute getConvSpec_WindowWidth()
  {
    return (EAttribute)convSpecEClass.getEStructuralFeatures().get(0);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EAttribute getConvSpec_WindowUnit()
  {
    return (EAttribute)convSpecEClass.getEStructuralFeatures().get(1);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EClass getFormula()
  {
    return formulaEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EClass getStlAp()
  {
    return stlApEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EReference getStlAp_Ref()
  {
    return (EReference)stlApEClass.getEStructuralFeatures().get(0);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EAttribute getStlAp_CompOp()
  {
    return (EAttribute)stlApEClass.getEStructuralFeatures().get(1);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EAttribute getStlAp_Val()
  {
    return (EAttribute)stlApEClass.getEStructuralFeatures().get(2);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EClass getMtlAp()
  {
    return mtlApEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EReference getMtlAp_Filter()
  {
    return (EReference)mtlApEClass.getEStructuralFeatures().get(0);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EClass getAttributeFilter()
  {
    return attributeFilterEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EReference getAttributeFilter_KeyVals()
  {
    return (EReference)attributeFilterEClass.getEStructuralFeatures().get(0);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EClass getKeyVal()
  {
    return keyValEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EReference getKeyVal_Att()
  {
    return (EReference)keyValEClass.getEStructuralFeatures().get(0);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EReference getKeyVal_Val()
  {
    return (EReference)keyValEClass.getEStructuralFeatures().get(1);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EClass getIdString()
  {
    return idStringEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EAttribute getIdString_Left()
  {
    return (EAttribute)idStringEClass.getEStructuralFeatures().get(0);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EAttribute getIdString_Id()
  {
    return (EAttribute)idStringEClass.getEStructuralFeatures().get(1);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EAttribute getIdString_Right()
  {
    return (EAttribute)idStringEClass.getEStructuralFeatures().get(2);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EClass getInterval()
  {
    return intervalEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EReference getInterval_Iss()
  {
    return (EReference)intervalEClass.getEStructuralFeatures().get(0);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EReference getInterval_Isn()
  {
    return (EReference)intervalEClass.getEStructuralFeatures().get(1);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EReference getInterval_Ins()
  {
    return (EReference)intervalEClass.getEStructuralFeatures().get(2);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EReference getInterval_Inn()
  {
    return (EReference)intervalEClass.getEStructuralFeatures().get(3);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EAttribute getInterval_TimeUnit()
  {
    return (EAttribute)intervalEClass.getEStructuralFeatures().get(4);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EClass getIntervalSS()
  {
    return intervalSSEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EAttribute getIntervalSS_Lb()
  {
    return (EAttribute)intervalSSEClass.getEStructuralFeatures().get(0);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EAttribute getIntervalSS_Ub()
  {
    return (EAttribute)intervalSSEClass.getEStructuralFeatures().get(1);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EAttribute getIntervalSS_Infty()
  {
    return (EAttribute)intervalSSEClass.getEStructuralFeatures().get(2);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EClass getIntervalSN()
  {
    return intervalSNEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EAttribute getIntervalSN_Lb()
  {
    return (EAttribute)intervalSNEClass.getEStructuralFeatures().get(0);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EAttribute getIntervalSN_Ub()
  {
    return (EAttribute)intervalSNEClass.getEStructuralFeatures().get(1);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EClass getIntervalNS()
  {
    return intervalNSEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EAttribute getIntervalNS_Lb()
  {
    return (EAttribute)intervalNSEClass.getEStructuralFeatures().get(0);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EAttribute getIntervalNS_Ub()
  {
    return (EAttribute)intervalNSEClass.getEStructuralFeatures().get(1);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EAttribute getIntervalNS_Infty()
  {
    return (EAttribute)intervalNSEClass.getEStructuralFeatures().get(2);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EClass getIntervalNN()
  {
    return intervalNNEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EAttribute getIntervalNN_Lb()
  {
    return (EAttribute)intervalNNEClass.getEStructuralFeatures().get(0);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EAttribute getIntervalNN_Ub()
  {
    return (EAttribute)intervalNNEClass.getEStructuralFeatures().get(1);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EClass getSignalDef()
  {
    return signalDefEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EReference getSignalDef_Signal()
  {
    return (EReference)signalDefEClass.getEStructuralFeatures().get(0);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EClass getDef()
  {
    return defEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EAttribute getDef_Param()
  {
    return (EAttribute)defEClass.getEStructuralFeatures().get(0);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EReference getDef_Formula()
  {
    return (EReference)defEClass.getEStructuralFeatures().get(1);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EClass getCheck()
  {
    return checkEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EAttribute getCheck_Var()
  {
    return (EAttribute)checkEClass.getEStructuralFeatures().get(0);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EAttribute getCheck_Lb()
  {
    return (EAttribute)checkEClass.getEStructuralFeatures().get(1);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EAttribute getCheck_Ub()
  {
    return (EAttribute)checkEClass.getEStructuralFeatures().get(2);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EReference getCheck_Formula()
  {
    return (EReference)checkEClass.getEStructuralFeatures().get(3);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EClass getTraceSignal()
  {
    return traceSignalEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EReference getTraceSignal_Filter()
  {
    return (EReference)traceSignalEClass.getEStructuralFeatures().get(0);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EClass getThroughputSignal()
  {
    return throughputSignalEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EAttribute getThroughputSignal_IdAtt()
  {
    return (EAttribute)throughputSignalEClass.getEStructuralFeatures().get(0);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EReference getThroughputSignal_Ap()
  {
    return (EReference)throughputSignalEClass.getEStructuralFeatures().get(1);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EAttribute getThroughputSignal_Scale()
  {
    return (EAttribute)throughputSignalEClass.getEStructuralFeatures().get(2);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EReference getThroughputSignal_ConvSpec()
  {
    return (EReference)throughputSignalEClass.getEStructuralFeatures().get(3);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EClass getLatencySignal()
  {
    return latencySignalEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EAttribute getLatencySignal_IdAtt()
  {
    return (EAttribute)latencySignalEClass.getEStructuralFeatures().get(0);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EAttribute getLatencySignal_Scale()
  {
    return (EAttribute)latencySignalEClass.getEStructuralFeatures().get(1);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EReference getLatencySignal_ConvSpec()
  {
    return (EReference)latencySignalEClass.getEStructuralFeatures().get(2);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EClass getWipSignal()
  {
    return wipSignalEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EAttribute getWipSignal_IdAtt()
  {
    return (EAttribute)wipSignalEClass.getEStructuralFeatures().get(0);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EReference getWipSignal_ConvSpec()
  {
    return (EReference)wipSignalEClass.getEStructuralFeatures().get(1);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EClass getResourceAmountSignal()
  {
    return resourceAmountSignalEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EReference getResourceAmountSignal_Filter()
  {
    return (EReference)resourceAmountSignalEClass.getEStructuralFeatures().get(0);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EReference getResourceAmountSignal_ConvSpec()
  {
    return (EReference)resourceAmountSignalEClass.getEStructuralFeatures().get(1);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EClass getResourceClientSignal()
  {
    return resourceClientSignalEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EReference getResourceClientSignal_Filter()
  {
    return (EReference)resourceClientSignalEClass.getEStructuralFeatures().get(0);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EReference getResourceClientSignal_ConvSpec()
  {
    return (EReference)resourceClientSignalEClass.getEStructuralFeatures().get(1);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EClass getReferenceFormula()
  {
    return referenceFormulaEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EReference getReferenceFormula_Def()
  {
    return (EReference)referenceFormulaEClass.getEStructuralFeatures().get(0);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EAttribute getReferenceFormula_Param()
  {
    return (EAttribute)referenceFormulaEClass.getEStructuralFeatures().get(1);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EAttribute getReferenceFormula_Val()
  {
    return (EAttribute)referenceFormulaEClass.getEStructuralFeatures().get(2);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EClass getApFormula()
  {
    return apFormulaEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EReference getApFormula_MtlAP()
  {
    return (EReference)apFormulaEClass.getEStructuralFeatures().get(0);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EReference getApFormula_StlAP()
  {
    return (EReference)apFormulaEClass.getEStructuralFeatures().get(1);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EClass getNotFormula()
  {
    return notFormulaEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EReference getNotFormula_Formula()
  {
    return (EReference)notFormulaEClass.getEStructuralFeatures().get(0);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EClass getAndOrFormula()
  {
    return andOrFormulaEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EReference getAndOrFormula_Left()
  {
    return (EReference)andOrFormulaEClass.getEStructuralFeatures().get(0);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EAttribute getAndOrFormula_Op()
  {
    return (EAttribute)andOrFormulaEClass.getEStructuralFeatures().get(1);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EReference getAndOrFormula_Right()
  {
    return (EReference)andOrFormulaEClass.getEStructuralFeatures().get(2);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EClass getIfThenFormula()
  {
    return ifThenFormulaEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EReference getIfThenFormula_Left()
  {
    return (EReference)ifThenFormulaEClass.getEStructuralFeatures().get(0);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EReference getIfThenFormula_Right()
  {
    return (EReference)ifThenFormulaEClass.getEStructuralFeatures().get(1);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EClass getGloballyUntimedFormula()
  {
    return globallyUntimedFormulaEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EReference getGloballyUntimedFormula_Formula()
  {
    return (EReference)globallyUntimedFormulaEClass.getEStructuralFeatures().get(0);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EClass getGloballyFormula()
  {
    return globallyFormulaEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EReference getGloballyFormula_Interval()
  {
    return (EReference)globallyFormulaEClass.getEStructuralFeatures().get(0);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EReference getGloballyFormula_Formula()
  {
    return (EReference)globallyFormulaEClass.getEStructuralFeatures().get(1);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EClass getFinallyUntimedFormula()
  {
    return finallyUntimedFormulaEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EReference getFinallyUntimedFormula_Formula()
  {
    return (EReference)finallyUntimedFormulaEClass.getEStructuralFeatures().get(0);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EClass getFinallyFormula()
  {
    return finallyFormulaEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EReference getFinallyFormula_Interval()
  {
    return (EReference)finallyFormulaEClass.getEStructuralFeatures().get(0);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EReference getFinallyFormula_Formula()
  {
    return (EReference)finallyFormulaEClass.getEStructuralFeatures().get(1);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EClass getUntilUntimedFormula()
  {
    return untilUntimedFormulaEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EReference getUntilUntimedFormula_Right()
  {
    return (EReference)untilUntimedFormulaEClass.getEStructuralFeatures().get(0);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EReference getUntilUntimedFormula_Left()
  {
    return (EReference)untilUntimedFormulaEClass.getEStructuralFeatures().get(1);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EClass getUntilFormula()
  {
    return untilFormulaEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EReference getUntilFormula_Interval()
  {
    return (EReference)untilFormulaEClass.getEStructuralFeatures().get(0);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EReference getUntilFormula_Right()
  {
    return (EReference)untilFormulaEClass.getEStructuralFeatures().get(1);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EReference getUntilFormula_Left()
  {
    return (EReference)untilFormulaEClass.getEStructuralFeatures().get(2);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EClass getStlApDeriv()
  {
    return stlApDerivEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EClass getMtlApStart()
  {
    return mtlApStartEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EClass getMtlApEnd()
  {
    return mtlApEndEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EEnum getTimeUnitEnum()
  {
    return timeUnitEnumEEnum;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EEnum getAndOr()
  {
    return andOrEEnum;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EEnum getCompOp()
  {
    return compOpEEnum;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EtlFactory getEtlFactory()
  {
    return (EtlFactory)getEFactoryInstance();
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private boolean isCreated = false;

  /**
   * Creates the meta-model objects for the package.  This method is
   * guarded to have no affect on any invocation but its first.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void createPackageContents()
  {
    if (isCreated) return;
    isCreated = true;

    // Create classes and their features
    etlModelEClass = createEClass(ETL_MODEL);
    createEReference(etlModelEClass, ETL_MODEL__ELEMENTS);

    topLevelModelElementEClass = createEClass(TOP_LEVEL_MODEL_ELEMENT);
    createEAttribute(topLevelModelElementEClass, TOP_LEVEL_MODEL_ELEMENT__NAME);

    signalEClass = createEClass(SIGNAL);

    convSpecEClass = createEClass(CONV_SPEC);
    createEAttribute(convSpecEClass, CONV_SPEC__WINDOW_WIDTH);
    createEAttribute(convSpecEClass, CONV_SPEC__WINDOW_UNIT);

    formulaEClass = createEClass(FORMULA);

    stlApEClass = createEClass(STL_AP);
    createEReference(stlApEClass, STL_AP__REF);
    createEAttribute(stlApEClass, STL_AP__COMP_OP);
    createEAttribute(stlApEClass, STL_AP__VAL);

    mtlApEClass = createEClass(MTL_AP);
    createEReference(mtlApEClass, MTL_AP__FILTER);

    attributeFilterEClass = createEClass(ATTRIBUTE_FILTER);
    createEReference(attributeFilterEClass, ATTRIBUTE_FILTER__KEY_VALS);

    keyValEClass = createEClass(KEY_VAL);
    createEReference(keyValEClass, KEY_VAL__ATT);
    createEReference(keyValEClass, KEY_VAL__VAL);

    idStringEClass = createEClass(ID_STRING);
    createEAttribute(idStringEClass, ID_STRING__LEFT);
    createEAttribute(idStringEClass, ID_STRING__ID);
    createEAttribute(idStringEClass, ID_STRING__RIGHT);

    intervalEClass = createEClass(INTERVAL);
    createEReference(intervalEClass, INTERVAL__ISS);
    createEReference(intervalEClass, INTERVAL__ISN);
    createEReference(intervalEClass, INTERVAL__INS);
    createEReference(intervalEClass, INTERVAL__INN);
    createEAttribute(intervalEClass, INTERVAL__TIME_UNIT);

    intervalSSEClass = createEClass(INTERVAL_SS);
    createEAttribute(intervalSSEClass, INTERVAL_SS__LB);
    createEAttribute(intervalSSEClass, INTERVAL_SS__UB);
    createEAttribute(intervalSSEClass, INTERVAL_SS__INFTY);

    intervalSNEClass = createEClass(INTERVAL_SN);
    createEAttribute(intervalSNEClass, INTERVAL_SN__LB);
    createEAttribute(intervalSNEClass, INTERVAL_SN__UB);

    intervalNSEClass = createEClass(INTERVAL_NS);
    createEAttribute(intervalNSEClass, INTERVAL_NS__LB);
    createEAttribute(intervalNSEClass, INTERVAL_NS__UB);
    createEAttribute(intervalNSEClass, INTERVAL_NS__INFTY);

    intervalNNEClass = createEClass(INTERVAL_NN);
    createEAttribute(intervalNNEClass, INTERVAL_NN__LB);
    createEAttribute(intervalNNEClass, INTERVAL_NN__UB);

    signalDefEClass = createEClass(SIGNAL_DEF);
    createEReference(signalDefEClass, SIGNAL_DEF__SIGNAL);

    defEClass = createEClass(DEF);
    createEAttribute(defEClass, DEF__PARAM);
    createEReference(defEClass, DEF__FORMULA);

    checkEClass = createEClass(CHECK);
    createEAttribute(checkEClass, CHECK__VAR);
    createEAttribute(checkEClass, CHECK__LB);
    createEAttribute(checkEClass, CHECK__UB);
    createEReference(checkEClass, CHECK__FORMULA);

    traceSignalEClass = createEClass(TRACE_SIGNAL);
    createEReference(traceSignalEClass, TRACE_SIGNAL__FILTER);

    throughputSignalEClass = createEClass(THROUGHPUT_SIGNAL);
    createEAttribute(throughputSignalEClass, THROUGHPUT_SIGNAL__ID_ATT);
    createEReference(throughputSignalEClass, THROUGHPUT_SIGNAL__AP);
    createEAttribute(throughputSignalEClass, THROUGHPUT_SIGNAL__SCALE);
    createEReference(throughputSignalEClass, THROUGHPUT_SIGNAL__CONV_SPEC);

    latencySignalEClass = createEClass(LATENCY_SIGNAL);
    createEAttribute(latencySignalEClass, LATENCY_SIGNAL__ID_ATT);
    createEAttribute(latencySignalEClass, LATENCY_SIGNAL__SCALE);
    createEReference(latencySignalEClass, LATENCY_SIGNAL__CONV_SPEC);

    wipSignalEClass = createEClass(WIP_SIGNAL);
    createEAttribute(wipSignalEClass, WIP_SIGNAL__ID_ATT);
    createEReference(wipSignalEClass, WIP_SIGNAL__CONV_SPEC);

    resourceAmountSignalEClass = createEClass(RESOURCE_AMOUNT_SIGNAL);
    createEReference(resourceAmountSignalEClass, RESOURCE_AMOUNT_SIGNAL__FILTER);
    createEReference(resourceAmountSignalEClass, RESOURCE_AMOUNT_SIGNAL__CONV_SPEC);

    resourceClientSignalEClass = createEClass(RESOURCE_CLIENT_SIGNAL);
    createEReference(resourceClientSignalEClass, RESOURCE_CLIENT_SIGNAL__FILTER);
    createEReference(resourceClientSignalEClass, RESOURCE_CLIENT_SIGNAL__CONV_SPEC);

    referenceFormulaEClass = createEClass(REFERENCE_FORMULA);
    createEReference(referenceFormulaEClass, REFERENCE_FORMULA__DEF);
    createEAttribute(referenceFormulaEClass, REFERENCE_FORMULA__PARAM);
    createEAttribute(referenceFormulaEClass, REFERENCE_FORMULA__VAL);

    apFormulaEClass = createEClass(AP_FORMULA);
    createEReference(apFormulaEClass, AP_FORMULA__MTL_AP);
    createEReference(apFormulaEClass, AP_FORMULA__STL_AP);

    notFormulaEClass = createEClass(NOT_FORMULA);
    createEReference(notFormulaEClass, NOT_FORMULA__FORMULA);

    andOrFormulaEClass = createEClass(AND_OR_FORMULA);
    createEReference(andOrFormulaEClass, AND_OR_FORMULA__LEFT);
    createEAttribute(andOrFormulaEClass, AND_OR_FORMULA__OP);
    createEReference(andOrFormulaEClass, AND_OR_FORMULA__RIGHT);

    ifThenFormulaEClass = createEClass(IF_THEN_FORMULA);
    createEReference(ifThenFormulaEClass, IF_THEN_FORMULA__LEFT);
    createEReference(ifThenFormulaEClass, IF_THEN_FORMULA__RIGHT);

    globallyUntimedFormulaEClass = createEClass(GLOBALLY_UNTIMED_FORMULA);
    createEReference(globallyUntimedFormulaEClass, GLOBALLY_UNTIMED_FORMULA__FORMULA);

    globallyFormulaEClass = createEClass(GLOBALLY_FORMULA);
    createEReference(globallyFormulaEClass, GLOBALLY_FORMULA__INTERVAL);
    createEReference(globallyFormulaEClass, GLOBALLY_FORMULA__FORMULA);

    finallyUntimedFormulaEClass = createEClass(FINALLY_UNTIMED_FORMULA);
    createEReference(finallyUntimedFormulaEClass, FINALLY_UNTIMED_FORMULA__FORMULA);

    finallyFormulaEClass = createEClass(FINALLY_FORMULA);
    createEReference(finallyFormulaEClass, FINALLY_FORMULA__INTERVAL);
    createEReference(finallyFormulaEClass, FINALLY_FORMULA__FORMULA);

    untilUntimedFormulaEClass = createEClass(UNTIL_UNTIMED_FORMULA);
    createEReference(untilUntimedFormulaEClass, UNTIL_UNTIMED_FORMULA__RIGHT);
    createEReference(untilUntimedFormulaEClass, UNTIL_UNTIMED_FORMULA__LEFT);

    untilFormulaEClass = createEClass(UNTIL_FORMULA);
    createEReference(untilFormulaEClass, UNTIL_FORMULA__INTERVAL);
    createEReference(untilFormulaEClass, UNTIL_FORMULA__RIGHT);
    createEReference(untilFormulaEClass, UNTIL_FORMULA__LEFT);

    stlApDerivEClass = createEClass(STL_AP_DERIV);

    mtlApStartEClass = createEClass(MTL_AP_START);

    mtlApEndEClass = createEClass(MTL_AP_END);

    // Create enums
    timeUnitEnumEEnum = createEEnum(TIME_UNIT_ENUM);
    andOrEEnum = createEEnum(AND_OR);
    compOpEEnum = createEEnum(COMP_OP);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private boolean isInitialized = false;

  /**
   * Complete the initialization of the package and its meta-model.  This
   * method is guarded to have no affect on any invocation but its first.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void initializePackageContents()
  {
    if (isInitialized) return;
    isInitialized = true;

    // Initialize package
    setName(eNAME);
    setNsPrefix(eNS_PREFIX);
    setNsURI(eNS_URI);

    // Create type parameters

    // Set bounds for type parameters

    // Add supertypes to classes
    signalDefEClass.getESuperTypes().add(this.getTopLevelModelElement());
    defEClass.getESuperTypes().add(this.getTopLevelModelElement());
    checkEClass.getESuperTypes().add(this.getTopLevelModelElement());
    traceSignalEClass.getESuperTypes().add(this.getSignal());
    throughputSignalEClass.getESuperTypes().add(this.getSignal());
    latencySignalEClass.getESuperTypes().add(this.getSignal());
    wipSignalEClass.getESuperTypes().add(this.getSignal());
    resourceAmountSignalEClass.getESuperTypes().add(this.getSignal());
    resourceClientSignalEClass.getESuperTypes().add(this.getSignal());
    referenceFormulaEClass.getESuperTypes().add(this.getFormula());
    apFormulaEClass.getESuperTypes().add(this.getFormula());
    notFormulaEClass.getESuperTypes().add(this.getFormula());
    andOrFormulaEClass.getESuperTypes().add(this.getFormula());
    ifThenFormulaEClass.getESuperTypes().add(this.getFormula());
    globallyUntimedFormulaEClass.getESuperTypes().add(this.getFormula());
    globallyFormulaEClass.getESuperTypes().add(this.getFormula());
    finallyUntimedFormulaEClass.getESuperTypes().add(this.getFormula());
    finallyFormulaEClass.getESuperTypes().add(this.getFormula());
    untilUntimedFormulaEClass.getESuperTypes().add(this.getFormula());
    untilFormulaEClass.getESuperTypes().add(this.getFormula());
    stlApDerivEClass.getESuperTypes().add(this.getStlAp());
    mtlApStartEClass.getESuperTypes().add(this.getMtlAp());
    mtlApEndEClass.getESuperTypes().add(this.getMtlAp());

    // Initialize classes and features; add operations and parameters
    initEClass(etlModelEClass, EtlModel.class, "EtlModel", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
    initEReference(getEtlModel_Elements(), this.getTopLevelModelElement(), null, "elements", null, 0, -1, EtlModel.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

    initEClass(topLevelModelElementEClass, TopLevelModelElement.class, "TopLevelModelElement", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
    initEAttribute(getTopLevelModelElement_Name(), ecorePackage.getEString(), "name", null, 0, 1, TopLevelModelElement.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

    initEClass(signalEClass, Signal.class, "Signal", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

    initEClass(convSpecEClass, ConvSpec.class, "ConvSpec", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
    initEAttribute(getConvSpec_WindowWidth(), ecorePackage.getEDouble(), "windowWidth", null, 0, 1, ConvSpec.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
    initEAttribute(getConvSpec_WindowUnit(), this.getTimeUnitEnum(), "windowUnit", null, 0, 1, ConvSpec.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

    initEClass(formulaEClass, Formula.class, "Formula", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

    initEClass(stlApEClass, StlAp.class, "StlAp", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
    initEReference(getStlAp_Ref(), this.getSignalDef(), null, "ref", null, 0, 1, StlAp.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
    initEAttribute(getStlAp_CompOp(), this.getCompOp(), "compOp", null, 0, 1, StlAp.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
    initEAttribute(getStlAp_Val(), ecorePackage.getEDouble(), "val", null, 0, 1, StlAp.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

    initEClass(mtlApEClass, MtlAp.class, "MtlAp", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
    initEReference(getMtlAp_Filter(), this.getAttributeFilter(), null, "filter", null, 0, 1, MtlAp.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

    initEClass(attributeFilterEClass, AttributeFilter.class, "AttributeFilter", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
    initEReference(getAttributeFilter_KeyVals(), this.getKeyVal(), null, "keyVals", null, 0, -1, AttributeFilter.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

    initEClass(keyValEClass, KeyVal.class, "KeyVal", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
    initEReference(getKeyVal_Att(), this.getIdString(), null, "att", null, 0, 1, KeyVal.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
    initEReference(getKeyVal_Val(), this.getIdString(), null, "val", null, 0, 1, KeyVal.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

    initEClass(idStringEClass, IdString.class, "IdString", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
    initEAttribute(getIdString_Left(), ecorePackage.getEString(), "left", null, 0, 1, IdString.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
    initEAttribute(getIdString_Id(), ecorePackage.getEString(), "id", null, 0, 1, IdString.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
    initEAttribute(getIdString_Right(), ecorePackage.getEString(), "right", null, 0, 1, IdString.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

    initEClass(intervalEClass, Interval.class, "Interval", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
    initEReference(getInterval_Iss(), this.getIntervalSS(), null, "iss", null, 0, 1, Interval.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
    initEReference(getInterval_Isn(), this.getIntervalSN(), null, "isn", null, 0, 1, Interval.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
    initEReference(getInterval_Ins(), this.getIntervalNS(), null, "ins", null, 0, 1, Interval.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
    initEReference(getInterval_Inn(), this.getIntervalNN(), null, "inn", null, 0, 1, Interval.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
    initEAttribute(getInterval_TimeUnit(), this.getTimeUnitEnum(), "timeUnit", null, 0, 1, Interval.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

    initEClass(intervalSSEClass, IntervalSS.class, "IntervalSS", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
    initEAttribute(getIntervalSS_Lb(), ecorePackage.getEDouble(), "lb", null, 0, 1, IntervalSS.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
    initEAttribute(getIntervalSS_Ub(), ecorePackage.getEDouble(), "ub", null, 0, 1, IntervalSS.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
    initEAttribute(getIntervalSS_Infty(), ecorePackage.getEString(), "infty", null, 0, 1, IntervalSS.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

    initEClass(intervalSNEClass, IntervalSN.class, "IntervalSN", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
    initEAttribute(getIntervalSN_Lb(), ecorePackage.getEDouble(), "lb", null, 0, 1, IntervalSN.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
    initEAttribute(getIntervalSN_Ub(), ecorePackage.getEDouble(), "ub", null, 0, 1, IntervalSN.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

    initEClass(intervalNSEClass, IntervalNS.class, "IntervalNS", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
    initEAttribute(getIntervalNS_Lb(), ecorePackage.getEDouble(), "lb", null, 0, 1, IntervalNS.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
    initEAttribute(getIntervalNS_Ub(), ecorePackage.getEDouble(), "ub", null, 0, 1, IntervalNS.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
    initEAttribute(getIntervalNS_Infty(), ecorePackage.getEString(), "infty", null, 0, 1, IntervalNS.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

    initEClass(intervalNNEClass, IntervalNN.class, "IntervalNN", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
    initEAttribute(getIntervalNN_Lb(), ecorePackage.getEDouble(), "lb", null, 0, 1, IntervalNN.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
    initEAttribute(getIntervalNN_Ub(), ecorePackage.getEDouble(), "ub", null, 0, 1, IntervalNN.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

    initEClass(signalDefEClass, SignalDef.class, "SignalDef", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
    initEReference(getSignalDef_Signal(), this.getSignal(), null, "signal", null, 0, 1, SignalDef.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

    initEClass(defEClass, Def.class, "Def", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
    initEAttribute(getDef_Param(), ecorePackage.getEString(), "param", null, 0, 1, Def.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
    initEReference(getDef_Formula(), this.getFormula(), null, "formula", null, 0, 1, Def.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

    initEClass(checkEClass, Check.class, "Check", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
    initEAttribute(getCheck_Var(), ecorePackage.getEString(), "var", null, 0, 1, Check.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
    initEAttribute(getCheck_Lb(), ecorePackage.getEInt(), "lb", null, 0, 1, Check.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
    initEAttribute(getCheck_Ub(), ecorePackage.getEInt(), "ub", null, 0, 1, Check.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
    initEReference(getCheck_Formula(), this.getFormula(), null, "formula", null, 0, 1, Check.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

    initEClass(traceSignalEClass, TraceSignal.class, "TraceSignal", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
    initEReference(getTraceSignal_Filter(), this.getAttributeFilter(), null, "filter", null, 0, 1, TraceSignal.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

    initEClass(throughputSignalEClass, ThroughputSignal.class, "ThroughputSignal", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
    initEAttribute(getThroughputSignal_IdAtt(), ecorePackage.getEString(), "idAtt", null, 0, 1, ThroughputSignal.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
    initEReference(getThroughputSignal_Ap(), this.getMtlAp(), null, "ap", null, 0, 1, ThroughputSignal.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
    initEAttribute(getThroughputSignal_Scale(), this.getTimeUnitEnum(), "scale", null, 0, 1, ThroughputSignal.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
    initEReference(getThroughputSignal_ConvSpec(), this.getConvSpec(), null, "convSpec", null, 0, 1, ThroughputSignal.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

    initEClass(latencySignalEClass, LatencySignal.class, "LatencySignal", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
    initEAttribute(getLatencySignal_IdAtt(), ecorePackage.getEString(), "idAtt", null, 0, 1, LatencySignal.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
    initEAttribute(getLatencySignal_Scale(), this.getTimeUnitEnum(), "scale", null, 0, 1, LatencySignal.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
    initEReference(getLatencySignal_ConvSpec(), this.getConvSpec(), null, "convSpec", null, 0, 1, LatencySignal.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

    initEClass(wipSignalEClass, WipSignal.class, "WipSignal", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
    initEAttribute(getWipSignal_IdAtt(), ecorePackage.getEString(), "idAtt", null, 0, 1, WipSignal.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
    initEReference(getWipSignal_ConvSpec(), this.getConvSpec(), null, "convSpec", null, 0, 1, WipSignal.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

    initEClass(resourceAmountSignalEClass, ResourceAmountSignal.class, "ResourceAmountSignal", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
    initEReference(getResourceAmountSignal_Filter(), this.getAttributeFilter(), null, "filter", null, 0, 1, ResourceAmountSignal.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
    initEReference(getResourceAmountSignal_ConvSpec(), this.getConvSpec(), null, "convSpec", null, 0, 1, ResourceAmountSignal.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

    initEClass(resourceClientSignalEClass, ResourceClientSignal.class, "ResourceClientSignal", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
    initEReference(getResourceClientSignal_Filter(), this.getAttributeFilter(), null, "filter", null, 0, 1, ResourceClientSignal.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
    initEReference(getResourceClientSignal_ConvSpec(), this.getConvSpec(), null, "convSpec", null, 0, 1, ResourceClientSignal.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

    initEClass(referenceFormulaEClass, ReferenceFormula.class, "ReferenceFormula", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
    initEReference(getReferenceFormula_Def(), this.getDef(), null, "def", null, 0, 1, ReferenceFormula.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
    initEAttribute(getReferenceFormula_Param(), ecorePackage.getEString(), "param", null, 0, 1, ReferenceFormula.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
    initEAttribute(getReferenceFormula_Val(), ecorePackage.getEInt(), "val", null, 0, 1, ReferenceFormula.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

    initEClass(apFormulaEClass, ApFormula.class, "ApFormula", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
    initEReference(getApFormula_MtlAP(), this.getMtlAp(), null, "mtlAP", null, 0, 1, ApFormula.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
    initEReference(getApFormula_StlAP(), this.getStlAp(), null, "stlAP", null, 0, 1, ApFormula.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

    initEClass(notFormulaEClass, NotFormula.class, "NotFormula", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
    initEReference(getNotFormula_Formula(), this.getFormula(), null, "formula", null, 0, 1, NotFormula.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

    initEClass(andOrFormulaEClass, AndOrFormula.class, "AndOrFormula", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
    initEReference(getAndOrFormula_Left(), this.getFormula(), null, "left", null, 0, 1, AndOrFormula.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
    initEAttribute(getAndOrFormula_Op(), this.getAndOr(), "op", null, 0, 1, AndOrFormula.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
    initEReference(getAndOrFormula_Right(), this.getFormula(), null, "right", null, 0, 1, AndOrFormula.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

    initEClass(ifThenFormulaEClass, IfThenFormula.class, "IfThenFormula", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
    initEReference(getIfThenFormula_Left(), this.getFormula(), null, "left", null, 0, 1, IfThenFormula.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
    initEReference(getIfThenFormula_Right(), this.getFormula(), null, "right", null, 0, 1, IfThenFormula.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

    initEClass(globallyUntimedFormulaEClass, GloballyUntimedFormula.class, "GloballyUntimedFormula", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
    initEReference(getGloballyUntimedFormula_Formula(), this.getFormula(), null, "formula", null, 0, 1, GloballyUntimedFormula.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

    initEClass(globallyFormulaEClass, GloballyFormula.class, "GloballyFormula", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
    initEReference(getGloballyFormula_Interval(), this.getInterval(), null, "interval", null, 0, 1, GloballyFormula.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
    initEReference(getGloballyFormula_Formula(), this.getFormula(), null, "formula", null, 0, 1, GloballyFormula.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

    initEClass(finallyUntimedFormulaEClass, FinallyUntimedFormula.class, "FinallyUntimedFormula", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
    initEReference(getFinallyUntimedFormula_Formula(), this.getFormula(), null, "formula", null, 0, 1, FinallyUntimedFormula.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

    initEClass(finallyFormulaEClass, FinallyFormula.class, "FinallyFormula", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
    initEReference(getFinallyFormula_Interval(), this.getInterval(), null, "interval", null, 0, 1, FinallyFormula.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
    initEReference(getFinallyFormula_Formula(), this.getFormula(), null, "formula", null, 0, 1, FinallyFormula.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

    initEClass(untilUntimedFormulaEClass, UntilUntimedFormula.class, "UntilUntimedFormula", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
    initEReference(getUntilUntimedFormula_Right(), this.getFormula(), null, "right", null, 0, 1, UntilUntimedFormula.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
    initEReference(getUntilUntimedFormula_Left(), this.getFormula(), null, "left", null, 0, 1, UntilUntimedFormula.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

    initEClass(untilFormulaEClass, UntilFormula.class, "UntilFormula", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
    initEReference(getUntilFormula_Interval(), this.getInterval(), null, "interval", null, 0, 1, UntilFormula.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
    initEReference(getUntilFormula_Right(), this.getFormula(), null, "right", null, 0, 1, UntilFormula.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
    initEReference(getUntilFormula_Left(), this.getFormula(), null, "left", null, 0, 1, UntilFormula.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

    initEClass(stlApDerivEClass, StlApDeriv.class, "StlApDeriv", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

    initEClass(mtlApStartEClass, MtlApStart.class, "MtlApStart", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

    initEClass(mtlApEndEClass, MtlApEnd.class, "MtlApEnd", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

    // Initialize enums and add enum literals
    initEEnum(timeUnitEnumEEnum, TimeUnitEnum.class, "TimeUnitEnum");
    addEEnumLiteral(timeUnitEnumEEnum, TimeUnitEnum.S);
    addEEnumLiteral(timeUnitEnumEEnum, TimeUnitEnum.NS);
    addEEnumLiteral(timeUnitEnumEEnum, TimeUnitEnum.US);
    addEEnumLiteral(timeUnitEnumEEnum, TimeUnitEnum.MS);
    addEEnumLiteral(timeUnitEnumEEnum, TimeUnitEnum.MIN);
    addEEnumLiteral(timeUnitEnumEEnum, TimeUnitEnum.HR);

    initEEnum(andOrEEnum, AndOr.class, "AndOr");
    addEEnumLiteral(andOrEEnum, AndOr.AND);
    addEEnumLiteral(andOrEEnum, AndOr.OR);

    initEEnum(compOpEEnum, CompOp.class, "CompOp");
    addEEnumLiteral(compOpEEnum, CompOp.LE);
    addEEnumLiteral(compOpEEnum, CompOp.EQ);
    addEEnumLiteral(compOpEEnum, CompOp.GE);

    // Create resource
    createResource(eNS_URI);
  }

} //EtlPackageImpl
