/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.tl;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.trace4cps.analysis.mtl.MtlFormula;
import org.eclipse.trace4cps.analysis.mtl.MtlResult;

public final class VerificationResult {
    private final Map<MtlFormula, String> formula2name = new HashMap<MtlFormula, String>();
    private final Map<MtlFormula, MtlResult> formula2result = new HashMap<MtlFormula, MtlResult>();
    private final Map<MtlFormula, Integer> formula2QuantValue = new HashMap<MtlFormula, Integer>();
    private final Set<MtlFormula> checks = new HashSet<MtlFormula>();

    void add(String name, MtlFormula phi, boolean isCheck) {
        if (this.formula2name.containsKey(phi)) {
            throw new IllegalStateException();
        }
        this.formula2name.put(phi, name);
        if (isCheck) {
            this.checks.add(phi);
        }
    }

    void add(String name, MtlFormula phi, Integer quantValue) {
        if (this.formula2name.containsKey(phi)) {
            throw new IllegalStateException();
        }
        this.formula2name.put(phi, name);
        this.checks.add(phi);
        this.formula2QuantValue.put(phi, quantValue);
    }

    void setResult(MtlResult r) {
        MtlFormula phi = r.getPhi();
        if (this.formula2result.containsKey(phi) || !this.checks.contains(phi)) {
            throw new IllegalStateException();
        }
        this.formula2result.put(phi, r);
    }

    public Collection<MtlFormula> getChecks() {
        return this.checks;
    }

    public String getName(MtlFormula phi) {
        return this.formula2name.get(phi);
    }

    public MtlResult getResult(MtlFormula phi) {
        return this.formula2result.get(phi);
    }

    public MtlResult getResult(String name) {
        for (Map.Entry<MtlFormula, String> e : this.formula2name.entrySet()) {
            if (!name.equals(e.getValue())) continue;
            MtlFormula phi = e.getKey();
            if (this.isQuantifiedCheck(phi)) {
                throw new IllegalStateException();
            }
            return this.getResult(e.getKey());
        }
        return null;
    }

    public MtlResult getResult(String name, int i) {
        for (Map.Entry<MtlFormula, String> e : this.formula2name.entrySet()) {
            if (!name.equals(e.getValue())) continue;
            MtlFormula phi = e.getKey();
            if (!this.isQuantifiedCheck(phi)) {
                throw new IllegalStateException();
            }
            if (this.getQuantifierValue(phi) != i) continue;
            return this.getResult(e.getKey());
        }
        return null;
    }

    public Integer getQuantifierValue(MtlFormula phi) {
        return this.formula2QuantValue.get(phi);
    }

    public boolean isCheck(MtlFormula phi) {
        return this.formula2result.keySet().contains(phi);
    }

    public boolean isQuantifiedCheck(MtlFormula phi) {
        return this.formula2QuantValue.keySet().contains(phi);
    }

    public boolean contains(MtlFormula phi) {
        return this.formula2name.keySet().contains(phi);
    }
}

