/**
 * Copyright (c) 2021, 2024 Contributors to the Eclipse Foundation
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.trace4cps.tl.formatting2;

import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.trace4cps.tl.etl.EtlModel;
import org.eclipse.trace4cps.tl.etl.TopLevelModelElement;
import org.eclipse.xtext.formatting2.AbstractFormatter2;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.IHiddenRegionFormatter;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

@SuppressWarnings("all")
public class EtlFormatter extends AbstractFormatter2 {
  protected void _format(final EtlModel etlModel, @Extension final IFormattableDocument document) {
    EList<TopLevelModelElement> _elements = etlModel.getElements();
    for (final TopLevelModelElement _signal : _elements) {
      {
        document.<TopLevelModelElement>format(_signal);
        final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
          it.setNewLines(2);
        };
        document.<TopLevelModelElement>append(_signal, _function);
      }
    }
  }
  
  public void format(final Object etlModel, final IFormattableDocument document) {
    if (etlModel instanceof XtextResource) {
      _format((XtextResource)etlModel, document);
      return;
    } else if (etlModel instanceof EtlModel) {
      _format((EtlModel)etlModel, document);
      return;
    } else if (etlModel instanceof EObject) {
      _format((EObject)etlModel, document);
      return;
    } else if (etlModel == null) {
      _format((Void)null, document);
      return;
    } else if (etlModel != null) {
      _format(etlModel, document);
      return;
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(etlModel, document).toString());
    }
  }
}
