/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.ui.view.action;

import com.google.inject.Injector;
import com.google.inject.Provider;
import java.io.File;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.trace4cps.core.IAttributeAware;
import org.eclipse.trace4cps.core.IInterval;
import org.eclipse.trace4cps.core.ITrace;
import org.eclipse.trace4cps.core.TraceException;
import org.eclipse.trace4cps.core.impl.TraceHelper;
import org.eclipse.trace4cps.tl.VerificationHelper;
import org.eclipse.trace4cps.tl.VerificationResult;
import org.eclipse.trace4cps.tl.etl.EtlModel;
import org.eclipse.trace4cps.tl.ui.Util;
import org.eclipse.trace4cps.tl.ui.internal.TlActivator;
import org.eclipse.trace4cps.ui.ConsoleUtil;
import org.eclipse.trace4cps.ui.view.TraceView;
import org.eclipse.trace4cps.ui.view.action.AbstractTraceViewAction;
import org.eclipse.trace4cps.ui.view.verify.VerificationResultView;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;

public class VerifyAction
extends AbstractTraceViewAction {
    public static final String SPEC_FILE_EXTENSION = ".etl";

    public VerifyAction(TraceView view) {
        super(view, "/icons/passed.png");
        this.setToolTipText("Verify");
    }

    public boolean isEnabled() {
        return this.view.getNumTraces() == 1;
    }

    @Override
    protected void doRun() throws TraceException {
        String specFile = Util.browseForFileInWorkspace((Shell)this.view.getEditorSite().getShell(), (String[])new String[]{SPEC_FILE_EXTENSION});
        if (specFile != null) {
            VerificationResult vr;
            ITrace trace = this.view.getTrace();
            Resource resource = this.getValidatedResource(specFile);
            if (resource == null) {
                return;
            }
            EtlModel model = (EtlModel)resource.getContents().get(0);
            VerificationHelper vh = new VerificationHelper(trace, model);
            try {
                vr = vh.run();
                ConsoleUtil.log("Checking " + new File(specFile).getName() + " on " + this.view.getTraceFile(0).getName());
                IInterval dom = vh.getTimeDomainForVerification();
                ConsoleUtil.log(" - Domain for verification: " + dom + " " + (Object)((Object)trace.getTimeUnit()));
                if (vh.statesInjected()) {
                    int injected = vh.getNumInjectedStates();
                    double domWidth = dom.ub().doubleValue() - dom.lb().doubleValue();
                    double stepSize = domWidth / (double)injected;
                    ConsoleUtil.log(" - Injecting 10.000 events: time between events <= " + stepSize + " " + (Object)((Object)trace.getTimeUnit()) + " " + this.getStepFreq(stepSize));
                }
            }
            catch (InterruptedException | ExecutionException e) {
                throw new TraceException("Failed to run verification", (Throwable)e);
            }
            VerificationResultView.showView(specFile, TraceHelper.getValues((IAttributeAware)trace, (boolean)false), vr, this.view);
        }
    }

    private String getStepFreq(double stepSize) {
        switch (this.view.getTrace().getTimeUnit()) {
            case SECONDS: {
                return " (" + 1.0 / stepSize + " Hz)";
            }
            case MILLISECONDS: {
                return " (" + 1.0 / stepSize + " kHz)";
            }
            case MICROSECONDS: {
                return " (" + 1.0 / stepSize + " MHz)";
            }
        }
        return "";
    }

    private Resource getValidatedResource(String filename) throws TraceException {
        Injector injector = TlActivator.getInstance().getInjector("org.eclipse.trace4cps.tl.Etl");
        Provider resourceSetProvider = injector.getProvider(ResourceSet.class);
        ResourceSet resourceSet = (ResourceSet)resourceSetProvider.get();
        Resource resource = resourceSet.getResource(URI.createFileURI((String)filename), true);
        IResourceValidator validator = ((XtextResource)resource).getResourceServiceProvider().getResourceValidator();
        List issues = validator.validate(resource, CheckMode.ALL, CancelIndicator.NullImpl);
        for (Issue issue : issues) {
            if (issue.getSeverity() != Severity.ERROR) continue;
            throw new TraceException("Issue in specification: " + issue.getMessage() + " at line " + issue.getLineNumber());
        }
        return resource;
    }
}

