/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.internal.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.LinkedHashSet;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.IDocument;
import org.eclipse.tm4e.ui.internal.model.DocumentInputStream;
import org.eclipse.tm4e.ui.internal.utils.ClassHelper;
import org.eclipse.tm4e.ui.internal.utils.ContentTypeInfo;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IStorageEditorInput;

public final class ContentTypeHelper {
    public static @Nullable ContentTypeInfo findContentTypes(IDocument document) throws CoreException {
        ContentTypeInfo contentTypes = ContentTypeHelper.findContentTypesFromFileBuffers(document);
        if (contentTypes != null) {
            return contentTypes;
        }
        return ContentTypeHelper.findContentTypesFromEditorInput(document);
    }

    public static @Nullable IContentType getContentTypeById(String contentTypeId) {
        IContentTypeManager manager = Platform.getContentTypeManager();
        return manager.getContentType(contentTypeId);
    }

    private static @Nullable ContentTypeInfo findContentTypesFromFileBuffers(IDocument document) throws CoreException {
        ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
        ITextFileBuffer buffer = bufferManager.getTextFileBuffer(document);
        if (buffer != null) {
            return ContentTypeHelper.getContentTypes(buffer);
        }
        return null;
    }

    private static @Nullable ContentTypeInfo getContentTypes(ITextFileBuffer buffer) throws CoreException {
        try {
            Object var5_9;
            Throwable throwable;
            String fileName = buffer.getFileStore().getName();
            LinkedHashSet<IContentType> contentTypes = new LinkedHashSet<IContentType>();
            IContentType bufferContentType = buffer.getContentType();
            if (bufferContentType != null) {
                contentTypes.add(bufferContentType);
            }
            if (buffer.isDirty()) {
                throwable = null;
                var5_9 = null;
                try (DocumentInputStream input = new DocumentInputStream(buffer.getDocument());){
                    IContentType[] contentTypesForInput = Platform.getContentTypeManager().findContentTypesFor((InputStream)input, fileName);
                    if (contentTypesForInput != null) {
                        contentTypes.addAll(Arrays.asList(contentTypesForInput));
                        return new ContentTypeInfo(fileName, (IContentType[])contentTypes.toArray(IContentType[]::new));
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            try {
                throwable = null;
                var5_9 = null;
                try (InputStream contents = ContentTypeHelper.getContents(buffer);){
                    contentTypes.addAll(Arrays.asList(Platform.getContentTypeManager().findContentTypesFor(contents, fileName)));
                    return new ContentTypeInfo(fileName, (IContentType[])contentTypes.toArray(IContentType[]::new));
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                return null;
            }
        }
        catch (IOException x) {
            x.printStackTrace();
            return null;
        }
    }

    private static InputStream getContents(ITextFileBuffer buffer) throws CoreException {
        IWorkspaceRoot workspaceRoot;
        IFile file;
        IPath path = buffer.getLocation();
        if (path != null && (file = (workspaceRoot = ResourcesPlugin.getWorkspace().getRoot()).getFile(path)).exists() && buffer.isSynchronized()) {
            return file.getContents();
        }
        return buffer.getFileStore().openInputStream(0, null);
    }

    private static @Nullable ContentTypeInfo findContentTypesFromEditorInput(IDocument document) {
        IEditorInput editorInput = ContentTypeHelper.getEditorInput(document);
        if (editorInput != null && editorInput instanceof IStorageEditorInput) {
            try {
                IStorage storage = ((IStorageEditorInput)editorInput).getStorage();
                String fileName = storage.getName();
                Throwable throwable = null;
                Object var5_7 = null;
                try (InputStream input = storage.getContents();){
                    return new ContentTypeInfo(fileName, Platform.getContentTypeManager().findContentTypesFor(input, fileName));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    private static @Nullable IEditorInput getEditorInput(IDocument document) {
        block6: {
            try {
                ListenerList listeners = (ListenerList)ClassHelper.getFieldValue(document, "fDocumentListeners");
                if (listeners == null) break block6;
                Object[] l = listeners.getListeners();
                int i = 0;
                while (i < l.length) {
                    Object info = l[i];
                    try {
                        Object input = ClassHelper.getFieldValue(info, "fElement");
                        if (input instanceof IEditorInput) {
                            return (IEditorInput)input;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

