/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.useractions.ui.uda;

import java.util.ResourceBundle;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.internal.useractions.ui.uda.ISystemUDAEditPaneHoster;
import org.eclipse.rse.internal.useractions.ui.uda.ISystemUDWorkWithDialog;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDAResources;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDActionSubsystem;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDTypeEditPane;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDTypeElement;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDTypeManager;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDTypeTreeView;
import org.eclipse.rse.internal.useractions.ui.uda.SystemXMLElementWrapper;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.dialogs.SystemPromptDialog;
import org.eclipse.rse.ui.widgets.SystemEditPaneStateMachine;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class SystemWorkWithUDTypeDialog
extends SystemPromptDialog
implements ISystemUDWorkWithDialog,
Listener,
Runnable,
ISystemUDAEditPaneHoster {
    protected Shell shell;
    protected ResourceBundle rb;
    protected SystemUDActionSubsystem udaActionSubsystem;
    protected ISubSystem subsystem;
    protected ISubSystemConfiguration subsystemFactory;
    protected ISystemProfile profile;
    protected SystemUDTypeEditPane editpane;
    protected Button applyButton;
    protected Button revertButton;
    protected SystemEditPaneStateMachine sm;
    protected SystemUDTypeTreeView treeView;
    private String typeToPreSelect;
    private String currentType;
    private int preSelectTypeDomain;
    private int currentDomain = -1;
    private Object objectToPreSelect;
    private String domainToPreExpand;

    public SystemWorkWithUDTypeDialog(Shell shell, ISubSystem ss, SystemUDActionSubsystem udaActionSubsystem) {
        super(shell, SystemUDAResources.RESID_WORKWITH_UDT_TITLE);
        this.setCancelButtonLabel(SystemUDAResources.BUTTON_CLOSE);
        this.setShowOkButton(false);
        this.shell = shell;
        this.udaActionSubsystem = udaActionSubsystem;
        this.subsystem = ss;
        this.subsystemFactory = this.subsystem.getSubSystemConfiguration();
        this.profile = this.subsystem.getSystemProfile();
        this.setOutputObject(null);
        this.setHelp();
    }

    public SystemWorkWithUDTypeDialog(Shell shell, ISubSystemConfiguration ssFactory, ISystemProfile profile) {
        super(shell, SystemUDAResources.RESID_WORKWITH_UDT_TITLE);
        this.setCancelButtonLabel(SystemUDAResources.BUTTON_CLOSE);
        this.setShowOkButton(false);
        this.shell = shell;
        this.subsystemFactory = ssFactory;
        this.profile = profile;
        this.setOutputObject(null);
        this.setHelp();
    }

    protected void setHelp() {
        this.setHelp("org.eclipse.rse.ui.wwnt0000");
    }

    public void preSelectType(int domain, String type) {
        this.preSelectTypeDomain = domain;
        this.typeToPreSelect = type;
    }

    protected Control getInitialFocusControl() {
        return this.treeView.getControl();
    }

    protected Control createInner(Composite parent) {
        int nbrColumns = 2;
        Composite composite = SystemWidgetHelpers.createComposite((Composite)parent, (int)nbrColumns);
        this.treeView = this.subsystem != null ? new SystemUDTypeTreeView(composite, (ISystemUDWorkWithDialog)this, this.subsystem, this.udaActionSubsystem) : new SystemUDTypeTreeView(composite, (ISystemUDWorkWithDialog)this, this.subsystemFactory, this.profile);
        Control c = this.treeView.getControl();
        GridData data = (GridData)c.getLayoutData();
        if (data == null) {
            data = new GridData();
        }
        data.grabExcessHorizontalSpace = false;
        data.horizontalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        data.verticalAlignment = 4;
        data.widthHint = 140;
        data.heightHint = this.publicConvertHeightInCharsToPixels(12);
        c.setLayoutData((Object)data);
        Composite rightSideComposite = SystemWidgetHelpers.createFlushComposite((Composite)composite, (int)1);
        this.editpane = this.getUDActionSubsystem().getCustomUDTypeEditPane(this, this.treeView);
        this.editpane.createContents(rightSideComposite);
        this.addSeparatorLine(rightSideComposite, 1);
        int nbrColumns_buttonComposite = 4;
        Composite applyResetButtonComposite = SystemWidgetHelpers.createFlushComposite((Composite)rightSideComposite, (int)nbrColumns_buttonComposite);
        Label filler = SystemWidgetHelpers.createLabel((Composite)applyResetButtonComposite, (String)"");
        ((GridData)filler.getLayoutData()).grabExcessHorizontalSpace = true;
        ((GridData)filler.getLayoutData()).horizontalAlignment = 4;
        this.applyButton = SystemWidgetHelpers.createPushButton((Composite)applyResetButtonComposite, (Listener)this, (String)SystemUDAResources.RESID_UDA_APPLY_BUTTON_LABEL, (String)SystemUDAResources.RESID_UDA_APPLY_BUTTON_TOOLTIP);
        this.revertButton = SystemWidgetHelpers.createPushButton((Composite)applyResetButtonComposite, (Listener)this, (String)SystemUDAResources.RESID_UDA_REVERT_BUTTON_LABEL, (String)SystemUDAResources.RESID_UDA_REVERT_BUTTON_TOOLTIP);
        this.addGrowableFillerLine(rightSideComposite, 1);
        this.sm = new SystemEditPaneStateMachine(rightSideComposite, this.applyButton, this.revertButton);
        this.editpane.setStateMachine(this.sm);
        composite.layout(true);
        rightSideComposite.setVisible(false);
        if (this.typeToPreSelect != null) {
            SystemUDTypeManager udtm = this.getUDActionSubsystem().getUDTypeManager();
            SystemUDTypeElement type = null;
            if (this.preSelectTypeDomain >= 0) {
                this.domainToPreExpand = this.getUDActionSubsystem().mapDomainXlatedName(this.preSelectTypeDomain);
            }
            this.treeView.addSelectionChangedListener(this.editpane);
            if (this.subsystem != null) {
                type = (SystemUDTypeElement)udtm.findByName(this.subsystem.getSystemProfile(), this.typeToPreSelect, this.preSelectTypeDomain);
            }
            if (type != null) {
                this.objectToPreSelect = type;
            }
        } else {
            this.treeView.addSelectionChangedListener(this.editpane);
        }
        this.treeView.getShell().getDisplay().asyncExec((Runnable)this);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getShell().setDefaultButton(this.applyButton);
    }

    protected SystemUDActionSubsystem getUDActionSubsystem() {
        return this.udaActionSubsystem;
    }

    protected boolean processCancel() {
        if (this.sm.isSaveRequired()) {
            if (!this.editpane.validateInput(true, null)) {
                this.sm.setChangesMade();
                return false;
            }
            this.editpane.saveData();
        }
        this.currentType = this.treeView.getSelectedTypeName();
        if (this.currentType.length() > 0) {
            this.setOutputObject(this.currentType);
        }
        this.currentDomain = this.treeView.getSelectedTypeDomain();
        return super.processCancel();
    }

    public String getSelectedTypeName() {
        return this.currentType;
    }

    public int getSelectedTypeDomain() {
        return this.currentDomain;
    }

    public void setPageComplete(boolean complete) {
        if (this.applyButton != null && !complete) {
            this.applyButton.setEnabled(false);
        }
    }

    protected boolean isAllTypeSelected() {
        return this.treeView.getSelectedTypeName().equals("ALL");
    }

    protected boolean isSelectionVendorSupplied() {
        return this.treeView.isSelectionVendorSupplied();
    }

    protected String getVendorOfSelection() {
        return this.treeView.getVendorOfSelection();
    }

    public void handleEvent(Event e) {
        this.clearMessage();
        Widget source = e.widget;
        if (source == this.applyButton) {
            this.processApply();
        } else if (source == this.revertButton) {
            this.processRevert();
        }
    }

    public void processApply() {
        this.editpane.applyPressed();
    }

    public void processRevert() {
        this.editpane.revertPressed();
    }

    public int publicConvertWidthInCharsToPixels(int chars) {
        return this.convertWidthInCharsToPixels(chars);
    }

    public int publicConvertHeightInCharsToPixels(int chars) {
        return this.convertHeightInCharsToPixels(chars);
    }

    public boolean canDelete(Object selectedObject) {
        return this.sm.getMode() == 8 && !this.sm.areChangesPending() && !this.isSelectionVendorSupplied();
    }

    public boolean canMoveUp(Object selectedObject) {
        boolean can;
        boolean bl = can = this.sm.getMode() == 8 && !this.sm.areChangesPending() && !this.isAllTypeSelected();
        if (can) {
            TreeItem selectedItem = this.treeView.getSelectedTreeItem();
            TreeItem parentItem = selectedItem.getParentItem();
            if (parentItem != null) {
                can = parentItem.getItems()[0] != selectedItem;
            } else {
                TreeItem[] roots = this.treeView.getTree().getItems();
                int idx = 0;
                while (idx < roots.length) {
                    if (roots[idx].getData() instanceof SystemXMLElementWrapper) {
                        can = roots[idx] != selectedItem;
                        break;
                    }
                    ++idx;
                }
            }
        }
        return can;
    }

    public boolean canMoveDown(Object selectedObject) {
        boolean can;
        boolean bl = can = this.sm.getMode() == 8 && !this.sm.areChangesPending() && !this.isAllTypeSelected();
        if (can) {
            TreeItem[] roots;
            TreeItem selectedItem = this.treeView.getSelectedTreeItem();
            TreeItem parentItem = selectedItem.getParentItem();
            can = parentItem != null ? parentItem.getItems()[parentItem.getItemCount() - 1] != selectedItem : (roots = this.treeView.getTree().getItems())[roots.length - 1] != selectedItem;
        }
        return can;
    }

    public boolean canCopy(Object selectedObject) {
        boolean can = this.sm.getMode() == 8 && !this.sm.areChangesPending() && !this.isAllTypeSelected();
        return can;
    }

    public void run() {
        if (this.domainToPreExpand != null) {
            this.treeView.expandDomainNode(this.domainToPreExpand);
        } else {
            this.treeView.expandDomainNodes();
        }
        if (this.objectToPreSelect != null) {
            if (this.objectToPreSelect instanceof SystemXMLElementWrapper) {
                this.treeView.selectElement((SystemXMLElementWrapper)this.objectToPreSelect);
            } else {
                StructuredSelection selection = new StructuredSelection(this.objectToPreSelect);
                this.treeView.setSelection((ISelection)selection, true);
            }
        } else {
            this.objectToPreSelect = this.treeView.getTree().getItems()[0].getData();
            StructuredSelection selection = new StructuredSelection(this.objectToPreSelect);
            this.treeView.setSelection((ISelection)selection, true);
        }
    }

    public boolean areChangesPending() {
        return this.sm.areChangesPending();
    }
}

