/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.useractions.ui.uda;

import java.util.Vector;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.internal.useractions.ui.uda.ISystemUDSelectTypeListener;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDAResources;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDTypeManager;
import org.eclipse.rse.internal.useractions.ui.uda.actions.SystemWorkWithFileTypesAction;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;

public class SystemUDSelectTypesForm
implements SelectionListener {
    protected Shell shell;
    protected ISubSystem subsystem = null;
    protected ISubSystemConfiguration subsystemFactory = null;
    protected ISystemProfile profile;
    protected SystemUDTypeManager udtm;
    protected int domain;
    protected String groupLabel;
    protected String groupTooltip;
    protected String masterListLabel;
    protected String masterListTooltip;
    protected String ourListLabel;
    protected String ourListTooltip;
    protected String ALL_TYPE = "ALL";
    protected String[] inpMasterTypes = new String[]{this.ALL_TYPE};
    protected String[] inpSelectedTypes = new String[]{this.ALL_TYPE};
    protected Vector listeners = new Vector();
    protected Composite composite_prompts;
    protected List masterList;
    protected List ourList;
    protected Button addButton;
    protected Button rmvButton;
    protected Button editButton;
    protected Label verbageLabel;
    protected Label msgLine;
    protected String[] ALL_TYPE_ARRAY = new String[]{this.ALL_TYPE};

    public SystemUDSelectTypesForm(Shell shell, ISubSystem subsystem, SystemUDTypeManager mgr) {
        this.shell = shell;
        this.subsystem = subsystem;
        this.subsystemFactory = subsystem.getSubSystemConfiguration();
        this.profile = subsystem.getSystemProfile();
        this.udtm = mgr;
        this.setGroupLabel(SystemUDAResources.RESID_UDA_TYPE_LIST_LABEL, SystemUDAResources.RESID_UDA_TYPE_LIST_TOOLTIP);
        this.setMasterListLabel(SystemUDAResources.RESID_UDA_TYPE_LIST_MASTER_LABEL, SystemUDAResources.RESID_UDA_TYPE_LIST_MASTER_TOOLTIP);
        this.setSelectedListLabel(SystemUDAResources.RESID_UDA_TYPE_LIST_SELECTED_LABEL, SystemUDAResources.RESID_UDA_TYPE_LIST_SELECTED_TOOLTIP);
    }

    public SystemUDSelectTypesForm(Shell shell, ISubSystemConfiguration subsystemFactory, ISystemProfile profile, SystemUDTypeManager mgr) {
        this.shell = shell;
        this.subsystemFactory = subsystemFactory;
        this.profile = profile;
        this.udtm = mgr;
        this.setGroupLabel(SystemUDAResources.RESID_UDA_TYPE_LIST_LABEL, SystemUDAResources.RESID_UDA_TYPE_LIST_TOOLTIP);
        this.setMasterListLabel(SystemUDAResources.RESID_UDA_TYPE_LIST_MASTER_LABEL, SystemUDAResources.RESID_UDA_TYPE_LIST_MASTER_TOOLTIP);
        this.setSelectedListLabel(SystemUDAResources.RESID_UDA_TYPE_LIST_SELECTED_LABEL, SystemUDAResources.RESID_UDA_TYPE_LIST_SELECTED_TOOLTIP);
    }

    public void setAllType(String allType) {
        this.ALL_TYPE = allType;
        this.ALL_TYPE_ARRAY = new String[]{allType};
    }

    public void setGroupLabel(String label, String tooltip) {
        this.groupLabel = label;
        this.groupTooltip = tooltip;
    }

    public void setMasterListLabel(String label, String tooltip) {
        this.masterListLabel = label;
        this.masterListTooltip = tooltip;
    }

    public void setSelectedListLabel(String label, String tooltip) {
        this.ourListLabel = label;
        this.ourListTooltip = tooltip;
    }

    public void setVisible(boolean visible) {
        if (this.composite_prompts != null) {
            this.verbageLabel.setVisible(visible);
            this.composite_prompts.setVisible(visible);
        }
    }

    public void setDomain(int domain) {
        this.domain = domain;
    }

    public void addSelectionListener(ISystemUDSelectTypeListener l) {
        this.listeners.add(l);
    }

    public void setMasterTypes(String[] types) {
        this.inpMasterTypes = types;
        if (this.masterList != null) {
            this.masterList.removeAll();
            if (types != null) {
                this.masterList.setItems(types);
                if (types.length > 0) {
                    this.masterList.select(0);
                    this.addButton.setEnabled(true);
                }
            }
            this.setMessage(this.masterList);
        }
    }

    public void setTypes(String[] types) {
        this.inpSelectedTypes = types;
        if (this.ourList != null) {
            this.ourList.removeAll();
            if (types != null) {
                this.ourList.setItems(types);
                if (types.length > 0) {
                    this.ourList.select(0);
                }
            }
            this.enableDisableRmvButton();
            this.setMessage(this.ourList);
        }
    }

    public void resetMasterTypes() {
        this.setMasterTypes(this.ALL_TYPE_ARRAY);
    }

    public void resetTypes() {
        this.setTypes(this.ALL_TYPE_ARRAY);
    }

    public void reset() {
        this.resetMasterTypes();
        this.resetTypes();
    }

    public String[] getMasterTypes() {
        return this.masterList.getItems();
    }

    public String[] getTypes() {
        return this.ourList.getItems();
    }

    public Composite createContents(Composite parent, int span) {
        this.verbageLabel = SystemWidgetHelpers.createVerbiage((Composite)parent, (String)this.groupLabel, (int)span, (boolean)false, (int)-1);
        int nbrColumns = 3;
        this.composite_prompts = SystemWidgetHelpers.createFlushComposite((Composite)parent, (int)nbrColumns);
        this.composite_prompts.setToolTipText(this.groupTooltip);
        ((GridData)this.composite_prompts.getLayoutData()).horizontalSpan = span;
        ((GridLayout)this.composite_prompts.getLayout()).marginHeight = 0;
        ((GridLayout)this.composite_prompts.getLayout()).marginWidth = 2;
        this.masterList = this.createListBox(this.composite_prompts, this.masterListLabel, this.masterListTooltip);
        Composite middle_composite = SystemWidgetHelpers.createComposite((Composite)this.composite_prompts, (int)1);
        ((GridLayout)middle_composite.getLayout()).marginWidth = 0;
        SystemWidgetHelpers.createLabel((Composite)middle_composite, (String)"");
        Composite button_composite = SystemWidgetHelpers.createTightComposite((Composite)middle_composite, (int)1);
        this.addButton = SystemWidgetHelpers.createPushButton((Composite)button_composite, null, (String)SystemUDAResources.RESID_UDA_TYPE_ADD_BUTTON_LABEL, (String)SystemUDAResources.RESID_UDA_TYPE_ADD_BUTTON_TOOLTIP);
        this.rmvButton = SystemWidgetHelpers.createPushButton((Composite)button_composite, null, (String)SystemUDAResources.RESID_UDA_TYPE_RMV_BUTTON_LABEL, (String)SystemUDAResources.RESID_UDA_TYPE_RMV_BUTTON_TOOLTIP);
        this.editButton = SystemWidgetHelpers.createPushButton((Composite)button_composite, null, (String)SystemUDAResources.RESID_UDA_TYPE_EDIT_BUTTON_LABEL, (String)SystemUDAResources.RESID_UDA_TYPE_EDIT_BUTTON_TOOLTIP);
        Label bottomFiller = SystemWidgetHelpers.createLabel((Composite)button_composite, (String)"");
        ((GridData)bottomFiller.getLayoutData()).grabExcessVerticalSpace = true;
        ((GridData)bottomFiller.getLayoutData()).verticalAlignment = 4;
        this.ourList = this.createListBox(this.composite_prompts, this.ourListLabel, this.ourListTooltip);
        this.msgLine = SystemWidgetHelpers.createLabel((Composite)this.composite_prompts, (String)"");
        ((GridData)this.msgLine.getLayoutData()).horizontalSpan = nbrColumns;
        ((GridData)this.msgLine.getLayoutData()).widthHint = 150;
        this.masterList.addSelectionListener((SelectionListener)this);
        this.ourList.addSelectionListener((SelectionListener)this);
        this.addButton.addSelectionListener((SelectionListener)this);
        this.rmvButton.addSelectionListener((SelectionListener)this);
        this.editButton.addSelectionListener((SelectionListener)this);
        boolean enableAdd = false;
        boolean enableRmv = false;
        if (this.inpMasterTypes != null) {
            this.masterList.setItems(this.inpMasterTypes);
            if (this.inpMasterTypes.length > 0) {
                this.masterList.select(0);
                enableAdd = true;
            }
        }
        if (this.inpSelectedTypes != null) {
            this.ourList.setItems(this.inpSelectedTypes);
            if (this.inpSelectedTypes.length > 0) {
                this.ourList.select(0);
                enableRmv = !this.inpSelectedTypes[0].equals(this.ALL_TYPE);
            }
        }
        this.setMessage(this.ourList);
        this.addButton.setEnabled(enableAdd);
        this.rmvButton.setEnabled(enableRmv);
        return this.composite_prompts;
    }

    private List createListBox(Composite c, String label, String tooltip) {
        List listbox = SystemWidgetHelpers.createListBox((Composite)c, null, (boolean)false, (String)label, (String)tooltip);
        ((GridData)listbox.getLayoutData()).widthHint = 50;
        ((GridData)listbox.getLayoutData()).heightHint = 78;
        return listbox;
    }

    private void enableDisableRmvButton() {
        int selIdx = this.ourList.getSelectionIndex();
        this.rmvButton.setEnabled(selIdx >= 0 && (this.ourList.getItemCount() != 1 || !this.ourList.getItem(0).equals(this.ALL_TYPE)));
    }

    public void widgetSelected(SelectionEvent event) {
        Object src = event.getSource();
        boolean fireEvent = false;
        if (src == this.masterList) {
            int selIdx = this.masterList.getSelectionIndex();
            this.addButton.setEnabled(selIdx >= 0);
            this.enableDisableRmvButton();
            this.setMessage(this.masterList);
        } else if (src == this.ourList) {
            this.enableDisableRmvButton();
            this.setMessage(this.ourList);
        } else if (src == this.rmvButton) {
            int selIdx = this.ourList.getSelectionIndex();
            if (selIdx < 0) {
                return;
            }
            this.ourList.remove(selIdx);
            if (this.ourList.getItemCount() == 0) {
                this.ourList.add(this.ALL_TYPE);
            }
            this.enableDisableRmvButton();
            fireEvent = true;
        } else {
            String[] selected = this.masterList.getSelection();
            String selection = null;
            if (selected != null && selected.length > 0) {
                selection = selected[0];
            }
            int selIdx = -1;
            if (src == this.addButton) {
                if (selected == null || selection == null) {
                    this.addButton.setEnabled(false);
                    return;
                }
                selIdx = this.ourList.indexOf(selection);
                if (selIdx < 0) {
                    if (selection.equals(this.ALL_TYPE)) {
                        this.ourList.removeAll();
                    } else {
                        try {
                            this.ourList.remove(this.ALL_TYPE);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    this.ourList.add(selection);
                    this.enableDisableRmvButton();
                    fireEvent = true;
                }
            } else if (src == this.editButton) {
                SystemWorkWithFileTypesAction editTypesAction = null;
                editTypesAction = this.subsystem != null ? new SystemWorkWithFileTypesAction(this.shell, this.udtm.getActionSubSystem()) : new SystemWorkWithFileTypesAction(this.shell, this.subsystemFactory, this.profile);
                if (selection != null) {
                    editTypesAction.preSelectType(this.domain, selection);
                }
                editTypesAction.run();
                String outputSelectedTypeName = editTypesAction.getSelectedTypeName();
                int outputSelectedTypeDomain = editTypesAction.getSelectedTypeDomain();
                this.fireSelectedListChange(false, true);
                if (outputSelectedTypeName != null && outputSelectedTypeDomain == this.domain) {
                    this.masterList.setSelection(new String[]{outputSelectedTypeName});
                    this.masterList.showSelection();
                } else if (selection != null) {
                    this.masterList.setSelection(new String[]{selection});
                }
            }
        }
        if (fireEvent) {
            this.fireSelectedListChange(true, false);
        }
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }

    private void setMessage(List listbox) {
        int selIdx = listbox.getSelectionIndex();
        if (selIdx < 0) {
            this.msgLine.setText("");
        } else {
            String type = listbox.getItem(selIdx);
            String types = this.udtm.getTypesForTypeName(type, this.domain);
            if (types == null) {
                this.msgLine.setText("");
                this.msgLine.setToolTipText("");
            } else {
                String msg = null;
                msg = types.length() > 35 ? String.valueOf(type) + ": " + types.substring(0, 34) + "..." : String.valueOf(type) + ": " + types;
                this.msgLine.setText(msg);
                this.msgLine.setToolTipText(types);
            }
        }
    }

    private void fireSelectedListChange(boolean selectedListChanged, boolean masterListChanged) {
        int idx = 0;
        while (idx < this.listeners.size()) {
            if (selectedListChanged) {
                ((ISystemUDSelectTypeListener)this.listeners.elementAt(idx)).selectedTypeListChanged(this);
            }
            if (masterListChanged) {
                ((ISystemUDSelectTypeListener)this.listeners.elementAt(idx)).masterTypeListChanged(this);
            }
            ++idx;
        }
    }

    protected Label addSeparatorLine(Composite parent, int nbrColumns) {
        Label separator = new Label(parent, 258);
        GridData data = new GridData();
        data.horizontalSpan = nbrColumns;
        data.horizontalAlignment = 4;
        separator.setLayoutData((Object)data);
        return separator;
    }

    protected Label addFillerLine(Composite parent, int nbrColumns) {
        Label filler = new Label(parent, 16384);
        GridData data = new GridData();
        data.horizontalSpan = nbrColumns;
        data.horizontalAlignment = 4;
        filler.setLayoutData((Object)data);
        return filler;
    }
}

