/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.synchronize.filesystem.subscriber;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.rse.internal.synchronize.filesystem.subscriber.FileSystemSubscriber;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.mapping.ISynchronizationScopeManager;
import org.eclipse.team.core.mapping.provider.ResourceDiffTree;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.subscribers.SubscriberMergeContext;

public class FileSystemMergeContext
extends SubscriberMergeContext {
    public FileSystemMergeContext(ISynchronizationScopeManager manager) {
        super((Subscriber)FileSystemSubscriber.getInstance(), manager);
        this.initialize();
    }

    protected void makeInSync(IDiff diff, IProgressMonitor monitor) throws CoreException {
        IResource resource = ResourceDiffTree.getResourceFor((IDiff)diff);
        FileSystemSubscriber.getInstance().makeInSync(resource);
    }

    public void markAsMerged(IDiff diff, boolean inSyncHint, IProgressMonitor monitor) throws CoreException {
        IResource resource = ResourceDiffTree.getResourceFor((IDiff)diff);
        FileSystemSubscriber.getInstance().markAsMerged(resource, monitor);
    }

    public void reject(IDiff diff, IProgressMonitor monitor) throws CoreException {
        this.markAsMerged(diff, false, monitor);
    }

    public ISchedulingRule getMergeRule(IDiff node) {
        return ResourceDiffTree.getResourceFor((IDiff)node).getProject();
    }

    public IStatus merge(IDiff diff, boolean ignoreLocalChanges, IProgressMonitor monitor) throws CoreException {
        return super.merge(diff, ignoreLocalChanges, monitor);
    }
}

