/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.tests.subsystems.testsubsystem;

import junit.framework.AssertionFailedError;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.events.ISystemResourceChangeEvent;
import org.eclipse.rse.core.events.SystemResourceChangeEvent;
import org.eclipse.rse.core.filters.ISystemFilterContainer;
import org.eclipse.rse.core.filters.ISystemFilterPoolManager;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.ui.view.SystemView;
import org.eclipse.rse.internal.ui.view.SystemViewPart;
import org.eclipse.rse.tests.core.RSEWaitAndDispatchUtil;
import org.eclipse.rse.tests.core.connection.RSEBaseConnectionTestCase;
import org.eclipse.rse.tests.testsubsystem.TestSubSystemContainerNode;
import org.eclipse.rse.tests.testsubsystem.TestSubSystemNode;
import org.eclipse.rse.tests.testsubsystem.interfaces.ITestSubSystem;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;

public class TestSubsystemTestCase
extends RSEBaseConnectionTestCase {
    private ITestSubSystem testSubSystem;
    SystemView rseSystemView;

    protected void setUp() throws Exception {
        super.setUp();
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            public void run() {
                IViewPart viewPart = TestSubsystemTestCase.this.showView("org.eclipse.rse.ui.view.systemView", "org.eclipse.rse.ui.view.SystemPerspective");
                TestSubsystemTestCase.assertNotNull((String)"Failed to show required RSE remote systems view!", (Object)viewPart);
                if (viewPart instanceof SystemViewPart) {
                    TestSubsystemTestCase.this.rseSystemView = ((SystemViewPart)viewPart).getSystemView();
                }
            }
        });
        TestSubsystemTestCase.assertNotNull((String)"Failed to get remote system viewer instance from RSE remote systems view!", (Object)this.rseSystemView);
    }

    protected void tearDown() throws Exception {
        this.rseSystemView = null;
        this.testSubSystem = null;
        super.tearDown();
    }

    public void testAddAndDeleteDeepNodes() {
        if (this.isTestDisabled()) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            public void run() {
                TestSubsystemTestCase.this.internalTestAddAndDeleteNodes(true);
            }
        });
    }

    public void testAddAndDeleteFlatNodes() {
        if (this.isTestDisabled()) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            public void run() {
                TestSubsystemTestCase.this.internalTestAddAndDeleteNodes(false);
            }
        });
    }

    public void internalTestAddAndDeleteNodes(boolean deep) {
        IHost connection = this.getLocalSystemConnection();
        TestSubsystemTestCase.assertNotNull((String)"Failed to get local system connection", (Object)connection);
        Exception exception = null;
        String cause = null;
        this.testSubSystem = null;
        try {
            this.testSubSystem = this.getConnectionManager().getTestSubSystem(connection);
        }
        catch (Exception e) {
            exception = e;
            cause = e.getLocalizedMessage();
        }
        TestSubsystemTestCase.assertNull((String)("Failed to get test subsystem! Possible cause: " + cause), (Object)exception);
        TestSubsystemTestCase.assertNotNull((String)"No test subystem", (Object)this.testSubSystem);
        this.testSubSystem.removeAllChildNodes();
        ISystemRegistry registry = RSECorePlugin.getTheSystemRegistry();
        registry.invalidateFiltersFor((ISubSystem)this.testSubSystem);
        TestSubSystemContainerNode node = null;
        int i = 0;
        while (i < 100) {
            if (node == null) {
                node = new TestSubSystemContainerNode("node " + i);
                this.testSubSystem.addChildNode(node);
            } else {
                TestSubSystemContainerNode parentNode = node;
                node = new TestSubSystemContainerNode("node " + i);
                if (deep) {
                    parentNode.addChildNode(node);
                } else {
                    this.testSubSystem.addChildNode(node);
                }
            }
            ++i;
        }
        this.rseSystemView.refresh((Object)this.testSubSystem);
        this.rseSystemView.expandToLevel((Object)this.testSubSystem, -1);
        RSEWaitAndDispatchUtil.waitAndDispatch(1000L);
        this.testSubSystem.removeAllChildNodes();
        registry.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent((Object)this.testSubSystem, 82, (Object)this.testSubSystem));
        RSEWaitAndDispatchUtil.waitAndDispatch(1000L);
    }

    public void testBugzilla170728() {
        if (this.isTestDisabled()) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            public void run() {
                TestSubsystemTestCase.this.internalTestBugzilla170728();
            }
        });
    }

    public void internalTestBugzilla170728() {
        IHost connection = this.getLocalSystemConnection();
        TestSubsystemTestCase.assertNotNull((String)"Failed to get local system connection", (Object)connection);
        Exception exception = null;
        String cause = null;
        this.testSubSystem = null;
        try {
            this.testSubSystem = this.getConnectionManager().getTestSubSystem(connection);
        }
        catch (Exception e) {
            exception = e;
            cause = e.getLocalizedMessage();
        }
        TestSubsystemTestCase.assertNull((String)("Failed to get test subsystem! Possible cause: " + cause), (Object)exception);
        TestSubsystemTestCase.assertNotNull((String)"No test subystem", (Object)this.testSubSystem);
        RSECorePlugin.getTheSystemRegistry().invalidateFiltersFor((ISubSystem)this.testSubSystem);
        this.rseSystemView.refresh((Object)this.testSubSystem);
        RSEWaitAndDispatchUtil.waitAndDispatch(1000L);
        this.rseSystemView.expandToLevel((Object)this.testSubSystem, -1);
        RSEWaitAndDispatchUtil.waitAndDispatch(1000L);
        ISystemFilterPoolManager mgr = this.testSubSystem.getFilterPoolReferenceManager().getDefaultSystemFilterPoolManager();
        String[] strings = new String[]{"Node.*"};
        try {
            mgr.createSystemFilter((ISystemFilterContainer)mgr.getFirstDefaultSystemFilterPool(), "Node*", strings, "Node*");
            TestSubSystemNode node = new TestSubSystemNode("Node 1");
            this.testSubSystem.addChildNode(node);
            this.testSubSystem.addChildNode(new TestSubSystemNode("Node 2"));
            this.testSubSystem.addChildNode(new TestSubSystemNode("Node 3"));
            this.testSubSystem.addChildNode(new TestSubSystemNode("Node 4"));
            RSECorePlugin.getTheSystemRegistry().invalidateFiltersFor((ISubSystem)this.testSubSystem);
            this.rseSystemView.refresh((Object)this.testSubSystem);
            RSEWaitAndDispatchUtil.waitAndDispatch(1000L);
            this.rseSystemView.expandToLevel((Object)this.testSubSystem, -1);
            this.rseSystemView.refresh((Object)this.testSubSystem);
            RSEWaitAndDispatchUtil.waitAndDispatch(1000L);
            node.setName("Node 1 (changed)");
            ISystemRegistry registry = RSECorePlugin.getTheSystemRegistry();
            registry.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent((Object)node, 82, (Object)node));
            RSEWaitAndDispatchUtil.waitAndDispatch(10000L);
        }
        catch (Exception e) {
            AssertionFailedError err = new AssertionFailedError("Unhandled event loop exception");
            err.initCause(e);
            throw err;
        }
    }
}

