/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dstore.core.server;

import java.io.PrintWriter;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.dstore.core.server.ISystemService;
import org.eclipse.dstore.core.server.SystemServiceManager;

public class SecuredThread
extends Thread {
    public DataStore _dataStore;

    public SecuredThread() {
    }

    public SecuredThread(DataStore dataStore) {
        this(null, dataStore);
    }

    public SecuredThread(Runnable runnable, DataStore dataStore) {
        super(runnable);
        this._dataStore = dataStore;
    }

    public SecuredThread(Runnable runnable, String threadName, DataStore dataStore) {
        this(null, runnable, threadName, dataStore);
    }

    public SecuredThread(ThreadGroup group, Runnable runnable, DataStore dataStore) {
        super(group, runnable);
        this._dataStore = dataStore;
    }

    public SecuredThread(ThreadGroup group, Runnable runnable, String threadName, DataStore dataStore) {
        super(group, runnable, threadName);
        this._dataStore = dataStore;
    }

    public void setDataStore(DataStore dataStore) {
        this._dataStore = dataStore;
    }

    public void run() {
        if (this._dataStore != null && this._dataStore.getClient() != null) {
            this._dataStore.getClient().getLogger().logInfo(this.getClass().toString(), "SecuredThread.run()...");
        }
        try {
            ISystemService systemService = SystemServiceManager.getInstance().getSystemService();
            if (systemService != null) {
                systemService.setThreadSecurity(this._dataStore.getClient());
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            System.exit(-1);
        }
        catch (Throwable e) {
            e.printStackTrace(new PrintWriter(System.err));
        }
        super.run();
        if (this._dataStore != null && this._dataStore.getClient() != null) {
            this._dataStore.getClient().getLogger().logInfo(this.getClass().toString(), "... end of SecuredThread.run()");
        }
    }

    public void start() {
        try {
            super.start();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            System.exit(-1);
        }
    }
}

