/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.tests.subsystems.files;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.model.SystemStartHere;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.services.files.IFileService;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.IFileServiceSubSystem;
import org.eclipse.rse.tests.subsystems.files.FileServiceArchiveTest;
import org.eclipse.rse.tests.subsystems.files.FileServiceArchiveTestDStore;
import org.eclipse.rse.ui.RSEUIPlugin;

public class FileServiceArchiveTestDStoreWindows
extends FileServiceArchiveTest {
    private boolean fPreference_ALERT_SSL;
    private boolean fPreference_ALERT_NONSSL;

    public FileServiceArchiveTestDStoreWindows(String name) {
        super(name);
        this.setTargetName("windows");
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("FileServiceArchiveTestDStoreWindows");
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStoreWindows.class, (String)"testCopyBatchToArchiveFile"));
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStoreWindows.class, (String)"testCopyBatchToVirtualFileLevelOne"));
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStoreWindows.class, (String)"testCopyBatchToVirtualFileLevelTwo"));
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStoreWindows.class, (String)"testCopyBatchVirtualFile"));
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStoreWindows.class, (String)"testCopyBatchVirtualFileLevelTwo"));
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStoreWindows.class, (String)"testCopyToArchiveFile"));
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStoreWindows.class, (String)"testCopyToVirtualFileLevelOne"));
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStoreWindows.class, (String)"testCopyToVirtualFileLevelTwo"));
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStoreWindows.class, (String)"testCopyVirtualBatchToArchiveFile"));
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStoreWindows.class, (String)"testCopyVirtualBatchToVirtualFileLevelOne"));
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStoreWindows.class, (String)"testCopyVirtualBatchToVirtualFileLevelTwo"));
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStoreWindows.class, (String)"testCopyVirtualFile"));
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStoreWindows.class, (String)"testCopyVirtualFileLevelTwo"));
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStoreWindows.class, (String)"testCreateZipFile"));
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStoreWindows.class, (String)"testMoveToArchiveFile"));
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStoreWindows.class, (String)"testMoveToVirtualFileLevelOne"));
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStoreWindows.class, (String)"testMoveToVirtualFileLevelTwo"));
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStoreWindows.class, (String)"testMoveVirtualFile"));
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStoreWindows.class, (String)"testMoveVirtualFileLevelTwo"));
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStoreWindows.class, (String)"testRenameVirtualFile"));
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStoreWindows.class, (String)"testSuperTransferLocalToRemote"));
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStore.class, (String)"testSuperTransferDStoreToLocal"));
        return suite;
    }

    protected void setupFileSubSystem() {
        IHost dstoreHost = this.getWindowsHost();
        FileServiceArchiveTestDStoreWindows.assertTrue((dstoreHost != null ? 1 : 0) != 0);
        ISystemRegistry sr = SystemStartHere.getSystemRegistry();
        ISubSystem[] ss = sr.getServiceSubSystems(dstoreHost, IFileService.class);
        int i = 0;
        while (i < ss.length) {
            if (ss[i] instanceof IFileServiceSubSystem) {
                this.fss = (IFileServiceSubSystem)ss[i];
                this.fs = this.fss.getFileService();
            }
            ++i;
        }
        IHost localHost = this.getLocalSystemConnection();
        sr = SystemStartHere.getSystemRegistry();
        ss = sr.getServiceSubSystems(localHost, IFileService.class);
        int i2 = 0;
        while (i2 < ss.length) {
            if (ss[i2] instanceof IFileServiceSubSystem) {
                this.localFss = (IFileServiceSubSystem)ss[i2];
            }
            ++i2;
        }
        try {
            IConnectorService connectionService = this.fss.getConnectorService();
            connectionService.acquireCredentials(false);
            connectionService.connect(this.mon);
        }
        catch (Exception e) {
            FileServiceArchiveTestDStoreWindows.assertTrue((String)("Exception creating temp dir " + e.getStackTrace().toString()), (boolean)false);
        }
    }

    public void tearDown() throws Exception {
        IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
        store.setValue("org.eclipse.rse.preferences.alert.ssl", this.fPreference_ALERT_SSL);
        store.setValue("org.eclipse.rse.preferences.alert.nonssl", this.fPreference_ALERT_NONSSL);
        super.tearDown();
    }
}

