/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.importexport.files;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.rse.internal.importexport.files.IRemoteFileImportDescriptionReader;
import org.eclipse.rse.internal.importexport.files.RemoteFileImportData;
import org.eclipse.rse.internal.importexport.files.RemoteFileImportExportActionDelegate;
import org.eclipse.rse.internal.importexport.files.RemoteImportWizard;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.swt.widgets.Shell;
import org.xml.sax.SAXException;

public class RemoteFileOpenImportWizardActionDelegate
extends RemoteFileImportExportActionDelegate {
    public void run(IAction action) {
        Shell parent = this.getShell();
        RemoteFileImportData importData = null;
        IFile file = this.getDescriptionFile(this.getSelection());
        if (file == null) {
            SystemBasePlugin.logError((String)"No description file found");
            return;
        }
        try {
            importData = this.readRemoteFileImportData(file);
        }
        catch (CoreException e) {
            SystemBasePlugin.logError((String)("Error occured trying to read description file" + file.getFullPath()), (Throwable)e);
            return;
        }
        catch (IOException e) {
            SystemBasePlugin.logError((String)("Error occured trying to read description file" + file.getFullPath()), (Throwable)e);
            return;
        }
        catch (SAXException e) {
            SystemBasePlugin.logError((String)("Error occured trying to read description file" + file.getFullPath()), (Throwable)e);
            return;
        }
        if (importData == null) {
            SystemBasePlugin.logError((String)"No export data");
            return;
        }
        RemoteImportWizard wizard = new RemoteImportWizard();
        wizard.init(this.getWorkbench(), importData);
        WizardDialog dialog = new WizardDialog(parent, (IWizard)wizard);
        dialog.create();
        dialog.open();
    }

    private RemoteFileImportData readRemoteFileImportData(IFile description) throws CoreException, IOException, SAXException {
        Assert.isLegal((boolean)description.isAccessible());
        Assert.isNotNull((Object)description.getFileExtension());
        Assert.isLegal((boolean)description.getFileExtension().equals("rimpfd"));
        RemoteFileImportData importData = new RemoteFileImportData();
        IRemoteFileImportDescriptionReader reader = null;
        try {
            reader = importData.createImportDescriptionReader(description.getContents());
            reader.read(importData);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return importData;
    }
}

