/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.useractions.api.ui.compile;

import java.util.ArrayList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.internal.useractions.api.files.compile.ISystemCompileManagerAdapter;
import org.eclipse.rse.internal.useractions.api.ui.compile.SystemCompileAction;
import org.eclipse.rse.internal.useractions.api.ui.compile.SystemWorkWithCompileCommandsAction;
import org.eclipse.rse.internal.useractions.files.compile.UniversalCompileManager;
import org.eclipse.rse.internal.useractions.ui.compile.SystemCompileCommand;
import org.eclipse.rse.internal.useractions.ui.compile.SystemCompileManager;
import org.eclipse.rse.internal.useractions.ui.compile.SystemCompileProfile;
import org.eclipse.rse.internal.useractions.ui.compile.SystemCompileType;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.rse.ui.view.SystemAdapterHelpers;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CompoundContributionItem;

public class SystemDynamicCompileMenu
extends CompoundContributionItem {
    protected IContributionItem[] getContributionItems() {
        ISystemCompileManagerAdapter adapter;
        ArrayList<Object> returnedItemList = new ArrayList<Object>();
        ISystemProfile[] activeProfiles = RSECorePlugin.getTheSystemRegistry().getActiveSystemProfiles();
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        ISelection selection = window.getSelectionService().getSelection();
        Object firstSelection = null;
        if (selection instanceof IStructuredSelection) {
            firstSelection = ((IStructuredSelection)selection).getFirstElement();
        }
        if (firstSelection == null) {
            return new IContributionItem[0];
        }
        Shell shell = SystemBasePlugin.getActiveWorkbenchShell();
        ISystemRemoteElementAdapter rmtAdapter = SystemAdapterHelpers.getRemoteAdapter((Object)firstSelection);
        ISubSystem subsystem = rmtAdapter.getSubSystem(firstSelection);
        ISubSystemConfiguration ssc = subsystem.getSubSystemConfiguration();
        SystemCompileManager compileManager = null;
        if (firstSelection instanceof IAdaptable && (adapter = (ISystemCompileManagerAdapter)((IAdaptable)firstSelection).getAdapter(ISystemCompileManagerAdapter.class)) != null) {
            compileManager = adapter.getSystemCompileManager(ssc);
        }
        if (compileManager == null) {
            compileManager = new UniversalCompileManager();
            compileManager.setSubSystemFactory(ssc);
        }
        int idx = 0;
        while (idx < activeProfiles.length) {
            SystemCompileManager thisCompileManager;
            SystemCompileProfile compileProfile;
            SystemCompileType compileType;
            String srcType = null;
            if (rmtAdapter != null) {
                srcType = rmtAdapter.getRemoteSourceType(firstSelection);
                if (srcType == null) {
                    srcType = "null";
                } else if (srcType.equals("")) {
                    srcType = "blank";
                }
            }
            if (compileManager != null && (compileType = (compileProfile = (thisCompileManager = compileManager).getCompileProfile(activeProfiles[idx])).getCompileType(srcType)) != null) {
                SystemCompileCommand[] cmds = compileType.getCompileCommandsArray();
                int idx2 = 0;
                while (idx2 < cmds.length) {
                    SystemCompileAction action = new SystemCompileAction(shell, cmds[idx2], false);
                    action.setSelection(selection);
                    ActionContributionItem testContribution = new ActionContributionItem((IAction)action);
                    returnedItemList.add(testContribution);
                    ++idx2;
                }
            }
            ++idx;
        }
        if (returnedItemList.size() > 0) {
            returnedItemList.add(new Separator());
        }
        SystemWorkWithCompileCommandsAction workWithCompileCommandAction = new SystemWorkWithCompileCommandsAction(shell, true, subsystem, compileManager);
        workWithCompileCommandAction.setSelection(selection);
        ActionContributionItem testContribution = new ActionContributionItem((IAction)workWithCompileCommandAction);
        returnedItemList.add(testContribution);
        IContributionItem[] list = returnedItemList.toArray(new IContributionItem[0]);
        return list;
    }
}

