/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.dstore.universal.miners.command;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.dstore.core.model.Handler;
import org.eclipse.rse.internal.dstore.universal.miners.command.CommandMinerThread;

public class OutputHandler
extends Handler {
    private DataInputStream _reader;
    private boolean _isStdError;
    private boolean _isTerminal;
    private CommandMinerThread _commandThread;
    private boolean _isShell;
    private static int MAX_OFFSET = 10000;
    private boolean _endOfStream = false;
    private List _encodings;

    public OutputHandler(DataInputStream reader, String qualifier, boolean isTerminal, boolean isStdError, boolean isShell, CommandMinerThread commandThread) {
        this._reader = reader;
        this._isStdError = isStdError;
        this._isTerminal = isTerminal;
        this._commandThread = commandThread;
        this._isShell = isShell;
        this._encodings = new ArrayList();
        String system = System.getProperty("os.name").toLowerCase();
        String specialEncoding = System.getProperty("dstore.stdin.encoding");
        if (specialEncoding != null) {
            this._encodings.add(specialEncoding);
        }
        if (system.startsWith("z")) {
            this._encodings.add("IBM-1047");
        } else {
            this._encodings.add(System.getProperty("file.encoding"));
        }
    }

    public void handle() {
        String[] lines = this.readLines();
        if (lines != null) {
            int i = 0;
            while (i < lines.length) {
                String ln = lines[i];
                if (ln.indexOf(10) > 0) {
                    String[] lns = ln.split("\n");
                    int j = 0;
                    while (j < lns.length) {
                        String line = this.convertSpecialCharacters(lns[j]);
                        this._commandThread.interpretLine(line, this._isStdError);
                        ++j;
                    }
                } else {
                    String line = this.convertSpecialCharacters(ln);
                    this._commandThread.interpretLine(line, this._isStdError);
                }
                ++i;
            }
            if (!this._isTerminal) {
                this.doPrompt();
            }
            this._commandThread.refreshStatus();
        } else {
            this.finish();
        }
    }

    private String convertSpecialCharacters(String input) {
        if (this._commandThread._supportsCharConversion) {
            StringBuffer output = new StringBuffer();
            int idx = 0;
            while (idx < input.length()) {
                char currChar = input.charAt(idx);
                switch (currChar) {
                    case '&': {
                        output.append("&#38;");
                        break;
                    }
                    case ';': {
                        output.append("&#59;");
                        break;
                    }
                    case '\b': {
                        int len = output.length() - 1;
                        if (len < 0) break;
                        output.deleteCharAt(len);
                        break;
                    }
                    default: {
                        output.append(currChar);
                    }
                }
                ++idx;
            }
            return output.toString();
        }
        return input;
    }

    private void doPrompt() {
        block5: {
            try {
                if (this._reader.available() != 0 || this._isStdError || !this._isShell || this._isTerminal) break block5;
                try {
                    Thread.sleep(200L);
                    if (this._reader.available() == 0) {
                        String cwd = this._commandThread.getCWD();
                        this._commandThread.createPrompt(String.valueOf(cwd) + '>', cwd);
                    }
                }
                catch (Exception exception) {}
            }
            catch (IOException e) {
                this._commandThread._dataStore.trace((Throwable)e);
            }
        }
    }

    private int checkAvailable() {
        return this.checkAvailable(100);
    }

    private int checkAvailable(int time) {
        try {
            int available = this._reader.available();
            if (available <= 0) {
                OutputHandler.sleep((long)time);
                available = this._reader.available();
            }
            return available;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String[] readLines() {
        if (this._endOfStream) {
            return null;
        }
        String[] output = null;
        int available = this.checkAvailable();
        int lookahead = 0;
        if (available == 0) {
            try {
                lookahead = this._reader.read();
            }
            catch (IOException iOException) {
                return null;
            }
            if (lookahead == -1) {
                return null;
            }
            available = this._reader.available() + 1;
        }
        byte[] readBytes = new byte[available];
        int numRead = 0;
        if (lookahead > 0) {
            readBytes[0] = (byte)lookahead;
            numRead = this._reader.read(readBytes, 1, available - 1) + 1;
        } else {
            numRead = this._reader.read(readBytes, 0, available);
        }
        if (numRead == -1) {
            return null;
        }
        if (readBytes[numRead - 1] == -1) {
            this._endOfStream = true;
        }
        int encodingIndex = 0;
        while (encodingIndex < this._encodings.size()) {
            String encoding = (String)this._encodings.get(encodingIndex);
            try {
                boolean endLine;
                String fullOutput = new String(readBytes, 0, numRead, encoding);
                if (fullOutput == null) continue;
                StringTokenizer tokenizer = new StringTokenizer(fullOutput, "\n\r");
                int numTokens = tokenizer.countTokens();
                if (numTokens == 0) {
                    output = new String[]{fullOutput};
                    return output;
                }
                output = new String[numTokens];
                int index = 0;
                while (tokenizer.hasMoreTokens()) {
                    output[index] = tokenizer.nextToken();
                    ++index;
                }
                String lastLine = output[index - 1];
                boolean bl = endLine = fullOutput.endsWith("\n") || fullOutput.endsWith("\r") || fullOutput.endsWith(">") || fullOutput.endsWith("% ");
                if (!this._endOfStream && !endLine) {
                    byte[] lastBytes = new byte[MAX_OFFSET];
                    int lastIndex = 0;
                    available = this.checkAvailable();
                    if (available == 0) {
                        try {
                            lookahead = this._reader.read();
                        }
                        catch (IOException iOException) {}
                        if (lookahead != -1) {
                            available = this._reader.available() + 1;
                        }
                    }
                    if (available > 0) {
                        while (!this._endOfStream && lastIndex < MAX_OFFSET) {
                            if (available == 0) {
                                String suffix = new String(lastBytes, 0, lastIndex, encoding);
                                output[index - 1] = String.valueOf(lastLine) + suffix.substring(0, suffix.length() - 2);
                                return output;
                            }
                            int c = this._reader.read();
                            if (c == -1) {
                                this._endOfStream = true;
                                String suffix = new String(lastBytes, 0, lastIndex, encoding);
                                output[index - 1] = String.valueOf(lastLine) + suffix.substring(0, suffix.length() - 2);
                                return output;
                            }
                            lastBytes[lastIndex] = (byte)c;
                            String osname = System.getProperty("os.name").toLowerCase();
                            byte lf = 13;
                            byte nl = 10;
                            if (osname.startsWith("z")) {
                                lf = 21;
                                nl = 13;
                            }
                            if (lastBytes[lastIndex] == lf || lastBytes[lastIndex] == nl) {
                                String suffix = new String(lastBytes, 0, lastIndex + 1, encoding);
                                output[index - 1] = String.valueOf(lastLine) + suffix.substring(0, suffix.length() - 1);
                                return output;
                            }
                            ++lastIndex;
                            available = this.checkAvailable();
                        }
                    }
                }
                return output;
            }
            catch (Exception e) {
                try {
                    this._commandThread._dataStore.trace((Throwable)e);
                }
                catch (Exception e2) {
                    this._commandThread._dataStore.trace((Throwable)e2);
                    break;
                }
            }
        }
        return output;
    }

    public synchronized void waitForInput() {
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {}
    }
}

