/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dstore.internal.core.util;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.dstore.core.model.Handler;
import org.eclipse.dstore.internal.core.util.MemoryManager;

public class DataElementRemover
extends Handler {
    private ArrayList _queue;
    public static final int DEFAULT_EXPIRY_TIME = 60;
    public static final int DEFAULT_INTERVAL_TIME = 60;
    private int _intervalTime = 60000;
    private int _expiryTime = 60000;
    public static final String EXPIRY_TIME_PROPERTY_NAME = "SPIRIT_EXPIRY_TIME";
    public static final String INTERVAL_TIME_PROPERTY_NAME = "SPIRIT_INTERVAL_TIME";
    public MemoryManager _memoryManager;
    private int _lastLive = 0;
    private int _lastFree = 0;
    private long _lastMem = 0L;
    private boolean DEBUG = false;
    private long _lastDumpTime = System.currentTimeMillis();

    public DataElementRemover(DataStore dataStore) {
        this._memoryManager = new MemoryManager(dataStore);
        this._dataStore = dataStore;
        this._queue = new ArrayList();
        this.getTimes();
        this.setWaitTime(this._intervalTime);
    }

    protected void getTimes() {
        try {
            String expiryTime = System.getProperty(EXPIRY_TIME_PROPERTY_NAME);
            if (expiryTime != null && !expiryTime.equals("")) {
                this._expiryTime = Integer.parseInt(expiryTime) * 1000;
            }
        }
        catch (Exception exception) {
            System.out.println("Invalid spirit expiry time property, using default.");
        }
        try {
            String intervalTime = System.getProperty(INTERVAL_TIME_PROPERTY_NAME);
            if (intervalTime != null && !intervalTime.equals("")) {
                this._intervalTime = Integer.parseInt(intervalTime) * 1000;
            }
        }
        catch (Exception exception) {
            System.out.println("Invalid spirit interval time property, using default.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addToQueueForRemoval(DataElement element) {
        QueueItem item;
        if (this.isMemoryThresholdExceeded()) {
            this.clearQueue(true);
            return;
        }
        if (!(!this._dataStore.isDoSpirit() || element.isReference() || element.isSpirit() || element.isDescriptor() || element.isDeleted() || this._queue.contains(item = new QueueItem(element, System.currentTimeMillis())))) {
            ArrayList arrayList = this._queue;
            synchronized (arrayList) {
                this._queue.add(item);
            }
            this.notifyInput();
        }
    }

    private boolean isMemoryThresholdExceeded() {
        return this._memoryManager.isThresholdExceeded();
    }

    public void handle() {
        this.clearQueue(false);
    }

    private void logMemory() {
        long mem = Runtime.getRuntime().totalMemory();
        int liveElements = this._dataStore.getNumElements();
        int freeElements = this._dataStore.getNumRecycled();
        if (mem != this._lastMem || liveElements != this._lastLive || freeElements != this._lastFree) {
            this._dataStore.memLog("                                        ");
            this._dataStore.memLog("Total heap size: " + mem);
            this._dataStore.memLog("Number of live DataStore elements: " + liveElements);
            this._dataStore.memLog("Number of free DataStore elements: " + freeElements);
            this._lastMem = mem;
            this._lastLive = liveElements;
            this._lastFree = freeElements;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clearQueue(boolean force) {
        if (!this._dataStore.isDoSpirit()) {
            if (this._queue.size() > 0) {
                this._dataStore.memLog("Clearing queue of size " + this._queue.size() + ". DSTORE_SPIRIT_ON not set or set to false.");
                ArrayList arrayList = this._queue;
                synchronized (arrayList) {
                    this._queue.clear();
                }
            }
            this.logMemory();
            return;
        }
        if (this._queue.size() > 0) {
            int queueSize = this._queue.size();
            ArrayList<DataElement> toRefresh = new ArrayList<DataElement>();
            long currentTime = System.currentTimeMillis();
            int i = queueSize - 1;
            while (i >= 0) {
                QueueItem qitem = null;
                ArrayList arrayList = this._queue;
                synchronized (arrayList) {
                    qitem = (QueueItem)this._queue.get(i);
                }
                long deltaTime = currentTime - qitem.timeStamp;
                if (force || deltaTime > (long)this._expiryTime) {
                    DataElement toBeDisconnected = qitem.dataElement;
                    toBeDisconnected.setSpirit(true);
                    toBeDisconnected.setUpdated(false);
                    DataElement parent = toBeDisconnected.getParent();
                    if (!toRefresh.contains(parent)) {
                        toRefresh.add(parent);
                    }
                    ArrayList arrayList2 = this._queue;
                    synchronized (arrayList2) {
                        this._queue.remove(i);
                    }
                }
                --i;
            }
            if (!toRefresh.isEmpty()) {
                this._dataStore.refresh(toRefresh);
                System.gc();
            }
            if (this.DEBUG && currentTime - this._lastDumpTime > 100000L) {
                this._lastDumpTime = currentTime;
                this.printHashmap();
            }
            this.logMemory();
        }
    }

    public void run() {
        while (this._keepRunning) {
            try {
                Thread.sleep(this._intervalTime);
                Thread.yield();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                this.finish();
                return;
            }
            this.handle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printHashmap() {
        HashMap map;
        this._dataStore.memLog("                                        ");
        this._dataStore.memLog("------------------------------Current Hashmap--------------------------------:");
        HashMap hashMap = map = this._dataStore.getHashMap();
        synchronized (hashMap) {
            DataElement[] elements = map.values().toArray(new DataElement[map.size()]);
            int i = 0;
            while (i < elements.length) {
                String type;
                DataElement element = elements[i];
                if (!(element.isDescriptor() || (type = element.getType()).equals("abstracted by") || type.equals("abstracts") || type.equals("Environment Variable") || type.equals("system.property"))) {
                    if (type.equals("status")) {
                        String value = element.getValue();
                        DataElement parent = element.getParent();
                        this._dataStore.memLog("Command: " + parent.getName() + " is " + value);
                    } else {
                        this._dataStore.memLog(element.toString());
                    }
                }
                ++i;
            }
        }
        this._dataStore.memLog("-----------------------------------------------------------------------------:");
    }

    protected class QueueItem {
        public DataElement dataElement;
        public long timeStamp;

        public QueueItem(DataElement element, long stamp) {
            this.dataElement = element;
            this.timeStamp = stamp;
        }

        public boolean equals(QueueItem item) {
            return item.dataElement == this.dataElement;
        }
    }
}

