/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.core.filters;

public class HostOwnedFilterPoolPattern {
    private static final String prefix = "CN-";
    private static final int start = "CN-".length();
    private String suffix;

    public HostOwnedFilterPoolPattern(String configurationId) {
        this.suffix = "-" + configurationId;
    }

    public boolean matches(String filterPoolName) {
        return filterPoolName.startsWith(prefix) && filterPoolName.endsWith(this.suffix);
    }

    public String extract(String filterPoolName) {
        String result = null;
        if (this.matches(filterPoolName)) {
            int length = filterPoolName.length() - (prefix.length() + this.suffix.length());
            result = filterPoolName.substring(start, start + length);
        }
        return result;
    }

    public String make(String hostName) {
        return prefix + hostName + this.suffix;
    }
}

