/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.agent.rt_c722md;

import java.lang.instrument.Instrumentation;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Random;
import org.jacoco.agent.rt_c722md.CoverageTransformer;
import org.jacoco.agent.rt_c722md.IExceptionLogger;
import org.jacoco.agent.rt_c722md.controller.IAgentController;
import org.jacoco.agent.rt_c722md.controller.LocalController;
import org.jacoco.agent.rt_c722md.controller.TcpClientController;
import org.jacoco.agent.rt_c722md.controller.TcpServerController;
import org.jacoco.agent.rt_c722md.core.runtime.AgentOptions;
import org.jacoco.agent.rt_c722md.core.runtime.IRuntime;
import org.jacoco.agent.rt_c722md.core.runtime.ModifiedSystemClassRuntime;

public class JacocoAgent {
    private final AgentOptions options;
    private final IExceptionLogger logger;
    private IRuntime runtime;
    private IAgentController controller;

    public JacocoAgent(AgentOptions options, IExceptionLogger logger) {
        this.options = options;
        this.logger = logger;
    }

    public JacocoAgent(String options, IExceptionLogger logger) {
        this(new AgentOptions(options), logger);
    }

    public void init(Instrumentation inst) throws Exception {
        this.runtime = this.createRuntime(inst);
        String sessionId = this.options.getSessionId();
        if (sessionId == null) {
            sessionId = this.createSessionId();
        }
        this.runtime.setSessionId(sessionId);
        this.runtime.startup();
        inst.addTransformer(new CoverageTransformer(this.runtime, this.options, this.logger));
        this.controller = this.createAgentController();
        this.controller.startup(this.options, this.runtime);
    }

    private IAgentController createAgentController() {
        AgentOptions.OutputMode controllerType = this.options.getOutput();
        switch (controllerType) {
            case file: {
                return new LocalController();
            }
            case tcpserver: {
                return new TcpServerController(this.logger);
            }
            case tcpclient: {
                return new TcpClientController(this.logger);
            }
        }
        throw new AssertionError((Object)controllerType);
    }

    private String createSessionId() {
        String host;
        try {
            host = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            host = "unknownhost";
        }
        return host + "-" + Integer.toHexString(new Random().nextInt());
    }

    protected IRuntime createRuntime(Instrumentation inst) throws Exception {
        return ModifiedSystemClassRuntime.createFor(inst, "java/util/UUID");
    }

    public void shutdown() {
        try {
            if (this.options.getDumpOnExit()) {
                this.controller.writeExecutionData();
            }
            this.controller.shutdown();
        }
        catch (Exception e) {
            this.logger.logExeption(e);
        }
    }

    public static void premain(String options, Instrumentation inst) throws Exception {
        final JacocoAgent agent = new JacocoAgent(options, new IExceptionLogger(){

            public void logExeption(Exception ex) {
                ex.printStackTrace();
            }
        });
        agent.init(inst);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                agent.shutdown();
            }
        });
    }
}

