/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.synchronize;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.rse.internal.importexport.files.RemoteFileExportData;
import org.eclipse.rse.internal.importexport.files.RemoteFileImportData;
import org.eclipse.rse.internal.importexport.files.UniFilePlus;
import org.eclipse.rse.internal.synchronize.ISynchronizeData;
import org.eclipse.rse.internal.synchronize.RSESyncUtils;
import org.eclipse.rse.internal.synchronize.provisional.SynchronizeFilter;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.ui.SystemBasePlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizeData
implements ISynchronizeData {
    private String descriptionFilePath;
    private String remoteLocation;
    private IPath localLocation;
    private List<IResource> elements;
    private int synchronizeType;
    private boolean saveSettings;
    private boolean createSelectionOnly;
    private boolean createDirectoryStructure;
    private boolean overWriteExistingFiles;
    private boolean reviewSynchronzie;

    public SynchronizeData() {
        this.setDescriptionFilePath(null);
        this.setRemoteLocation(null);
        this.setLocalLocation(null);
        this.setElements(null);
        this.setSynchronizeType(0);
        this.setSaveSettings(false);
        this.setCreateDirectoryStructure(false);
        this.setCreateSelectionOnly(false);
        this.setOverWriteExistingFiles(false);
    }

    public SynchronizeData(RemoteFileExportData data) {
        this.setDescriptionFilePath(data.getDescriptionFilePath());
        this.setRemoteLocation(data.getDestination());
        this.setElements(data.getElements());
        this.setLocalLocation(data.getContainerPath());
        this.setSynchronizeType(2);
        this.setSaveSettings(data.isSaveSettings());
        this.setCreateDirectoryStructure(data.isCreateDirectoryStructure());
        this.setCreateSelectionOnly(data.isCreateSelectionOnly());
        this.setReviewSynchronzie(data.isReviewSynchronize());
        this.setOverWriteExistingFiles(data.isOverWriteExistingFiles());
    }

    public SynchronizeData(RemoteFileImportData data) throws SystemMessageException, CoreException {
        IRemoteFile remoteRoot = ((UniFilePlus)data.getSource()).getRemoteFile();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IContainer localRoot = (IContainer)workspace.getRoot().findMember(data.getContainerPath());
        ArrayList<IPath> paths = new ArrayList<IPath>();
        List resources = data.getElements();
        for (UniFilePlus uniFilePlus : resources) {
            paths.add((IPath)new Path(uniFilePlus.getRemoteFile().getAbsolutePathPlusConnection()));
        }
        SynchronizeFilter filter = new SynchronizeFilter(paths);
        ArrayList<IResource> localResource = new ArrayList<IResource>();
        RSESyncUtils.getSynchronizeResources((IResource)localRoot, remoteRoot, remoteRoot, filter, localResource);
        this.setLocalLocation(data.getContainerPath());
        this.setDescriptionFilePath(data.getDescriptionFilePath());
        this.setRemoteLocation(((UniFilePlus)data.getSource()).getRemoteFile().getAbsolutePathPlusConnection());
        this.setElements(localResource);
        this.setSynchronizeType(1);
        this.setSaveSettings(data.isSaveSettings());
        this.setCreateDirectoryStructure(data.isCreateDirectoryStructure());
        this.setCreateSelectionOnly(data.isCreateSelectionOnly());
        this.setOverWriteExistingFiles(data.isOverWriteExistingFiles());
    }

    @Override
    public IFile getDescriptionFile() {
        String pathString = this.getDescriptionFilePath();
        if (pathString == null) {
            return null;
        }
        Path path = new Path(pathString);
        if (path.isValidPath(path.toString()) && path.segmentCount() >= 2) {
            return SystemBasePlugin.getWorkspace().getRoot().getFile((IPath)path);
        }
        return null;
    }

    @Override
    public String getDescriptionFilePath() {
        return this.descriptionFilePath;
    }

    @Override
    public void setDescriptionFilePath(String descriptionFilePath) {
        this.descriptionFilePath = descriptionFilePath;
    }

    @Override
    public String getRemoteLocation() {
        return this.remoteLocation;
    }

    @Override
    public void setRemoteLocation(String location) {
        this.remoteLocation = location;
    }

    @Override
    public IPath getLocalLocation() {
        return this.localLocation;
    }

    @Override
    public void setLocalLocation(IPath location) {
        this.localLocation = location;
    }

    @Override
    public List<IResource> getElements() {
        return this.elements;
    }

    @Override
    public void setElements(List<IResource> elements) {
        this.elements = elements;
    }

    @Override
    public int getSynchronizeType() {
        return this.synchronizeType;
    }

    @Override
    public void setSynchronizeType(int synchronizeType) {
        this.synchronizeType = synchronizeType;
    }

    @Override
    public boolean isSaveSettings() {
        return this.saveSettings;
    }

    @Override
    public void setSaveSettings(boolean saveSettings) {
        this.saveSettings = saveSettings;
    }

    @Override
    public boolean isCreateSelectionOnly() {
        return this.createSelectionOnly;
    }

    @Override
    public void setCreateSelectionOnly(boolean createSelectionOnly) {
        this.createSelectionOnly = createSelectionOnly;
    }

    @Override
    public boolean isOverWriteExistingFiles() {
        return this.overWriteExistingFiles;
    }

    @Override
    public void setOverWriteExistingFiles(boolean overWriteExistingFiles) {
        this.overWriteExistingFiles = overWriteExistingFiles;
    }

    @Override
    public boolean isCreateDirectoryStructure() {
        return this.createDirectoryStructure;
    }

    @Override
    public void setCreateDirectoryStructure(boolean createDirectoryStructure) {
        this.createDirectoryStructure = createDirectoryStructure;
    }

    public boolean isReviewSynchronzie() {
        return this.reviewSynchronzie;
    }

    public void setReviewSynchronzie(boolean reviewSynchronzie) {
        this.reviewSynchronzie = reviewSynchronzie;
    }

    public RemoteFileExportData getExportData() {
        RemoteFileExportData data = new RemoteFileExportData();
        data.setElements(this.getElements());
        data.setCreateDirectoryStructure(this.isCreateDirectoryStructure());
        data.setCreateSelectionOnly(this.isCreateSelectionOnly());
        data.setOverWriteExistingFiles(this.isOverWriteExistingFiles());
        data.setSaveSettings(this.isSaveSettings());
        data.setDescriptionFilePath(this.getDescriptionFilePath());
        data.setDestination(this.getRemoteLocation());
        return data;
    }
}

