/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.services.ssh.files.scp;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.Session;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.rse.internal.services.ssh.files.scp.ScpFileService;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;

public class ScpFileUtils {
    public static final String EOL_STRING = "\n";
    public static final String TARGET_SEPARATOR = "/";
    public static final String EXEC_CHANNEL = "exec";
    public static final String QUOTATION_MARK = "\"";
    public static char EOL_CHAR = "\n".charAt(0);
    public static char TARGET_SEPARATOR_CHAR = "/".charAt(0);

    protected static String concat(String parentDir, String fileName) {
        if (parentDir == null || parentDir.length() == 0) {
            return fileName;
        }
        StringBuffer path = new StringBuffer(parentDir);
        if (!parentDir.endsWith(TARGET_SEPARATOR)) {
            path.append(TARGET_SEPARATOR_CHAR);
        }
        path.append(fileName);
        return path.toString();
    }

    public static ChannelExec openExecChannel(Session sess) throws Exception {
        return (ChannelExec)sess.openChannel(EXEC_CHANNEL);
    }

    public static ChannelExec openExecChannel(Session sess, String cmd) throws Exception {
        ChannelExec ch = ScpFileUtils.openExecChannel(sess);
        if (ch != null) {
            ch.setCommand(cmd);
        }
        return ch;
    }

    public static String execCommand(Session sess, String command) throws Exception {
        ChannelExec ch = ScpFileUtils.openExecChannel(sess, command);
        ch.setInputStream(null);
        ch.setErrStream((OutputStream)System.err, true);
        InputStream is = ch.getInputStream();
        ch.connect();
        String str = ScpFileUtils.readStream(ch);
        is.close();
        ch.disconnect();
        return str;
    }

    public static String execCommandSafe(Session session, String command) throws SystemMessageException {
        String rc = null;
        try {
            rc = ScpFileUtils.execCommand(session, command);
        }
        catch (Exception e) {
            ScpFileService.throwSystemException(e);
        }
        return rc;
    }

    public static String escapePath(String path) {
        if (path.indexOf(32) < 0) {
            return path;
        }
        return QUOTATION_MARK + path + QUOTATION_MARK;
    }

    protected static String concatEscape(String parentDir, String fileName) {
        return ScpFileUtils.escapePath(ScpFileUtils.concat(parentDir, fileName));
    }

    public static String readString(InputStream is) throws IOException {
        StringBuffer buf = new StringBuffer();
        int rc = 0;
        while ((rc = is.read()) != EOL_CHAR) {
            buf.append((char)rc);
        }
        return buf.toString();
    }

    public static String readStream(ChannelExec ch) throws IOException {
        InputStream is = ch.getInputStream();
        byte[] buf = new byte[1024];
        String rc = "";
        while (!ch.isClosed() || is.available() > 0) {
            int cnt = is.read(buf, 0, buf.length);
            if (cnt < 0) break;
            rc = String.valueOf(rc) + new String(buf, 0, cnt);
        }
        return rc;
    }
}

