/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.wizards.newconnection;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.wizards.newconnection.RSENewConnectionWizardRegistry;
import org.eclipse.rse.ui.wizards.newconnection.RSENewConnectionWizardSelectionTreeDataManager;
import org.eclipse.rse.ui.wizards.newconnection.RSENewConnectionWizardSelectionTreeElement;
import org.eclipse.rse.ui.wizards.registries.IRSEWizardCategory;
import org.eclipse.rse.ui.wizards.registries.IRSEWizardRegistryElement;
import org.eclipse.rse.ui.wizards.registries.RSEWizardSelectionTreeContentProvider;
import org.eclipse.rse.ui.wizards.registries.RSEWizardSelectionTreeElement;
import org.eclipse.rse.ui.wizards.registries.RSEWizardSelectionTreeLabelProvider;
import org.eclipse.rse.ui.wizards.registries.RSEWizardSelectionTreePatternFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public class RSENewConnectionWizardSelectionPage
extends WizardPage {
    private final String helpId = "org.eclipse.rse.ui.wncc0000";
    private static final String EXPANDED_CATEGORIES_SETTINGS_ID = "filteredTree.expandedCatogryIds";
    private static final String[] DEFAULT_EXPANDED_CATEGORY_IDS = new String[]{"org.eclipse.rse.ui.wizards.newconnection.default.category"};
    private IRSESystemType[] restrictedSystemTypes;
    private RSENewConnectionWizardRegistry wizardRegistry;
    private FilteredTree filteredTree;
    private PatternFilter filteredTreeFilter;
    private ViewerFilter filteredTreeWizardStateFilter;
    private RSENewConnectionWizardSelectionTreeDataManager filteredTreeDataManager;
    static /* synthetic */ Class class$0;

    public RSENewConnectionWizardSelectionPage(RSENewConnectionWizardRegistry wizardRegistry) {
        super("RSENewConnectionWizardSelectionPage");
        this.setTitle(this.getDefaultTitle());
        this.setDescription(this.getDefaultDescription());
        this.wizardRegistry = wizardRegistry;
    }

    public RSENewConnectionWizardSelectionPage() {
        this(RSENewConnectionWizardRegistry.getInstance());
    }

    protected String getDefaultTitle() {
        return SystemResources.RESID_NEWCONN_MAIN_PAGE_TITLE;
    }

    protected String getDefaultDescription() {
        return SystemResources.RESID_NEWCONN_MAIN_PAGE_DESCRIPTION;
    }

    public void restrictToSystemTypes(IRSESystemType[] systemTypes) {
        this.restrictedSystemTypes = systemTypes;
    }

    public IRSESystemType[] getRestrictToSystemTypes() {
        return this.restrictedSystemTypes;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(768));
        label.setText(String.valueOf(SystemResources.RESID_CONNECTION_SYSTEMTYPE_LABEL) + ":");
        label.setLayoutData((Object)new GridData(768));
        this.filteredTreeFilter = new RSEWizardSelectionTreePatternFilter();
        this.filteredTree = new FilteredTree(composite, 2820, this.filteredTreeFilter);
        this.filteredTree.setBackground(parent.getDisplay().getSystemColor(22));
        GridData layoutData = new GridData(1808);
        layoutData.heightHint = 325;
        layoutData.widthHint = 450;
        this.filteredTree.setLayoutData((Object)layoutData);
        TreeViewer treeViewer = this.filteredTree.getViewer();
        treeViewer.setContentProvider((IContentProvider)new RSEWizardSelectionTreeContentProvider());
        treeViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new RSEWizardSelectionTreeLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator()));
        treeViewer.setComparator((ViewerComparator)new NewConnectionWizardViewerComparator());
        this.filteredTreeWizardStateFilter = new NewConnectionWizardStateFilter();
        treeViewer.addFilter(this.filteredTreeWizardStateFilter);
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                RSENewConnectionWizardSelectionPage.this.onSelectionChanged();
            }
        });
        treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (event.getSelection() instanceof IStructuredSelection) {
                    TreeViewer viewer;
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    Object element = selection.getFirstElement();
                    if (element instanceof RSENewConnectionWizardSelectionTreeElement) {
                        if (RSENewConnectionWizardSelectionPage.this.canFlipToNextPage()) {
                            RSENewConnectionWizardSelectionPage.this.getWizard().getContainer().showPage(RSENewConnectionWizardSelectionPage.this.getNextPage());
                        }
                    } else if (event.getViewer() instanceof TreeViewer && (viewer = (TreeViewer)event.getViewer()).isExpandable(element)) {
                        viewer.setExpandedState(element, !viewer.getExpandedState(element));
                    }
                }
            }
        });
        this.filteredTreeDataManager = new RSENewConnectionWizardSelectionTreeDataManager(this.wizardRegistry);
        treeViewer.setInput((Object)this.filteredTreeDataManager);
        Dialog.applyDialogFont((Control)composite);
        this.setControl((Control)composite);
        this.restoreWidgetValues();
        this.initializeSelection(treeViewer);
        this.filteredTree.getFilterControl().setFocus();
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.rse.ui.wncc0000");
    }

    protected void initializeSelection(TreeViewer treeViewer) {
        IRSESystemType systemType;
        RSENewConnectionWizardSelectionTreeElement treeElement;
        IStructuredSelection selection;
        ISelectionProvider selectionProvider;
        if (treeViewer == null) {
            return;
        }
        if (this.getWizard() instanceof ISelectionProvider && (selectionProvider = (ISelectionProvider)this.getWizard()).getSelection() instanceof IStructuredSelection && (selection = (IStructuredSelection)selectionProvider.getSelection()).getFirstElement() instanceof IRSESystemType && (treeElement = this.filteredTreeDataManager.getTreeElementForSystemType(systemType = (IRSESystemType)selection.getFirstElement())) != null) {
            treeViewer.setSelection((ISelection)new StructuredSelection((Object)treeElement), true);
        }
    }

    protected void onSelectionChanged() {
        IWizardContainer container;
        IWizard wizard = this.getWizard();
        if (wizard instanceof ISelectionProvider && this.filteredTree.getViewer().getSelection() instanceof IStructuredSelection) {
            ISelectionProvider selectionProvider = (ISelectionProvider)wizard;
            IStructuredSelection filteredTreeSelection = (IStructuredSelection)this.filteredTree.getViewer().getSelection();
            if (filteredTreeSelection.getFirstElement() instanceof RSENewConnectionWizardSelectionTreeElement) {
                RSENewConnectionWizardSelectionTreeElement element = (RSENewConnectionWizardSelectionTreeElement)filteredTreeSelection.getFirstElement();
                selectionProvider.setSelection((ISelection)new StructuredSelection((Object)element.getSystemType()));
                if (element.getDescription() != null) {
                    this.setDescription(element.getDescription());
                } else if (!this.getDefaultDescription().equals(this.getDescription())) {
                    this.setDescription(this.getDefaultDescription());
                }
            } else {
                selectionProvider.setSelection(null);
            }
        }
        if ((container = this.getContainer()) != null && container.getCurrentPage() != null) {
            container.updateWindowTitle();
            container.updateTitleBar();
            container.updateButtons();
        }
    }

    protected IDialogSettings getDialogSettings() {
        String sectionName;
        IDialogSettings settings = super.getDialogSettings();
        if (settings == null) {
            settings = RSEUIPlugin.getDefault().getDialogSettings();
        }
        if (settings.getSection(sectionName = ((Object)((Object)this)).getClass().getName()) == null) {
            settings.addNewSection(sectionName);
        }
        settings = settings.getSection(sectionName);
        return settings;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible) {
            this.saveWidgetValues();
        } else if (this.filteredTree != null && this.filteredTree.getViewer() != null) {
            this.filteredTree.getViewer().refresh();
            this.initializeSelection(this.filteredTree.getViewer());
        }
    }

    public void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] expandedCategories = settings.getArray(EXPANDED_CATEGORIES_SETTINGS_ID);
            if (expandedCategories == null) {
                expandedCategories = DEFAULT_EXPANDED_CATEGORY_IDS;
            }
            if (expandedCategories != null) {
                ArrayList<RSEWizardSelectionTreeElement> expanded = new ArrayList<RSEWizardSelectionTreeElement>();
                int i = 0;
                while (i < expandedCategories.length) {
                    RSEWizardSelectionTreeElement treeElement;
                    IRSEWizardRegistryElement registryElement;
                    String categoryId = expandedCategories[i];
                    if (categoryId != null && !"".equals(categoryId.trim()) && (registryElement = this.wizardRegistry.findElementById(categoryId)) instanceof IRSEWizardCategory && (treeElement = this.filteredTreeDataManager.getTreeElementForCategory((IRSEWizardCategory)registryElement)) != null) {
                        expanded.add(treeElement);
                    }
                    ++i;
                }
                if (expanded.size() > 0) {
                    this.filteredTree.getViewer().setExpandedElements(expanded.toArray());
                }
            }
        }
    }

    public void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            ArrayList<String> expandedCategories = new ArrayList<String>();
            Object[] expanded = this.filteredTree.getViewer().getVisibleExpandedElements();
            int i = 0;
            while (i < expanded.length) {
                IRSEWizardRegistryElement registryElement;
                if (expanded[i] instanceof RSEWizardSelectionTreeElement && (registryElement = ((RSEWizardSelectionTreeElement)expanded[i]).getWizardRegistryElement()) instanceof IRSEWizardCategory) {
                    expandedCategories.add(((IRSEWizardCategory)registryElement).getId());
                }
                ++i;
            }
            settings.put(EXPANDED_CATEGORIES_SETTINGS_ID, expandedCategories.toArray(new String[expandedCategories.size()]));
        }
    }

    private class NewConnectionWizardStateFilter
    extends ViewerFilter {
        private NewConnectionWizardStateFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            Object[] children = ((ITreeContentProvider)((AbstractTreeViewer)viewer).getContentProvider()).getChildren(element);
            if (children.length > 0) {
                return this.filter(viewer, element, children).length > 0;
            }
            if (element instanceof RSENewConnectionWizardSelectionTreeElement) {
                ViewerFilter filter;
                IRSESystemType systemType = ((RSENewConnectionWizardSelectionTreeElement)element).getSystemType();
                if (systemType == null) {
                    return false;
                }
                IRSESystemType[] restricted = RSENewConnectionWizardSelectionPage.this.getRestrictToSystemTypes();
                if (restricted != null && restricted.length > 0 && !Arrays.asList(restricted).contains(systemType)) {
                    return false;
                }
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.jface.viewers.ViewerFilter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((filter = (ViewerFilter)systemType.getAdapter((Class)clazz)) != null && !filter.select(viewer, parentElement, element)) {
                    return false;
                }
                if (!systemType.isEnabled()) {
                    return false;
                }
            }
            return true;
        }
    }

    private class NewConnectionWizardViewerComparator
    extends ViewerComparator {
        private NewConnectionWizardViewerComparator() {
        }

        public boolean isSorterProperty(Object element, String property) {
            return property.equals("org.eclipse.jface.text");
        }
    }
}

