/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.tests.subsystems.files;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.IFileServiceSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;

public class FileServiceHelper {
    protected static int nextLocationCounter = 0;
    private static final long MASK = 0xFFFFFFFFL;

    public static IPath getTempDir() {
        String tempPath = System.getProperty("java.io.tmpdir");
        try {
            tempPath = new File(tempPath).getCanonicalPath();
        }
        catch (IOException iOException) {}
        return new Path(tempPath);
    }

    public static String getRandomLocation(IFileServiceSubSystem fss, String parentPath, String baseName, IProgressMonitor mon) {
        String resultName = FileServiceHelper.computeRandomLocation(fss, baseName);
        try {
            IRemoteFile remoteFile = fss.getRemoteFileObject(String.valueOf(parentPath) + fss.getSeparator() + resultName, mon);
            boolean fileExist = remoteFile != null && remoteFile.exists();
            while (fileExist) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
                resultName = FileServiceHelper.computeRandomLocation(fss, baseName);
                remoteFile = fss.getRemoteFileObject(String.valueOf(parentPath) + fss.getSeparator() + resultName, mon);
                boolean bl = fileExist = remoteFile != null && remoteFile.exists();
            }
        }
        catch (Exception exception) {
            return null;
        }
        return resultName;
    }

    public static String computeRandomLocation(IFileServiceSubSystem fss, String path) {
        long segment = (long)(++nextLocationCounter) << 32 | System.currentTimeMillis() & 0xFFFFFFFFL;
        return String.valueOf(path) + Long.toString(segment);
    }
}

