/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.time4sys.trace;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ResourceEventKind implements Enumerator
{
    ACQUIRED(0, "ACQUIRED", "ACQUIRED"),
    RELEASED(1, "RELEASED", "RELEASED"),
    REQUESTED(2, "REQUESTED", "REQUESTED");

    public static final int ACQUIRED_VALUE = 0;
    public static final int RELEASED_VALUE = 1;
    public static final int REQUESTED_VALUE = 2;
    private static final ResourceEventKind[] VALUES_ARRAY;
    public static final List<ResourceEventKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ResourceEventKind[]{ACQUIRED, RELEASED, REQUESTED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ResourceEventKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ResourceEventKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ResourceEventKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ResourceEventKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ResourceEventKind get(int value) {
        switch (value) {
            case 0: {
                return ACQUIRED;
            }
            case 1: {
                return RELEASED;
            }
            case 2: {
                return REQUESTED;
            }
        }
        return null;
    }

    private ResourceEventKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

