/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.time4sys.transformations;

import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.time4sys.builder.design.posix.PosixSporadicServerBuilder;
import org.polarsys.time4sys.design.DesignModel;
import org.polarsys.time4sys.mapping.Link;
import org.polarsys.time4sys.marte.grm.FixedPriorityParameters;
import org.polarsys.time4sys.marte.grm.GrmPackage;
import org.polarsys.time4sys.marte.grm.PeriodicServerParameters;
import org.polarsys.time4sys.marte.srm.SoftwareSchedulableResource;
import org.polarsys.time4sys.model.time4sys.Project;
import org.polarsys.time4sys.model.time4sys.Transformation;
import org.polarsys.time4sys.transformations.AbstractTransformation;

public class PriorityUrgencyInverter
extends AbstractTransformation {
    public static final String TRANS_NAME = "Priority to Urgency".intern();
    private int highestPriorityValue = Integer.MIN_VALUE;
    private int highestOrderValue = Integer.MIN_VALUE;
    private int lowestOrderValue = Integer.MAX_VALUE;
    private List<FixedPriorityParameters> fpParamsToBeUpdated = new LinkedList<FixedPriorityParameters>();
    private List<PeriodicServerParameters> pssParamsToBeUpdated = new LinkedList<PeriodicServerParameters>();
    private List<SoftwareSchedulableResource> pssToBeUpdated = new LinkedList<SoftwareSchedulableResource>();
    private Set<Link> linksToBeUpdated = new LinkedHashSet<Link>();
    private final PriorityUrgencyInverterConfiguration config;

    public static PriorityUrgencyInverterConfiguration defaultCfg() {
        return new PriorityUrgencyInverterConfiguration();
    }

    public static Transformation transform(Project project, DesignModel source) {
        return PriorityUrgencyInverter.transform(PriorityUrgencyInverter.defaultCfg(), project, source);
    }

    public static Transformation transform(PriorityUrgencyInverterConfiguration cfg, Project project, DesignModel source) {
        return new PriorityUrgencyInverter(cfg, project, source).transform();
    }

    public PriorityUrgencyInverter(PriorityUrgencyInverterConfiguration cfg, Project project, DesignModel source) {
        super(project, source, TRANS_NAME);
        this.config = cfg;
    }

    @Override
    protected void finalize(DesignModel target) {
        if (!this.config.isZeroBased) {
            ++this.highestPriorityValue;
        }
        if (this.config.withPSSOrder && this.highestOrderValue != Integer.MIN_VALUE) {
            this.highestPriorityValue = this.highestPriorityValue + this.highestOrderValue - this.lowestOrderValue;
        }
        for (FixedPriorityParameters fpParam : this.fpParamsToBeUpdated) {
            fpParam.setPriority(this.highestPriorityValue - fpParam.getPriority());
        }
        for (PeriodicServerParameters pssParam : this.pssParamsToBeUpdated) {
            pssParam.setBackgroundPriority(this.highestPriorityValue - pssParam.getBackgroundPriority());
        }
        for (SoftwareSchedulableResource pss : this.pssToBeUpdated) {
            PosixSporadicServerBuilder pssBuilder = PosixSporadicServerBuilder.as(pss);
            int updatedPriority = pssBuilder.getBackgroundPriority();
            if (!this.config.withPSSOrder) continue;
            int order = pssBuilder.getOrder();
            pssBuilder.ofBackgroundPriority(updatedPriority - order + this.lowestOrderValue);
            pssBuilder.unsetOrder();
        }
        for (Link lnk : this.linksToBeUpdated) {
            lnk.setRationale(this.mainCtx);
        }
    }

    @Override
    public void copied(EObject source, Link lnk, EObject theCopy) {
        if (source instanceof FixedPriorityParameters) {
            PeriodicServerParameters pssParam;
            FixedPriorityParameters fpParam = (FixedPriorityParameters)source;
            if (fpParam.eIsSet((EStructuralFeature)GrmPackage.eINSTANCE.getFixedPriorityParameters_Priority())) {
                this.highestPriorityValue = Integer.max(this.highestPriorityValue, fpParam.getPriority());
                this.fpParamsToBeUpdated.add((FixedPriorityParameters)theCopy);
                this.linksToBeUpdated.add(lnk);
            }
            if (source instanceof PeriodicServerParameters && (pssParam = (PeriodicServerParameters)source).eIsSet((EStructuralFeature)GrmPackage.eINSTANCE.getPeriodicServerParameters_BackgroundPriority())) {
                this.highestPriorityValue = Integer.max(this.highestPriorityValue, pssParam.getBackgroundPriority());
                this.pssParamsToBeUpdated.add((PeriodicServerParameters)theCopy);
                this.linksToBeUpdated.add(lnk);
            }
        }
        if (source instanceof SoftwareSchedulableResource && this.config.withPSSOrder && PosixSporadicServerBuilder.hasPSSOrder((SoftwareSchedulableResource)source)) {
            int order = PosixSporadicServerBuilder.as((SoftwareSchedulableResource)source).getOrder();
            this.highestOrderValue = Integer.max(this.highestOrderValue, order);
            this.lowestOrderValue = Integer.min(this.lowestOrderValue, order);
            this.pssToBeUpdated.add((SoftwareSchedulableResource)theCopy);
            this.linksToBeUpdated.add(lnk);
        }
    }

    public static class PriorityUrgencyInverterConfiguration {
        protected final boolean withPSSOrder;
        protected final boolean isZeroBased;

        public PriorityUrgencyInverterConfiguration() {
            this.withPSSOrder = true;
            this.isZeroBased = true;
        }

        public PriorityUrgencyInverterConfiguration(boolean withPSS, boolean isZeroBased) {
            this.withPSSOrder = withPSS;
            this.isZeroBased = isZeroBased;
        }

        public PriorityUrgencyInverterConfiguration withoutPSSOrder() {
            return new PriorityUrgencyInverterConfiguration(false, this.isZeroBased);
        }

        public PriorityUrgencyInverterConfiguration zeroBased() {
            return new PriorityUrgencyInverterConfiguration(this.withPSSOrder, true);
        }

        public PriorityUrgencyInverterConfiguration oneBased() {
            return new PriorityUrgencyInverterConfiguration(this.withPSSOrder, false);
        }

        public PriorityUrgencyInverterConfiguration inverseOnly() {
            return new PriorityUrgencyInverterConfiguration(false, false);
        }
    }
}

