/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.crypto;

import java.security.GeneralSecurityException;
import sun.security.krb5.KrbCryptoException;
import sun.security.krb5.internal.crypto.CksumType;
import sun.security.krb5.internal.crypto.Des3;

public class HmacSha1Des3KdCksumType
extends CksumType {
    @Override
    public int confounderSize() {
        return 8;
    }

    @Override
    public int cksumType() {
        return 12;
    }

    @Override
    public boolean isKeyed() {
        return true;
    }

    @Override
    public int cksumSize() {
        return 20;
    }

    @Override
    public int keyType() {
        return 2;
    }

    @Override
    public int keySize() {
        return 24;
    }

    @Override
    public byte[] calculateChecksum(byte[] byArray, int n, byte[] byArray2, int n2) throws KrbCryptoException {
        try {
            return Des3.calculateChecksum(byArray2, n2, byArray, 0, n);
        }
        catch (GeneralSecurityException generalSecurityException) {
            KrbCryptoException krbCryptoException = new KrbCryptoException(generalSecurityException.getMessage());
            krbCryptoException.initCause(generalSecurityException);
            throw krbCryptoException;
        }
    }

    @Override
    public boolean verifyChecksum(byte[] byArray, int n, byte[] byArray2, byte[] byArray3, int n2) throws KrbCryptoException {
        try {
            byte[] byArray4 = Des3.calculateChecksum(byArray2, n2, byArray, 0, n);
            return HmacSha1Des3KdCksumType.isChecksumEqual(byArray3, byArray4);
        }
        catch (GeneralSecurityException generalSecurityException) {
            KrbCryptoException krbCryptoException = new KrbCryptoException(generalSecurityException.getMessage());
            krbCryptoException.initCause(generalSecurityException);
            throw krbCryptoException;
        }
    }
}

