/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.SunJCE;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SealedObject;
import sun.misc.ObjectInputFilter;
import sun.misc.SharedSecrets;

final class SealedObjectForKeyProtector
extends SealedObject {
    static final long serialVersionUID = -3650226485480866989L;
    private static final String KEY_SERIAL_FILTER = "jceks.key.serialFilter";

    SealedObjectForKeyProtector(Serializable serializable, Cipher cipher) throws IOException, IllegalBlockSizeException {
        super(serializable, cipher);
    }

    SealedObjectForKeyProtector(SealedObject sealedObject) {
        super(sealedObject);
    }

    AlgorithmParameters getParameters() {
        AlgorithmParameters algorithmParameters = null;
        if (this.encodedParams != null) {
            try {
                algorithmParameters = AlgorithmParameters.getInstance("PBE", SunJCE.getInstance());
                algorithmParameters.init(this.encodedParams);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new RuntimeException("SunJCE provider is not configured properly");
            }
            catch (IOException iOException) {
                throw new RuntimeException("Parameter failure: " + iOException.getMessage());
            }
        }
        return algorithmParameters;
    }

    final Key getKey(Cipher cipher, int n) throws IOException, ClassNotFoundException, IllegalBlockSizeException, BadPaddingException {
        Throwable throwable = null;
        try (ObjectInputStream objectInputStream = SharedSecrets.getJavaxCryptoSealedObjectAccess().getExtObjectInputStream((SealedObject)this, cipher);){
            AccessController.doPrivileged(() -> {
                ObjectInputFilter.Config.setObjectInputFilter((ObjectInputStream)objectInputStream, (ObjectInputFilter)new DeserializationChecker(n));
                return null;
            });
            try {
                Key key;
                Key key2 = key = (Key)objectInputStream.readObject();
                return key2;
            }
            catch (InvalidClassException invalidClassException) {
                try {
                    String string = invalidClassException.getMessage();
                    if (string.contains("REJECTED")) {
                        throw new IOException("Rejected by the jceks.key.serialFilter or jdk.serialFilter property", invalidClassException);
                    }
                    throw invalidClassException;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
    }

    private static class DeserializationChecker
    implements ObjectInputFilter {
        private static final ObjectInputFilter OWN_FILTER;
        private final int maxLength;

        private DeserializationChecker(int n) {
            this.maxLength = n;
        }

        public ObjectInputFilter.Status checkInput(ObjectInputFilter.FilterInfo filterInfo) {
            ObjectInputFilter objectInputFilter;
            if (filterInfo.arrayLength() > (long)this.maxLength) {
                return ObjectInputFilter.Status.REJECTED;
            }
            if (filterInfo.serialClass() == Object.class) {
                return ObjectInputFilter.Status.UNDECIDED;
            }
            if (OWN_FILTER != null && (objectInputFilter = OWN_FILTER.checkInput(filterInfo)) != ObjectInputFilter.Status.UNDECIDED) {
                return objectInputFilter;
            }
            objectInputFilter = ObjectInputFilter.Config.getSerialFilter();
            if (objectInputFilter != null) {
                return objectInputFilter.checkInput(filterInfo);
            }
            return ObjectInputFilter.Status.UNDECIDED;
        }

        static {
            String string = AccessController.doPrivileged(() -> {
                String string = System.getProperty(SealedObjectForKeyProtector.KEY_SERIAL_FILTER);
                if (string != null) {
                    return string;
                }
                return Security.getProperty(SealedObjectForKeyProtector.KEY_SERIAL_FILTER);
            });
            OWN_FILTER = string == null ? null : ObjectInputFilter.Config.createFilter((String)string);
        }
    }
}

