/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.consumer;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import jdk.jfr.EventType;
import jdk.jfr.ValueDescriptor;
import jdk.jfr.consumer.RecordedObject;
import jdk.jfr.consumer.RecordedStackTrace;
import jdk.jfr.consumer.RecordedThread;
import jdk.jfr.consumer.TimeConverter;

public final class RecordedEvent
extends RecordedObject {
    private final EventType eventType;
    private final long startTime;
    final long endTime;

    RecordedEvent(EventType eventType, List<ValueDescriptor> list, Object[] objectArray, long l, long l2, TimeConverter timeConverter) {
        super(list, objectArray, timeConverter);
        this.eventType = eventType;
        this.startTime = l;
        this.endTime = l2;
    }

    public RecordedStackTrace getStackTrace() {
        return this.getTyped("stackTrace", RecordedStackTrace.class, null);
    }

    public RecordedThread getThread() {
        return this.getTyped("eventThread", RecordedThread.class, null);
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public Instant getStartTime() {
        return Instant.ofEpochSecond(0L, this.startTime);
    }

    public Instant getEndTime() {
        return Instant.ofEpochSecond(0L, this.endTime);
    }

    public Duration getDuration() {
        return Duration.ofNanos(this.endTime - this.startTime);
    }

    @Override
    public List<ValueDescriptor> getFields() {
        return this.getEventType().getFields();
    }
}

